import tech.ostack.kform.AbsolutePathFragment
import tech.ostack.kform.PathFragment

/** [Path fragment][PathFragment] wrapper for use from JavaScript. */
@JsExport
@JsName("PathFragment")
public sealed class PathFragmentJs {
    internal abstract val fragmentKt: PathFragment

    public override fun equals(other: Any?): Boolean =
        when {
            this === other -> true
            other !is PathFragmentJs -> false
            else -> fragmentKt == other.fragmentKt
        }

    public override fun hashCode(): Int = fragmentKt.hashCode()

    public override fun toString(): String = fragmentKt.toString()

    public object Root : PathFragmentJs() {
        override val fragmentKt = PathFragment.Root
    }

    public object CurrentPath : PathFragmentJs() {
        override val fragmentKt = PathFragment.CurrentPath
    }

    public object ParentPath : PathFragmentJs() {
        override val fragmentKt = PathFragment.ParentPath
    }
}

/** [Absolute path fragment][AbsolutePathFragment] wrapper for use from JavaScript. */
@JsExport
@JsName("AbsolutePathFragment")
public sealed class AbsolutePathFragmentJs : PathFragmentJs() {
    abstract override val fragmentKt: AbsolutePathFragment

    public class Id(fragmentKtOrId: Any) : AbsolutePathFragmentJs() {
        override val fragmentKt =
            when (fragmentKtOrId) {
                is AbsolutePathFragment.Id -> fragmentKtOrId
                else -> AbsolutePathFragment.Id(fragmentKtOrId)
            }

        public val id: String
            get() = fragmentKt.id
    }

    public object CollectionEnd : AbsolutePathFragmentJs() {
        override val fragmentKt = AbsolutePathFragment.CollectionEnd
    }

    public object Wildcard : AbsolutePathFragmentJs() {
        override val fragmentKt = AbsolutePathFragment.Wildcard
    }

    public object RecursiveWildcard : AbsolutePathFragmentJs() {
        override val fragmentKt = AbsolutePathFragment.RecursiveWildcard
    }
}

/**
 * Function which converts a [PathFragment] into its JavaScript representation to be used from
 * JavaScript.
 */
internal fun PathFragment.toJs(): PathFragmentJs =
    when (this) {
        is PathFragment.Root -> PathFragmentJs.Root
        is PathFragment.CurrentPath -> PathFragmentJs.CurrentPath
        is PathFragment.ParentPath -> PathFragmentJs.ParentPath
        else -> (this as AbsolutePathFragment).toJs()
    }

/**
 * Function which converts an [AbsolutePathFragment] into its JavaScript representation to be used
 * from JavaScript.
 */
internal fun AbsolutePathFragment.toJs(): AbsolutePathFragmentJs =
    when (this) {
        is AbsolutePathFragment.Id -> AbsolutePathFragmentJs.Id(this)
        is AbsolutePathFragment.CollectionEnd -> AbsolutePathFragmentJs.CollectionEnd
        is AbsolutePathFragment.Wildcard -> AbsolutePathFragmentJs.Wildcard
        is AbsolutePathFragment.RecursiveWildcard -> AbsolutePathFragmentJs.RecursiveWildcard
    }
