import tech.ostack.kform.FormManagerEvent
import tech.ostack.kform.StateEvent
import tech.ostack.kform.ValueEvent

/** [Form manager event][FormManagerEvent] wrapper for use from JavaScript. */
@JsExport
@JsName("FormManagerEvent")
public sealed interface FormManagerEventJs<T> {
    public val path: AbsolutePathJs
    public val schema: SchemaJs<T>
}

/** [Value event][ValueEvent] wrapper for use from JavaScript. */
@JsExport
@JsName("ValueEvent")
public sealed class ValueEventJs<T> : FormManagerEventJs<T> {
    internal abstract val eventKt: ValueEvent<T>

    public open val value: T?
        get() = eventKt.value

    public open val oldValue: T?
        get() = eventKt.oldValue

    override val path: AbsolutePathJs
        get() = eventKt.path.cachedToJs()

    override val schema: SchemaJs<T>
        get() = eventKt.schema.cachedToJs()

    public override fun toString(): String = eventKt.toString()

    public class Init<T> internal constructor(override val eventKt: ValueEvent.Init<T>) :
        ValueEventJs<T>() {
        public override val oldValue: Nothing? = undefined
    }

    public class Change<T> internal constructor(override val eventKt: ValueEvent.Change<T>) :
        ValueEventJs<T>()

    public class Destroy<T> internal constructor(override val eventKt: ValueEvent.Destroy<T>) :
        ValueEventJs<T>() {
        public override val value: Nothing? = undefined
    }

    public class Add<T, TChildren>
    internal constructor(override val eventKt: ValueEvent.Add<T, TChildren>) : ValueEventJs<T>() {
        public override val oldValue: Nothing? = undefined

        public val addedValue: TChildren
            get() = eventKt.addedValue

        public val id: AbsolutePathFragmentJs.Id
            get() = eventKt.id.toJs() as AbsolutePathFragmentJs.Id
    }

    public class Remove<T, TChildren>
    internal constructor(override val eventKt: ValueEvent.Remove<T, TChildren>) :
        ValueEventJs<T>() {
        public override val oldValue: Nothing? = undefined

        public val removedValue: TChildren
            get() = eventKt.removedValue

        public val id: AbsolutePathFragmentJs.Id
            get() = eventKt.id.toJs() as AbsolutePathFragmentJs.Id
    }
}

/** [State event][StateEvent] wrapper for use from JavaScript. */
@JsExport
@JsName("StateEvent")
public sealed class StateEventJs<T> : FormManagerEventJs<T> {
    internal abstract val eventKt: StateEvent<T>

    override val path: AbsolutePathJs
        get() = eventKt.path.cachedToJs()

    override val schema: SchemaJs<T>
        get() = eventKt.schema.cachedToJs()

    public class ValidationChange<T>
    internal constructor(override val eventKt: StateEvent.ValidationChange<T>) : StateEventJs<T>() {
        public val status: ValidationStatusJs
            get() = eventKt.status.toJs()

        public val issues: Array<ValidationIssueJs>
            get() = eventKt.issues.cachedToJs { it.cachedToJs() }
    }

    public class DisplayChange<T>
    internal constructor(override val eventKt: StateEvent.DisplayChange<T>) : StateEventJs<T>() {
        public val status: DisplayStatusJs
            get() = eventKt.status.toJs()
    }

    public class DirtyChange<T>
    internal constructor(override val eventKt: StateEvent.DirtyChange<T>) : StateEventJs<T>() {
        public val status: Boolean
            get() = eventKt.status
    }

    public class TouchedChange<T>
    internal constructor(override val eventKt: StateEvent.TouchedChange<T>) : StateEventJs<T>() {
        public val status: Boolean
            get() = eventKt.status
    }

    public override fun toString(): String = eventKt.toString()
}

/**
 * Function which converts a [FormManagerEvent] into the JavaScript [FormManagerEventJs]
 * representation for use from JavaScript while caching the transformation.
 */
internal fun <T> FormManagerEvent<T>.cachedToJs(): FormManagerEventJs<T> =
    getOrSetFromCache(this) {
        when (this) {
            is ValueEvent.Init<T> -> ValueEventJs.Init(this)
            is ValueEvent.Change<T> -> ValueEventJs.Change(this)
            is ValueEvent.Destroy<T> -> ValueEventJs.Destroy(this)
            is ValueEvent.Add<T, *> -> ValueEventJs.Add(this)
            is ValueEvent.Remove<T, *> -> ValueEventJs.Remove(this)
            is StateEvent.ValidationChange -> StateEventJs.ValidationChange(this)
            is StateEvent.DisplayChange -> StateEventJs.DisplayChange(this)
            is StateEvent.DirtyChange -> StateEventJs.DirtyChange(this)
            is StateEvent.TouchedChange -> StateEventJs.TouchedChange(this)
        }
    }
