/*
 * Decompiled with CFR 0.152.
 */
package tech.orla;

import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import tech.orla.DockerProcess;
import tech.orla.TrivyProcess;
import tech.orla.api.GithubTrivyRelease;

@Mojo(name="trivy-scan")
public class TrivyScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(required=false)
    private String dockerFilePath;
    @Parameter(required=false, name="vulnType")
    private String vulnType;
    @Parameter(required=false)
    private String severity;
    @Parameter(required=false, defaultValue="false")
    private Boolean ignoreUnfixed;
    @Parameter(required=false, defaultValue="v0.49.1")
    private String trivyVersion;

    public void execute() throws MojoExecutionException {
        block4: {
            DockerProcess dockerProcess = new DockerProcess();
            if (dockerProcess.isDockerInstalled().booleanValue()) {
                String defLocationDockerFile = this.project.getBasedir().getAbsolutePath().concat("/Dockerfile");
                dockerProcess.buildDockerImage(this.dockerFilePath != null ? this.dockerFilePath : defLocationDockerFile, this.project.getArtifactId());
                TrivyProcess trivyProcess = new TrivyProcess(new GithubTrivyRelease());
                try {
                    String params = this.buildTrivyParams();
                    Integer exitCode = trivyProcess.scanImage("app/".concat(this.project.getArtifactId()), params, this.trivyVersion);
                    if (exitCode == 1) {
                        throw new MojoExecutionException("your app have some vulnerabilities");
                    }
                    break block4;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("error when execute trivy scan, error: ".concat(e.getMessage()));
                }
            }
            throw new MojoExecutionException("docker engine not found");
        }
    }

    public String buildTrivyParams() {
        ArrayList<String> params = new ArrayList<String>();
        if (this.vulnType != null && !this.vulnType.isEmpty()) {
            params.add("--vuln-type ".concat(this.vulnType));
        }
        if (this.severity != null && !this.severity.isEmpty()) {
            params.add("-s ".concat(this.severity));
        }
        if (this.ignoreUnfixed.booleanValue()) {
            params.add("--ignore-unfixed");
        }
        return String.join((CharSequence)" ", params);
    }
}

