/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.websocket.client;

import cn.hutool.core.util.StrUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.commons.base.msg.IMsg;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.config.BaseNettyClientConfig;
import tech.ordinaryroad.live.chat.client.servers.netty.handler.base.IBaseConnectionHandler;
import tech.ordinaryroad.live.chat.client.websocket.config.WebSocketLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.websocket.constant.WebSocketCmdEnum;
import tech.ordinaryroad.live.chat.client.websocket.listener.IWebSocketConnectionListener;
import tech.ordinaryroad.live.chat.client.websocket.listener.IWebSocketMsgListener;
import tech.ordinaryroad.live.chat.client.websocket.msg.base.IWebSocketMsg;
import tech.ordinaryroad.live.chat.client.websocket.netty.handler.WebSocketBinaryFrameHandler;
import tech.ordinaryroad.live.chat.client.websocket.netty.handler.WebSocketChannelInitializer;
import tech.ordinaryroad.live.chat.client.websocket.netty.handler.WebSocketConnectionHandler;

public class WebSocketLiveChatClient
extends BaseNettyClient<WebSocketLiveChatClientConfig, WebSocketCmdEnum, IWebSocketMsg, IWebSocketMsgListener, WebSocketConnectionHandler, WebSocketBinaryFrameHandler> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketLiveChatClient.class);
    private WebSocketLiveChatClient forwardClient;
    private final IBaseConnectionHandler connectionHandler;

    public WebSocketLiveChatClient(WebSocketLiveChatClientConfig config, IBaseConnectionHandler connectionHandler, IWebSocketMsgListener msgListener, IWebSocketConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListener(msgListener);
        this.connectionHandler = connectionHandler;
        this.init();
    }

    public WebSocketLiveChatClient(WebSocketLiveChatClientConfig config, IBaseConnectionHandler connectionHandler, IWebSocketMsgListener msgListener, IWebSocketConnectionListener connectionListener) {
        this(config, connectionHandler, msgListener, connectionListener, (EventLoopGroup)new NioEventLoopGroup());
    }

    public WebSocketLiveChatClient(WebSocketLiveChatClientConfig config, IBaseConnectionHandler connectionHandler, IWebSocketMsgListener msgListener) {
        this(config, connectionHandler, msgListener, null, (EventLoopGroup)new NioEventLoopGroup());
    }

    public WebSocketLiveChatClient(WebSocketLiveChatClientConfig config, IBaseConnectionHandler connectionHandler) {
        this(config, connectionHandler, null);
    }

    public WebSocketLiveChatClient(WebSocketLiveChatClientConfig config) {
        this(config, null, null);
    }

    public WebSocketConnectionHandler initConnectionHandler(IBaseConnectionListener<WebSocketConnectionHandler> clientConnectionListener) {
        return new WebSocketConnectionHandler(() -> new WebSocketClientProtocolHandler(WebSocketClientProtocolConfig.newBuilder().webSocketUri(this.getWebsocketUri()).version(WebSocketVersion.V13).subprotocol(null).allowExtensions(true).customHeaders((HttpHeaders)new DefaultHttpHeaders()).maxFramePayloadLength(((WebSocketLiveChatClientConfig)this.getConfig()).getMaxFramePayloadLength()).handshakeTimeoutMillis(((WebSocketLiveChatClientConfig)this.getConfig()).getHandshakeTimeoutMillis()).build()), this.connectionHandler, this, clientConnectionListener);
    }

    protected void initChannel(SocketChannel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new WebSocketChannelInitializer(this)});
    }

    public void init() {
        if (StrUtil.isNotBlank((CharSequence)((WebSocketLiveChatClientConfig)this.getConfig()).getForwardWebsocketUri())) {
            this.forwardClient = new WebSocketLiveChatClient((WebSocketLiveChatClientConfig)((WebSocketLiveChatClientConfig.WebSocketLiveChatClientConfigBuilder)WebSocketLiveChatClientConfig.builder().websocketUri(((WebSocketLiveChatClientConfig)this.getConfig()).getForwardWebsocketUri())).build());
            this.forwardClient.connect();
            this.addMsgListener(new IWebSocketMsgListener(){

                public void onMsg(IMsg msg) {
                    ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer();
                    buffer.writeCharSequence((CharSequence)msg.toString(), StandardCharsets.UTF_8);
                    WebSocketLiveChatClient.this.forwardClient.send(new BinaryWebSocketFrame(buffer));
                }
            });
        }
        super.init();
    }

    public void send(Object msg, Runnable success, Consumer<Throwable> failed) {
        if (!(msg instanceof BinaryWebSocketFrame)) {
            throw new BaseException("WebSocketLiveChatClient.send \u4ec5\u652f\u6301 BinaryWebSocketFrame\u7c7b\u578b\u7684\u6d88\u606f");
        }
        super.send(msg, success, failed);
    }

    public void destroy() {
        if (this.forwardClient != null) {
            this.forwardClient.destroy();
        }
        super.destroy();
    }
}

