/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.servers.netty.handler.base;

import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseMsgListener;
import tech.ordinaryroad.live.chat.client.commons.base.msg.BaseCmdMsg;
import tech.ordinaryroad.live.chat.client.commons.base.msg.BaseMsg;
import tech.ordinaryroad.live.chat.client.commons.base.msg.ICmdMsg;
import tech.ordinaryroad.live.chat.client.commons.base.msg.IMsg;

public abstract class BaseBinaryFrameHandler<T extends BaseBinaryFrameHandler<?, ?, ?, ?>, CmdEnum extends Enum<CmdEnum>, Msg extends IMsg, MsgListener extends IBaseMsgListener<T, CmdEnum>>
extends SimpleChannelInboundHandler<Msg>
implements IBaseMsgListener<T, CmdEnum> {
    private static final Logger log = LoggerFactory.getLogger(BaseBinaryFrameHandler.class);
    private final Object roomId;
    protected final List<MsgListener> msgListeners;

    public BaseBinaryFrameHandler(List<MsgListener> msgListeners, Object roomId) {
        this.msgListeners = msgListeners;
        this.roomId = roomId;
        if ((this.msgListeners == null || this.msgListeners.isEmpty()) && log.isDebugEnabled()) {
            log.debug("listener not set");
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Msg msg) {
        Enum cmdEnum;
        ICmdMsg cmdMsg;
        this.onMsg((T)((Object)this), (IMsg)msg);
        if (msg instanceof ICmdMsg) {
            cmdMsg = (ICmdMsg)msg;
            cmdEnum = cmdMsg.getCmdEnum();
            if (cmdEnum == null) {
                this.onUnknownCmd(this, cmdMsg.getCmd(), (IMsg)cmdMsg);
            } else {
                this.onCmdMsg(this, cmdEnum, cmdMsg);
            }
        }
        if (msg instanceof BaseCmdMsg) {
            cmdMsg = (BaseCmdMsg)msg;
            cmdEnum = cmdMsg.getCmdEnum();
            if (cmdEnum == null) {
                this.onUnknownCmd(this, cmdMsg.getCmd(), (BaseMsg)cmdMsg);
            } else {
                this.onCmdMsg((T)((Object)this), (CmdEnum)cmdEnum, (BaseCmdMsg<CmdEnum>)cmdMsg);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause.getCause() instanceof UnrecognizedPropertyException) {
            log.error("\u7f3a\u5c11\u5b57\u6bb5\uff1a{}", (Object)cause.getMessage());
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    public void onMsg(T t, IMsg msg) {
        super.onMsg(t, msg);
        this.iteratorMsgListeners(msgListener -> msgListener.onMsg((Object)t, msg));
    }

    public void onCmdMsg(T t, CmdEnum cmd, ICmdMsg<CmdEnum> cmdMsg) {
        super.onCmdMsg(t, cmd, cmdMsg);
        this.iteratorMsgListeners(msgListener -> msgListener.onCmdMsg((Object)t, cmd, cmdMsg));
    }

    public void onUnknownCmd(T t, String cmdString, IMsg msg) {
        super.onUnknownCmd(t, cmdString, msg);
        this.iteratorMsgListeners(msgListener -> msgListener.onUnknownCmd((Object)t, cmdString, msg));
    }

    public void iteratorMsgListeners(Consumer<MsgListener> consumer) {
        if (this.msgListeners.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.msgListeners.size(); ++i) {
            consumer.accept((IBaseMsgListener)this.msgListeners.get(i));
        }
    }

    public void onCmdMsg(T t, CmdEnum cmd, BaseCmdMsg<CmdEnum> cmdMsg) {
        super.onCmdMsg(t, cmd, cmdMsg);
        this.iteratorMsgListeners(msgListener -> msgListener.onCmdMsg((Object)t, cmd, cmdMsg));
    }

    public void onUnknownCmd(T t, String cmdString, BaseMsg msg) {
        super.onUnknownCmd(t, cmdString, msg);
        this.iteratorMsgListeners(msgListener -> msgListener.onUnknownCmd((Object)t, cmdString, msg));
    }

    public String getRoomIdAsString() {
        if (this.roomId == null) {
            return "";
        }
        return this.roomId.toString();
    }

    public long getRoomIdAsLong() {
        String roomIdAsString = this.getRoomIdAsString();
        if (roomIdAsString.trim().isEmpty()) {
            return 0L;
        }
        return Long.parseLong(roomIdAsString);
    }

    public Object getRoomId() {
        return this.roomId;
    }
}

