/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.servers.netty.handler.base;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;

public abstract class BaseConnectionHandler<ConnectionHandler extends BaseConnectionHandler<?>>
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(BaseConnectionHandler.class);
    private final WebSocketClientHandshaker handshaker;
    private ChannelPromise handshakeFuture;
    private final IBaseConnectionListener<ConnectionHandler> listener;
    private ScheduledFuture<?> scheduledFuture = null;

    public BaseConnectionHandler(WebSocketClientHandshaker handshaker, IBaseConnectionListener<ConnectionHandler> listener) {
        this.handshaker = handshaker;
        this.listener = listener;
    }

    public BaseConnectionHandler(WebSocketClientHandshaker handshaker) {
        this(handshaker, null);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        if (this.handshaker.isHandshakeComplete()) {
            this.handshakeSuccessfully(ctx, msg);
        } else {
            try {
                this.handshakeSuccessfully(ctx, msg);
            }
            catch (WebSocketHandshakeException e) {
                this.handshakeFailed(msg, e);
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("userEventTriggered {}", evt.getClass());
        }
        if (evt instanceof SslHandshakeCompletionEvent) {
            this.heartbeatCancel();
            this.heartbeatStart(ctx);
            if (this.listener != null) {
                this.listener.onConnected((Object)this);
            }
        } else if (evt instanceof SslCloseCompletionEvent) {
            this.heartbeatCancel();
            if (this.listener != null) {
                this.listener.onDisconnected((Object)this);
            }
        } else {
            log.error("\u5f85\u5904\u7406 {}", evt.getClass());
        }
        super.userEventTriggered(ctx, evt);
    }

    private void heartbeatStart(ChannelHandlerContext ctx) {
        this.scheduledFuture = ctx.executor().scheduleAtFixedRate(() -> this.sendHeartbeat(ctx), this.getHeartbeatInitialDelay(), this.getHeartbeatPeriod(), TimeUnit.SECONDS);
    }

    private void heartbeatCancel() {
        if (null != this.scheduledFuture && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    protected abstract void sendHeartbeat(ChannelHandlerContext var1);

    public abstract void sendAuthRequest(Channel var1);

    protected abstract long getHeartbeatPeriod();

    protected abstract long getHeartbeatInitialDelay();

    private void handshakeSuccessfully(ChannelHandlerContext ctx, FullHttpResponse msg) {
        if (log.isDebugEnabled()) {
            log.debug("\u63e1\u624b\u5b8c\u6210!");
        }
        this.handshaker.finishHandshake(ctx.channel(), msg);
        this.handshakeFuture.setSuccess();
    }

    private void handshakeFailed(FullHttpResponse msg, WebSocketHandshakeException e) {
        log.error("\u63e1\u624b\u5931\u8d25\uff01status:" + msg.status(), (Throwable)e);
        this.handshakeFuture.setFailure((Throwable)e);
        if (this.listener != null) {
            this.listener.onConnectFailed((Object)this);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("exceptionCaught", cause);
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }

    public ChannelPromise getHandshakeFuture() {
        return this.handshakeFuture;
    }
}

