/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.kuaishou.netty.handler;

import com.google.protobuf.ByteString;
import io.netty.channel.ChannelHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.api.KuaishouApis;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.msg.KuaishouCmdMsg;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.msg.KuaishouDanmuMsg;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.msg.KuaishouGiftMsg;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.msg.KuaishouLikeMsg;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.msg.KuaishouRoomStatsMsg;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.msg.base.IKuaishouMsg;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.protobuf.PayloadTypeOuterClass;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.protobuf.SCWebFeedPushOuterClass;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.protobuf.SocketMessageOuterClass;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.protobuf.WebCommentFeedOuterClass;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.protobuf.WebGiftFeedOuterClass;
import tech.ordinaryroad.live.chat.client.codec.kuaishou.protobuf.WebLikeFeedOuterClass;
import tech.ordinaryroad.live.chat.client.commons.base.msg.ICmdMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.client.KuaishouLiveChatClient;
import tech.ordinaryroad.live.chat.client.kuaishou.listener.IKuaishouMsgListener;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientBinaryFrameHandler;

@ChannelHandler.Sharable
public class KuaishouBinaryFrameHandler
extends BaseNettyClientBinaryFrameHandler<KuaishouLiveChatClient, KuaishouBinaryFrameHandler, PayloadTypeOuterClass.PayloadType, IKuaishouMsg, IKuaishouMsgListener> {
    private static final Logger log = LoggerFactory.getLogger(KuaishouBinaryFrameHandler.class);

    public KuaishouBinaryFrameHandler(List<IKuaishouMsgListener> iKuaishouMsgListeners, KuaishouLiveChatClient client) {
        super(iKuaishouMsgListeners, (BaseNettyClient)client);
    }

    public KuaishouBinaryFrameHandler(List<IKuaishouMsgListener> iKuaishouMsgListeners, long roomId) {
        super(iKuaishouMsgListeners, roomId);
    }

    public void onCmdMsg(PayloadTypeOuterClass.PayloadType cmd, ICmdMsg<PayloadTypeOuterClass.PayloadType> cmdMsg) {
        if (this.msgListeners.isEmpty()) {
            return;
        }
        KuaishouCmdMsg kuaishouCmdMsg = (KuaishouCmdMsg)cmdMsg;
        SocketMessageOuterClass.SocketMessage socketMessage = kuaishouCmdMsg.getMsg();
        ByteString payloadByteString = socketMessage.getPayload();
        switch (socketMessage.getPayloadType()) {
            case SC_FEED_PUSH: {
                KuaishouDanmuMsg msg;
                SCWebFeedPushOuterClass.SCWebFeedPush scWebFeedPush = SCWebFeedPushOuterClass.SCWebFeedPush.parseFrom((ByteString)payloadByteString);
                if (scWebFeedPush.getCommentFeedsCount() > 0) {
                    for (WebCommentFeedOuterClass.WebCommentFeed webCommentFeed : scWebFeedPush.getCommentFeedsList()) {
                        msg = new KuaishouDanmuMsg(webCommentFeed);
                        this.iteratorMsgListeners(msgListener -> msgListener.onDanmuMsg((Object)this, msg));
                    }
                }
                if (scWebFeedPush.getGiftFeedsCount() > 0) {
                    for (WebGiftFeedOuterClass.WebGiftFeed webGiftFeed : scWebFeedPush.getGiftFeedsList()) {
                        msg = new KuaishouGiftMsg(webGiftFeed);
                        KuaishouApis.calculateGiftCount((KuaishouGiftMsg)msg);
                        this.iteratorMsgListeners(arg_0 -> this.lambda$onCmdMsg$1((KuaishouGiftMsg)msg, arg_0));
                    }
                }
                if (scWebFeedPush.getLikeFeedsCount() > 0) {
                    for (WebLikeFeedOuterClass.WebLikeFeed webLikeFeed : scWebFeedPush.getLikeFeedsList()) {
                        msg = new KuaishouLikeMsg(webLikeFeed);
                        this.iteratorMsgListeners(arg_0 -> this.lambda$onCmdMsg$2((KuaishouLikeMsg)msg, arg_0));
                    }
                }
                String displayLikeCount = scWebFeedPush.getDisplayLikeCount();
                String displayWatchingCount = scWebFeedPush.getDisplayWatchingCount();
                KuaishouRoomStatsMsg kuaishouRoomStatsMsg = new KuaishouRoomStatsMsg();
                kuaishouRoomStatsMsg.setLikedCount(displayLikeCount);
                kuaishouRoomStatsMsg.setWatchingCount(displayWatchingCount);
                this.iteratorMsgListeners(msgListener -> msgListener.onRoomStatsMsg((Object)this, kuaishouRoomStatsMsg));
                break;
            }
            default: {
                this.iteratorMsgListeners(msgListener -> msgListener.onOtherCmdMsg((Object)this, (Enum)cmd, (ICmdMsg)kuaishouCmdMsg));
                break;
            }
        }
    }

    private /* synthetic */ void lambda$onCmdMsg$2(KuaishouLikeMsg msg, IKuaishouMsgListener msgListener) {
        msgListener.onLikeMsg((Object)this, msg);
    }

    private /* synthetic */ void lambda$onCmdMsg$1(KuaishouGiftMsg msg, IKuaishouMsgListener msgListener) {
        msgListener.onGiftMsg((Object)this, msg);
    }
}

