/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.kuaishou.netty.handler;

import cn.hutool.core.util.ZipUtil;
import com.google.protobuf.ByteString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.base.IKuaishouMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.SocketMessageOuterClass;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BinaryWebSocketFrameToMessageCodec;

public class KuaishouCodecHandler
extends BinaryWebSocketFrameToMessageCodec<IKuaishouMsg> {
    private static final Logger log = LoggerFactory.getLogger(KuaishouCodecHandler.class);

    protected void encode(ChannelHandlerContext ctx, IKuaishouMsg msg, List<Object> out) throws Exception {
        if (!(msg instanceof SocketMessageOuterClass.SocketMessage)) {
            throw new BaseException("\u6682\u4e0d\u652f\u6301" + msg.getClass());
        }
        out.add(new BinaryWebSocketFrame(ctx.alloc().buffer().writeBytes(((SocketMessageOuterClass.SocketMessage)msg).toByteArray())));
    }

    protected void decode(ChannelHandlerContext ctx, BinaryWebSocketFrame msg, List<Object> out) throws Exception {
        byte[] payload;
        ByteBuf content = msg.content();
        SocketMessageOuterClass.SocketMessage socketMessage = SocketMessageOuterClass.SocketMessage.parseFrom(content.nioBuffer());
        SocketMessageOuterClass.SocketMessage.CompressionType compressionType = socketMessage.getCompressionType();
        ByteString payloadByteString = socketMessage.getPayload();
        switch (compressionType) {
            case NONE: {
                payload = payloadByteString.toByteArray();
                break;
            }
            case GZIP: {
                payload = ZipUtil.unGzip((InputStream)payloadByteString.newInput());
                break;
            }
            default: {
                if (log.isWarnEnabled()) {
                    log.warn("\u6682\u4e0d\u652f\u6301\u7684\u538b\u7f29\u65b9\u5f0f " + (Object)((Object)compressionType));
                }
                return;
            }
        }
        out.add(socketMessage.toBuilder().setPayload(ByteString.copyFrom((byte[])payload)).build());
    }
}

