/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.kuaishou.client;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.commons.client.enums.ClientStatusEnums;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCollUtil;
import tech.ordinaryroad.live.chat.client.kuaishou.api.KuaishouApis;
import tech.ordinaryroad.live.chat.client.kuaishou.config.KuaishouLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.kuaishou.listener.IKuaishouConnectionListener;
import tech.ordinaryroad.live.chat.client.kuaishou.listener.IKuaishouMsgListener;
import tech.ordinaryroad.live.chat.client.kuaishou.listener.impl.KuaishouForwardMsgListener;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.base.IKuaishouMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.netty.handler.KuaishouBinaryFrameHandler;
import tech.ordinaryroad.live.chat.client.kuaishou.netty.handler.KuaishouConnectionHandler;
import tech.ordinaryroad.live.chat.client.kuaishou.netty.handler.KuaishouLiveChatClientChannelInitializer;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.PayloadTypeOuterClass;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.config.BaseNettyClientConfig;

public class KuaishouLiveChatClient
extends BaseNettyClient<KuaishouLiveChatClientConfig, PayloadTypeOuterClass.PayloadType, IKuaishouMsg, IKuaishouMsgListener, KuaishouConnectionHandler, KuaishouBinaryFrameHandler> {
    private static final Logger log = LoggerFactory.getLogger(KuaishouLiveChatClient.class);
    KuaishouApis.RoomInitResult roomInitResult = new KuaishouApis.RoomInitResult();

    public KuaishouLiveChatClient(KuaishouLiveChatClientConfig config, List<IKuaishouMsgListener> msgListeners, IKuaishouConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListeners(msgListeners);
        this.init();
    }

    public KuaishouLiveChatClient(KuaishouLiveChatClientConfig config, IKuaishouMsgListener msgListener, IKuaishouConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListener(msgListener);
        this.init();
    }

    public KuaishouLiveChatClient(KuaishouLiveChatClientConfig config, IKuaishouMsgListener msgListener, IKuaishouConnectionListener connectionListener) {
        this(config, msgListener, connectionListener, (EventLoopGroup)new NioEventLoopGroup());
    }

    public KuaishouLiveChatClient(KuaishouLiveChatClientConfig config, IKuaishouMsgListener msgListener) {
        this(config, msgListener, null, (EventLoopGroup)new NioEventLoopGroup());
    }

    public KuaishouLiveChatClient(KuaishouLiveChatClientConfig config) {
        this(config, null);
    }

    public void init() {
        this.roomInitResult = KuaishouApis.roomInit(((KuaishouLiveChatClientConfig)this.getConfig()).getRoomId(), ((KuaishouLiveChatClientConfig)this.getConfig()).getCookie());
        if (StrUtil.isNotBlank((CharSequence)((KuaishouLiveChatClientConfig)this.getConfig()).getForwardWebsocketUri())) {
            KuaishouForwardMsgListener forwardMsgListener = new KuaishouForwardMsgListener(((KuaishouLiveChatClientConfig)this.getConfig()).getForwardWebsocketUri());
            this.addMsgListener(forwardMsgListener);
            this.addStatusChangeListener((evt, oldStatus, newStatus) -> {
                if (newStatus == ClientStatusEnums.DESTROYED) {
                    forwardMsgListener.destroyForwardClient();
                }
            });
        }
        super.init();
    }

    protected String getWebSocketUriString() {
        String webSocketUriString = super.getWebSocketUriString();
        if (StrUtil.isNotBlank((CharSequence)webSocketUriString)) {
            return webSocketUriString;
        }
        return (String)OrLiveChatCollUtil.getRandom(this.roomInitResult.getWebsocketUrls());
    }

    public KuaishouConnectionHandler initConnectionHandler(IBaseConnectionListener<KuaishouConnectionHandler> clientConnectionListener) {
        return new KuaishouConnectionHandler(() -> new WebSocketClientProtocolHandler(WebSocketClientProtocolConfig.newBuilder().webSocketUri(this.getWebsocketUri()).version(WebSocketVersion.V13).subprotocol(null).allowExtensions(true).customHeaders((HttpHeaders)new DefaultHttpHeaders()).maxFramePayloadLength(((KuaishouLiveChatClientConfig)this.getConfig()).getMaxFramePayloadLength()).handshakeTimeoutMillis(((KuaishouLiveChatClientConfig)this.getConfig()).getHandshakeTimeoutMillis()).build()), this, clientConnectionListener);
    }

    protected void initChannel(SocketChannel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new KuaishouLiveChatClientChannelInitializer(this)});
    }

    public void sendDanmu(Object danmu, Runnable success, Consumer<Throwable> failed) {
        block12: {
            if (!this.checkCanSendDanmu()) {
                return;
            }
            if (danmu instanceof String) {
                String msg = (String)danmu;
                try {
                    boolean sendSuccess;
                    block11: {
                        if (log.isDebugEnabled()) {
                            log.debug("{} kuaishou\u53d1\u9001\u5f39\u5e55 {}", ((KuaishouLiveChatClientConfig)this.getConfig()).getRoomId(), danmu);
                        }
                        sendSuccess = false;
                        try {
                            KuaishouApis.sendComment(((KuaishouLiveChatClientConfig)this.getConfig()).getCookie(), ((KuaishouLiveChatClientConfig)this.getConfig()).getRoomId(), KuaishouApis.SendCommentRequest.builder().liveStreamId(this.roomInitResult.getLiveStreamId()).content(msg).build());
                            sendSuccess = true;
                        }
                        catch (Exception e) {
                            log.error("kuaishou\u5f39\u5e55\u53d1\u9001\u5931\u8d25", (Throwable)e);
                            if (failed == null) break block11;
                            failed.accept(e);
                        }
                    }
                    if (!sendSuccess) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("kuaishou\u5f39\u5e55\u53d1\u9001\u6210\u529f {}", danmu);
                    }
                    if (success != null) {
                        success.run();
                    }
                    this.finishSendDanmu();
                }
                catch (Exception e) {
                    log.error("kuaishou\u5f39\u5e55\u53d1\u9001\u5931\u8d25", (Throwable)e);
                    if (failed != null) {
                        failed.accept(e);
                    }
                    break block12;
                }
            }
            super.sendDanmu(danmu, success, failed);
        }
    }

    public void clickLike(int count, Runnable success, Consumer<Throwable> failed) {
        boolean successfullyClicked;
        block7: {
            if (count <= 0) {
                throw new BaseException("\u70b9\u8d5e\u6b21\u6570\u5fc5\u987b\u5927\u4e8e0");
            }
            successfullyClicked = false;
            try {
                JsonNode jsonNode = KuaishouApis.clickLike(((KuaishouLiveChatClientConfig)this.getConfig()).getCookie(), ((KuaishouLiveChatClientConfig)this.getConfig()).getRoomId(), this.roomInitResult.getLiveStreamId(), count);
                if (jsonNode.asBoolean()) {
                    successfullyClicked = true;
                }
            }
            catch (Exception e) {
                log.error("kuaishou\u4e3a\u76f4\u64ad\u95f4\u70b9\u8d5e\u5931\u8d25", (Throwable)e);
                if (failed == null) break block7;
                failed.accept(e);
            }
        }
        if (!successfullyClicked) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("kuaishou\u4e3a\u76f4\u64ad\u95f4\u70b9\u8d5e\u6210\u529f");
        }
        if (success != null) {
            success.run();
        }
    }

    public KuaishouApis.RoomInitResult getRoomInitResult() {
        return this.roomInitResult;
    }
}

