/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.kuaishou.api;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.GlobalHeaders;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.msg.BaseMsg;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.KuaishouGiftMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.WebGiftFeedOuterClass;

public class KuaishouApis {
    public static final TimedCache<String, Map<String, GiftInfo>> RESULT_CACHE = new TimedCache(TimeUnit.DAYS.toMillis(1L));
    public static final String KEY_RESULT_CACHE_GIFT_ITEMS = "GIFT_ITEMS";
    public static final String PATTERN_LIVE_STREAM_ID = "\"liveStream\":\\{\"id\":\"([\\w\\d-_]+)\"";
    public static final String USER_AGENT = GlobalHeaders.INSTANCE.header(Header.USER_AGENT).replace("Hutool", "");
    private static final TimedCache<String, WebGiftFeedOuterClass.WebGiftFeed> WEB_GIFT_FEED_CACHE = new TimedCache(300000L, new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomInitResult roomInit(Object roomId, String cookie) {
        HttpResponse response = KuaishouApis.createGetRequest("https://live.kuaishou.com/u/" + roomId, cookie).execute();
        try {
            String body;
            String liveStreamId;
            JsonNode websocketinfo;
            if (StrUtil.isBlank((CharSequence)cookie)) {
                cookie = OrLiveChatCookieUtil.toString((List)response.getCookies());
            }
            if (!(websocketinfo = KuaishouApis.websocketinfo(roomId, liveStreamId = ReUtil.getGroup1((String)PATTERN_LIVE_STREAM_ID, (CharSequence)(body = response.body())), cookie)).has("token")) {
                KuaishouApis.throwExceptionWithTip("\u4e3b\u64ad\u672a\u5f00\u64ad\uff0ctoken\u83b7\u53d6\u5931\u8d25 " + websocketinfo);
            }
            ArrayNode websocketUrls = (ArrayNode)websocketinfo.withArray("websocketUrls");
            ArrayList websocketUrlList = CollUtil.newArrayList((Object[])new String[0]);
            for (JsonNode websocketUrl : websocketUrls) {
                websocketUrlList.add(websocketUrl.asText());
            }
            RoomInitResult roomInitResult = RoomInitResult.builder().token(websocketinfo.required("token").asText()).websocketUrls(websocketUrlList).liveStreamId(liveStreamId).build();
            return roomInitResult;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    public static RoomInitResult roomInit(Object roomId) {
        return KuaishouApis.roomInit(roomId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode websocketinfo(Object roomId, String liveStreamId, String cookie) {
        if (StrUtil.isBlank((CharSequence)liveStreamId)) {
            KuaishouApis.throwExceptionWithTip("\u4e3b\u64ad\u672a\u5f00\u64ad\uff0cliveStreamId\u4e3a\u7a7a");
        }
        HttpResponse response = ((HttpRequest)KuaishouApis.createGetRequest("https://live.kuaishou.com/live_api/liveroom/websocketinfo?liveStreamId=" + liveStreamId, cookie).header(Header.REFERER, "https://live.kuaishou.com/u/" + roomId)).execute();
        try {
            JsonNode jsonNode = KuaishouApis.responseInterceptor(response.body());
            return jsonNode;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, GiftInfo> allgifts() {
        final HashMap<String, GiftInfo> map = new HashMap<String, GiftInfo>();
        HttpResponse response = KuaishouApis.createGetRequest("https://live.kuaishou.com/live_api/emoji/allgifts", null).execute();
        try {
            JsonNode jsonNode = KuaishouApis.responseInterceptor(response.body());
            jsonNode.fields().forEachRemaining(new Consumer<Map.Entry<String, JsonNode>>(){

                @Override
                public void accept(Map.Entry<String, JsonNode> stringJsonNodeEntry) {
                    map.put(stringJsonNodeEntry.getKey(), (GiftInfo)BaseMsg.OBJECT_MAPPER.convertValue((Object)stringJsonNodeEntry.getValue(), GiftInfo.class));
                }
            });
            HashMap<String, GiftInfo> hashMap = map;
            return hashMap;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    public static GiftInfo getGiftInfoById(String id) {
        if (!RESULT_CACHE.containsKey((Object)KEY_RESULT_CACHE_GIFT_ITEMS)) {
            RESULT_CACHE.put((Object)KEY_RESULT_CACHE_GIFT_ITEMS, KuaishouApis.allgifts());
        }
        return (GiftInfo)((Map)RESULT_CACHE.get((Object)KEY_RESULT_CACHE_GIFT_ITEMS)).get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode sendComment(String cookie, Object roomId, SendCommentRequest request) {
        JsonNode jsonNode;
        block6: {
            HttpResponse response = ((HttpRequest)KuaishouApis.createPostRequest("https://live.kuaishou.com/live_api/liveroom/sendComment", cookie).body(BaseMsg.OBJECT_MAPPER.writeValueAsString((Object)request), ContentType.JSON.getValue()).header(Header.REFERER, "https://live.kuaishou.com/u/" + roomId)).execute();
            try {
                jsonNode = KuaishouApis.responseInterceptor(response.body());
                if (Collections.singletonList(response).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(response).get(0) != null) {
                    response.close();
                }
                throw throwable;
            }
            response.close();
        }
        return jsonNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode clickLike(String cookie, Object roomId, String liveStreamId, int count) {
        JsonNode jsonNode;
        block6: {
            HttpResponse response = ((HttpRequest)((HttpRequest)KuaishouApis.createPostRequest("https://live.kuaishou.com/live_api/liveroom/like", cookie).body(BaseMsg.OBJECT_MAPPER.createObjectNode().put("liveStreamId", liveStreamId).put("count", count).toString(), ContentType.JSON.getValue()).header(Header.ORIGIN, "https://live.kuaishou.com")).header(Header.REFERER, "https://live.kuaishou.com/u/" + roomId)).execute();
            try {
                jsonNode = KuaishouApis.responseInterceptor(response.body());
                if (Collections.singletonList(response).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(response).get(0) != null) {
                    response.close();
                }
                throw throwable;
            }
            response.close();
        }
        return jsonNode;
    }

    public static HttpRequest createRequest(Method method, String url, String cookie) {
        return (HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)method, (String)url).cookie(cookie).header(Header.HOST, URLUtil.url((String)url).getHost())).header(Header.USER_AGENT, USER_AGENT);
    }

    public static HttpRequest createGetRequest(String url, String cookie) {
        return KuaishouApis.createRequest(Method.GET, url, cookie);
    }

    public static HttpRequest createPostRequest(String url, String cookie) {
        return KuaishouApis.createRequest(Method.POST, url, cookie);
    }

    private static JsonNode responseInterceptor(String responseString) {
        try {
            int result;
            JsonNode jsonNode = BaseMsg.OBJECT_MAPPER.readTree(responseString);
            JsonNode data = jsonNode.required("data");
            if (data.has("result") && (result = data.get("result").asInt()) != 1) {
                String message = "";
                switch (result) {
                    case 2: {
                        message = "\u8bf7\u6c42\u8fc7\u5feb\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
                        break;
                    }
                    case 400002: {
                        message = "\u9700\u8981\u8fdb\u884c\u9a8c\u8bc1";
                        break;
                    }
                    default: {
                        message = "";
                    }
                }
                KuaishouApis.throwExceptionWithTip("\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25\uff1a" + message + "\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a" + jsonNode);
            }
            return data;
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
    }

    private static void throwExceptionWithTip(String message) {
        throw new BaseException("\u300e\u53ef\u80fd\u5df2\u89e6\u53d1\u6ed1\u5757\u9a8c\u8bc1\uff0c\u5efa\u8bae\u914d\u7f6eCookie\u6216\u6253\u5f00\u6d4f\u89c8\u5668\u8fdb\u884c\u6ed1\u5757\u9a8c\u8bc1\u540e\u91cd\u8bd5\u300f" + message);
    }

    public static int calculateGiftCount(KuaishouGiftMsg msg) {
        int giftCount;
        if (msg == null || msg.getMsg() == null) {
            return 0;
        }
        WebGiftFeedOuterClass.WebGiftFeed webGiftFeed = msg.getMsg();
        String mergeKey = webGiftFeed.getMergeKey();
        if (WEB_GIFT_FEED_CACHE.containsKey((Object)mergeKey)) {
            WebGiftFeedOuterClass.WebGiftFeed webGiftFeedByMergeKey = (WebGiftFeedOuterClass.WebGiftFeed)WEB_GIFT_FEED_CACHE.get((Object)mergeKey);
            int comboCountByMergeKey = webGiftFeedByMergeKey.getComboCount();
            giftCount = webGiftFeed.getComboCount() - comboCountByMergeKey;
        } else {
            int batchSize = webGiftFeed.getBatchSize();
            int comboCount = webGiftFeed.getComboCount();
            giftCount = comboCount == 1 ? batchSize : comboCount;
        }
        WEB_GIFT_FEED_CACHE.put((Object)mergeKey, (Object)webGiftFeed);
        msg.setCalculatedGiftCount(giftCount);
        return giftCount;
    }

    public static class RoomInitResult {
        private String token;
        private String liveStreamId;
        private List<String> websocketUrls;

        public static RoomInitResultBuilder builder() {
            return new RoomInitResultBuilder();
        }

        public String getToken() {
            return this.token;
        }

        public String getLiveStreamId() {
            return this.liveStreamId;
        }

        public List<String> getWebsocketUrls() {
            return this.websocketUrls;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setLiveStreamId(String liveStreamId) {
            this.liveStreamId = liveStreamId;
        }

        public void setWebsocketUrls(List<String> websocketUrls) {
            this.websocketUrls = websocketUrls;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoomInitResult)) {
                return false;
            }
            RoomInitResult other = (RoomInitResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$liveStreamId = this.getLiveStreamId();
            String other$liveStreamId = other.getLiveStreamId();
            if (this$liveStreamId == null ? other$liveStreamId != null : !this$liveStreamId.equals(other$liveStreamId)) {
                return false;
            }
            List<String> this$websocketUrls = this.getWebsocketUrls();
            List<String> other$websocketUrls = other.getWebsocketUrls();
            return !(this$websocketUrls == null ? other$websocketUrls != null : !((Object)this$websocketUrls).equals(other$websocketUrls));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoomInitResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $liveStreamId = this.getLiveStreamId();
            result = result * 59 + ($liveStreamId == null ? 43 : $liveStreamId.hashCode());
            List<String> $websocketUrls = this.getWebsocketUrls();
            result = result * 59 + ($websocketUrls == null ? 43 : ((Object)$websocketUrls).hashCode());
            return result;
        }

        public String toString() {
            return "KuaishouApis.RoomInitResult(token=" + this.getToken() + ", liveStreamId=" + this.getLiveStreamId() + ", websocketUrls=" + this.getWebsocketUrls() + ")";
        }

        public RoomInitResult(String token, String liveStreamId, List<String> websocketUrls) {
            this.token = token;
            this.liveStreamId = liveStreamId;
            this.websocketUrls = websocketUrls;
        }

        public RoomInitResult() {
        }

        public static class RoomInitResultBuilder {
            private String token;
            private String liveStreamId;
            private List<String> websocketUrls;

            RoomInitResultBuilder() {
            }

            public RoomInitResultBuilder token(String token) {
                this.token = token;
                return this;
            }

            public RoomInitResultBuilder liveStreamId(String liveStreamId) {
                this.liveStreamId = liveStreamId;
                return this;
            }

            public RoomInitResultBuilder websocketUrls(List<String> websocketUrls) {
                this.websocketUrls = websocketUrls;
                return this;
            }

            public RoomInitResult build() {
                return new RoomInitResult(this.token, this.liveStreamId, this.websocketUrls);
            }

            public String toString() {
                return "KuaishouApis.RoomInitResult.RoomInitResultBuilder(token=" + this.token + ", liveStreamId=" + this.liveStreamId + ", websocketUrls=" + this.websocketUrls + ")";
            }
        }
    }

    public static class GiftInfo {
        private String giftName;
        private String giftUrl;

        public String getGiftName() {
            return this.giftName;
        }

        public String getGiftUrl() {
            return this.giftUrl;
        }

        public void setGiftName(String giftName) {
            this.giftName = giftName;
        }

        public void setGiftUrl(String giftUrl) {
            this.giftUrl = giftUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GiftInfo)) {
                return false;
            }
            GiftInfo other = (GiftInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$giftName = this.getGiftName();
            String other$giftName = other.getGiftName();
            if (this$giftName == null ? other$giftName != null : !this$giftName.equals(other$giftName)) {
                return false;
            }
            String this$giftUrl = this.getGiftUrl();
            String other$giftUrl = other.getGiftUrl();
            return !(this$giftUrl == null ? other$giftUrl != null : !this$giftUrl.equals(other$giftUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GiftInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $giftName = this.getGiftName();
            result = result * 59 + ($giftName == null ? 43 : $giftName.hashCode());
            String $giftUrl = this.getGiftUrl();
            result = result * 59 + ($giftUrl == null ? 43 : $giftUrl.hashCode());
            return result;
        }

        public String toString() {
            return "KuaishouApis.GiftInfo(giftName=" + this.getGiftName() + ", giftUrl=" + this.getGiftUrl() + ")";
        }

        public GiftInfo(String giftName, String giftUrl) {
            this.giftName = giftName;
            this.giftUrl = giftUrl;
        }

        public GiftInfo() {
        }
    }

    public static class SendCommentRequest {
        private String liveStreamId;
        private String content;
        private String color;

        public static SendCommentRequestBuilder builder() {
            return new SendCommentRequestBuilder();
        }

        public String getLiveStreamId() {
            return this.liveStreamId;
        }

        public String getContent() {
            return this.content;
        }

        public String getColor() {
            return this.color;
        }

        public void setLiveStreamId(String liveStreamId) {
            this.liveStreamId = liveStreamId;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendCommentRequest)) {
                return false;
            }
            SendCommentRequest other = (SendCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$liveStreamId = this.getLiveStreamId();
            String other$liveStreamId = other.getLiveStreamId();
            if (this$liveStreamId == null ? other$liveStreamId != null : !this$liveStreamId.equals(other$liveStreamId)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            return !(this$color == null ? other$color != null : !this$color.equals(other$color));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $liveStreamId = this.getLiveStreamId();
            result = result * 59 + ($liveStreamId == null ? 43 : $liveStreamId.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            return result;
        }

        public String toString() {
            return "KuaishouApis.SendCommentRequest(liveStreamId=" + this.getLiveStreamId() + ", content=" + this.getContent() + ", color=" + this.getColor() + ")";
        }

        public SendCommentRequest(String liveStreamId, String content, String color) {
            this.liveStreamId = liveStreamId;
            this.content = content;
            this.color = color;
        }

        public SendCommentRequest() {
        }

        public static class SendCommentRequestBuilder {
            private String liveStreamId;
            private String content;
            private String color;

            SendCommentRequestBuilder() {
            }

            public SendCommentRequestBuilder liveStreamId(String liveStreamId) {
                this.liveStreamId = liveStreamId;
                return this;
            }

            public SendCommentRequestBuilder content(String content) {
                this.content = content;
                return this;
            }

            public SendCommentRequestBuilder color(String color) {
                this.color = color;
                return this;
            }

            public SendCommentRequest build() {
                return new SendCommentRequest(this.liveStreamId, this.content, this.color);
            }

            public String toString() {
                return "KuaishouApis.SendCommentRequest.SendCommentRequestBuilder(liveStreamId=" + this.liveStreamId + ", content=" + this.content + ", color=" + this.color + ")";
            }
        }
    }
}

