/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.kuaishou.listener.impl;

import cn.hutool.core.util.StrUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.nio.charset.StandardCharsets;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.msg.IMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.listener.IKuaishouMsgListener;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.KuaishouDanmuMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.KuaishouGiftMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.KuaishouLikeMsg;
import tech.ordinaryroad.live.chat.client.websocket.client.WebSocketLiveChatClient;
import tech.ordinaryroad.live.chat.client.websocket.config.WebSocketLiveChatClientConfig;

public class KuaishouForwardMsgListener
implements IKuaishouMsgListener {
    private final WebSocketLiveChatClient webSocketLiveChatClient;

    public KuaishouForwardMsgListener(String webSocketUri) {
        if (StrUtil.isBlank((CharSequence)webSocketUri)) {
            throw new BaseException("\u8f6c\u53d1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.webSocketLiveChatClient = new WebSocketLiveChatClient(((WebSocketLiveChatClientConfig.WebSocketLiveChatClientConfigBuilder)WebSocketLiveChatClientConfig.builder().websocketUri(webSocketUri)).build());
        this.webSocketLiveChatClient.connect();
    }

    public void onDanmuMsg(KuaishouDanmuMsg msg) {
        this.forward(msg);
    }

    public void onGiftMsg(KuaishouGiftMsg msg) {
        this.forward(msg);
    }

    public void onLikeMsg(KuaishouLikeMsg msg) {
        this.forward(msg);
    }

    private void forward(IMsg msg) {
        if (this.webSocketLiveChatClient == null) {
            return;
        }
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
        byteBuf.writeCharSequence((CharSequence)msg.toString(), StandardCharsets.UTF_8);
        this.webSocketLiveChatClient.send((Object)new BinaryWebSocketFrame(byteBuf));
    }

    public void destroyForwardClient() {
        this.webSocketLiveChatClient.destroy();
    }
}

