/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.kuaishou.netty.handler;

import cn.hutool.core.util.ZipUtil;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.msg.ICmdMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.api.KuaishouApis;
import tech.ordinaryroad.live.chat.client.kuaishou.client.KuaishouLiveChatClient;
import tech.ordinaryroad.live.chat.client.kuaishou.listener.IKuaishouMsgListener;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.KuaishouDanmuMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.KuaishouGiftMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.KuaishouLikeMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.msg.base.IKuaishouMsg;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.PayloadTypeOuterClass;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.SCWebFeedPushOuterClass;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.SocketMessageOuterClass;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.WebCommentFeedOuterClass;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.WebGiftFeedOuterClass;
import tech.ordinaryroad.live.chat.client.kuaishou.protobuf.WebLikeFeedOuterClass;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientBinaryFrameHandler;

@ChannelHandler.Sharable
public class KuaishouBinaryFrameHandler
extends BaseNettyClientBinaryFrameHandler<KuaishouLiveChatClient, KuaishouBinaryFrameHandler, PayloadTypeOuterClass.PayloadType, IKuaishouMsg, IKuaishouMsgListener> {
    private static final Logger log = LoggerFactory.getLogger(KuaishouBinaryFrameHandler.class);

    public KuaishouBinaryFrameHandler(List<IKuaishouMsgListener> iKuaishouMsgListeners, KuaishouLiveChatClient client) {
        super(iKuaishouMsgListeners, (BaseNettyClient)client);
    }

    public KuaishouBinaryFrameHandler(List<IKuaishouMsgListener> iKuaishouMsgListeners, long roomId) {
        super(iKuaishouMsgListeners, roomId);
    }

    public void onCmdMsg(PayloadTypeOuterClass.PayloadType cmd, ICmdMsg<PayloadTypeOuterClass.PayloadType> cmdMsg) {
        if (this.msgListeners.isEmpty()) {
            return;
        }
        SocketMessageOuterClass.SocketMessage socketMessage = (SocketMessageOuterClass.SocketMessage)cmdMsg;
        ByteString payloadByteString = socketMessage.getPayload();
        switch (socketMessage.getPayloadType()) {
            case SC_FEED_PUSH: {
                SCWebFeedPushOuterClass.SCWebFeedPush scWebFeedPush = SCWebFeedPushOuterClass.SCWebFeedPush.parseFrom(payloadByteString);
                if (scWebFeedPush.getCommentFeedsCount() > 0) {
                    for (WebCommentFeedOuterClass.WebCommentFeed webCommentFeed : scWebFeedPush.getCommentFeedsList()) {
                        this.iteratorMsgListeners(msgListener -> msgListener.onDanmuMsg((Object)this, new KuaishouDanmuMsg(webCommentFeed)));
                    }
                }
                if (scWebFeedPush.getGiftFeedsCount() > 0) {
                    for (WebGiftFeedOuterClass.WebGiftFeed webGiftFeed : scWebFeedPush.getGiftFeedsList()) {
                        this.iteratorMsgListeners(msgListener -> {
                            KuaishouGiftMsg msg = new KuaishouGiftMsg(webGiftFeed);
                            KuaishouApis.calculateGiftCount(msg);
                            msgListener.onGiftMsg((Object)this, msg);
                        });
                    }
                }
                if (scWebFeedPush.getLikeFeedsCount() > 0) {
                    for (WebLikeFeedOuterClass.WebLikeFeed webLikeFeed : scWebFeedPush.getLikeFeedsList()) {
                        this.iteratorMsgListeners(msgListener -> msgListener.onLikeMsg((Object)this, new KuaishouLikeMsg(webLikeFeed)));
                    }
                }
                break;
            }
            default: {
                this.iteratorMsgListeners(msgListener -> msgListener.onOtherCmdMsg((Object)this, cmd, socketMessage));
            }
        }
    }

    protected List<IKuaishouMsg> decode(ByteBuf byteBuf) {
        try {
            byte[] payload;
            SocketMessageOuterClass.SocketMessage socketMessage = SocketMessageOuterClass.SocketMessage.parseFrom(byteBuf.nioBuffer());
            SocketMessageOuterClass.SocketMessage.CompressionType compressionType = socketMessage.getCompressionType();
            ByteString payloadByteString = socketMessage.getPayload();
            switch (compressionType) {
                case NONE: {
                    payload = payloadByteString.toByteArray();
                    break;
                }
                case GZIP: {
                    payload = ZipUtil.unGzip((InputStream)payloadByteString.newInput());
                    break;
                }
                default: {
                    if (log.isWarnEnabled()) {
                        log.warn("\u6682\u4e0d\u652f\u6301\u7684\u538b\u7f29\u65b9\u5f0f " + (Object)((Object)compressionType));
                    }
                    return Collections.emptyList();
                }
            }
            return Collections.singletonList(socketMessage.toBuilder().setPayload(ByteString.copyFrom((byte[])payload)).build());
        }
        catch (InvalidProtocolBufferException e) {
            throw new BaseException((Throwable)e);
        }
    }
}

