/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.huya.client;

import cn.hutool.core.util.StrUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.huya.api.HuyaApis;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaCmdEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WebSocketCommand;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.base.IHuyaMsg;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.factory.HuyaMsgFactory;
import tech.ordinaryroad.live.chat.client.codec.huya.room.HuyaRoomInitResult;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.commons.client.enums.ClientStatusEnums;
import tech.ordinaryroad.live.chat.client.huya.config.HuyaLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.huya.listener.IHuyaConnectionListener;
import tech.ordinaryroad.live.chat.client.huya.listener.IHuyaMsgListener;
import tech.ordinaryroad.live.chat.client.huya.listener.impl.HuyaForwardMsgListener;
import tech.ordinaryroad.live.chat.client.huya.netty.handler.HuyaBinaryFrameHandler;
import tech.ordinaryroad.live.chat.client.huya.netty.handler.HuyaConnectionHandler;
import tech.ordinaryroad.live.chat.client.huya.netty.handler.HuyaLiveChatClientChannelInitializer;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.config.BaseNettyClientConfig;

public class HuyaLiveChatClient
extends BaseNettyClient<HuyaLiveChatClientConfig, HuyaRoomInitResult, HuyaCmdEnum, IHuyaMsg, IHuyaMsgListener, HuyaConnectionHandler, HuyaBinaryFrameHandler> {
    private static final Logger log = LoggerFactory.getLogger(HuyaLiveChatClient.class);

    public HuyaLiveChatClient(HuyaLiveChatClientConfig config, List<IHuyaMsgListener> msgListeners, IHuyaConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListeners(msgListeners);
        this.init();
    }

    public HuyaLiveChatClient(HuyaLiveChatClientConfig config, IHuyaMsgListener msgListener, IHuyaConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListener(msgListener);
        this.init();
    }

    public HuyaLiveChatClient(HuyaLiveChatClientConfig config, IHuyaMsgListener msgListener, IHuyaConnectionListener connectionListener) {
        this(config, msgListener, connectionListener, (EventLoopGroup)new NioEventLoopGroup());
    }

    public HuyaLiveChatClient(HuyaLiveChatClientConfig config, IHuyaMsgListener msgListener) {
        this(config, msgListener, null, (EventLoopGroup)new NioEventLoopGroup());
    }

    public HuyaLiveChatClient(HuyaLiveChatClientConfig config) {
        this(config, null);
    }

    public void init() {
        if (StrUtil.isNotBlank((CharSequence)((HuyaLiveChatClientConfig)this.getConfig()).getForwardWebsocketUri())) {
            HuyaForwardMsgListener forwardMsgListener = new HuyaForwardMsgListener(((HuyaLiveChatClientConfig)this.getConfig()).getForwardWebsocketUri());
            this.addMsgListener(forwardMsgListener);
            this.addStatusChangeListener((evt, oldStatus, newStatus) -> {
                if (newStatus == ClientStatusEnums.DESTROYED) {
                    forwardMsgListener.destroyForwardClient();
                }
            });
        }
        super.init();
    }

    public HuyaRoomInitResult initRoom() {
        return HuyaApis.roomInit((Object)((HuyaLiveChatClientConfig)this.getConfig()).getRoomId(), (String)((HuyaLiveChatClientConfig)this.getConfig()).getCookie(), (HuyaRoomInitResult)((HuyaRoomInitResult)this.roomInitResult));
    }

    public HuyaConnectionHandler initConnectionHandler(IBaseConnectionListener<HuyaConnectionHandler> clientConnectionListener) {
        return new HuyaConnectionHandler(() -> new WebSocketClientProtocolHandler(WebSocketClientProtocolConfig.newBuilder().webSocketUri(this.getWebsocketUri()).version(WebSocketVersion.V13).subprotocol(null).allowExtensions(true).customHeaders((HttpHeaders)new DefaultHttpHeaders()).maxFramePayloadLength(((HuyaLiveChatClientConfig)this.getConfig()).getMaxFramePayloadLength()).handshakeTimeoutMillis(((HuyaLiveChatClientConfig)this.getConfig()).getHandshakeTimeoutMillis()).build()), this, clientConnectionListener);
    }

    protected void initChannel(SocketChannel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new HuyaLiveChatClientChannelInitializer(this)});
    }

    public void sendDanmu(Object danmu, Runnable success, Consumer<Throwable> failed) {
        if (!this.checkCanSendDanmu()) {
            return;
        }
        if (danmu instanceof String) {
            WebSocketCommand webSocketCommand;
            block7: {
                String msg = (String)danmu;
                if (log.isDebugEnabled()) {
                    log.debug("{} huya\u53d1\u9001\u5f39\u5e55 {}", ((HuyaLiveChatClientConfig)this.getConfig()).getRoomId(), danmu);
                }
                webSocketCommand = null;
                try {
                    webSocketCommand = HuyaMsgFactory.getInstance((Object)((HuyaLiveChatClientConfig)this.getConfig()).getRoomId()).createSendMessageReq((HuyaRoomInitResult)this.roomInitResult, msg, ((HuyaLiveChatClientConfig)this.getConfig()).getVer(), ((HuyaLiveChatClientConfig)this.getConfig()).getCookie());
                }
                catch (Exception e) {
                    log.error("huya\u5f39\u5e55\u5305\u521b\u5efa\u5931\u8d25", (Throwable)e);
                    if (failed == null) break block7;
                    failed.accept(e);
                }
            }
            if (webSocketCommand == null) {
                return;
            }
            this.send(webSocketCommand, () -> {
                if (log.isDebugEnabled()) {
                    log.debug("huya\u5f39\u5e55\u53d1\u9001\u6210\u529f {}", danmu);
                }
                if (success != null) {
                    success.run();
                }
                this.finishSendDanmu();
            }, throwable -> {
                log.error("huya\u5f39\u5e55\u53d1\u9001\u5931\u8d25", throwable);
                if (failed != null) {
                    failed.accept((Throwable)throwable);
                }
            });
        } else {
            super.sendDanmu(danmu);
        }
    }
}

