/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.huya.netty.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.factory.HuyaMsgFactory;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.huya.client.HuyaLiveChatClient;
import tech.ordinaryroad.live.chat.client.huya.config.HuyaLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientConnectionHandler;

@ChannelHandler.Sharable
public class HuyaConnectionHandler
extends BaseNettyClientConnectionHandler<HuyaLiveChatClient, HuyaConnectionHandler> {
    private static final Logger log = LoggerFactory.getLogger(HuyaConnectionHandler.class);
    private final Object roomId;
    private final String ver;
    private String cookie;

    public HuyaConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, HuyaLiveChatClient client, IBaseConnectionListener<HuyaConnectionHandler> listener) {
        super(webSocketProtocolHandler, (BaseNettyClient)client, listener);
        this.roomId = ((HuyaLiveChatClientConfig)client.getConfig()).getRoomId();
        this.ver = ((HuyaLiveChatClientConfig)client.getConfig()).getVer();
        this.cookie = ((HuyaLiveChatClientConfig)client.getConfig()).getCookie();
    }

    public HuyaConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, HuyaLiveChatClient client) {
        this(webSocketProtocolHandler, client, null);
    }

    public HuyaConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, long roomId, String ver, IBaseConnectionListener<HuyaConnectionHandler> listener, String cookie) {
        super(webSocketProtocolHandler, listener);
        this.roomId = roomId;
        this.ver = ver;
        this.cookie = cookie;
    }

    public HuyaConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, long roomId, String ver, IBaseConnectionListener<HuyaConnectionHandler> listener) {
        this(webSocketProtocolHandler, roomId, ver, listener, null);
    }

    public HuyaConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, long roomId, String ver, String cookie) {
        this(webSocketProtocolHandler, roomId, ver, null, cookie);
    }

    public HuyaConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, long roomId, String ver) {
        this(webSocketProtocolHandler, roomId, ver, null, null);
    }

    public void sendHeartbeat(Channel channel) {
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u9001\u5fc3\u8df3\u5305");
        }
        channel.writeAndFlush((Object)HuyaConnectionHandler.getWebSocketFrameFactory(this.getRoomId()).createHeartbeat(this.getVer(), this.getCookie())).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5fc3\u8df3\u5305\u53d1\u9001\u5b8c\u6210");
                }
            } else {
                log.error("\u5fc3\u8df3\u5305\u53d1\u9001\u5931\u8d25", future.cause());
            }
        }));
    }

    private static HuyaMsgFactory getWebSocketFrameFactory(Object roomId) {
        return HuyaMsgFactory.getInstance((Object)roomId);
    }

    public void sendAuthRequest(Channel channel) {
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u9001\u8ba4\u8bc1\u5305");
        }
        channel.writeAndFlush((Object)HuyaConnectionHandler.getWebSocketFrameFactory(this.getRoomId()).createAuth(this.getVer(), this.getCookie())).addListener(future -> {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u8ba4\u8bc1\u5305\u53d1\u9001\u5b8c\u6210");
                }
            } else {
                log.error("\u8ba4\u8bc1\u5305\u53d1\u9001\u5931\u8d25", future.cause());
            }
        });
    }

    public Object getRoomId() {
        return this.client != null ? ((HuyaLiveChatClientConfig)((HuyaLiveChatClient)this.client).getConfig()).getRoomId() : this.roomId;
    }

    public String getVer() {
        return this.client != null ? ((HuyaLiveChatClientConfig)((HuyaLiveChatClient)this.client).getConfig()).getVer() : this.ver;
    }

    private String getCookie() {
        return this.client != null ? ((HuyaLiveChatClientConfig)((HuyaLiveChatClient)this.client).getConfig()).getCookie() : this.cookie;
    }
}

