/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.huya.netty.handler;

import com.qq.tars.protocol.tars.TarsInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.huya.api.HuyaApis;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaCmdEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaOperationEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaWupFunctionEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.GetPropsListRsp;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.MessageNoticeMsg;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.SendItemSubBroadcastPacketMsg;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.VipEnterBannerMsg;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WSPushMessage;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WupRsp;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.base.IHuyaMsg;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.PropsItem;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.WSMsgItem;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.factory.HuyaMsgFactory;
import tech.ordinaryroad.live.chat.client.codec.huya.util.HuyaCodecUtil;
import tech.ordinaryroad.live.chat.client.commons.base.msg.ICmdMsg;
import tech.ordinaryroad.live.chat.client.commons.base.msg.IMsg;
import tech.ordinaryroad.live.chat.client.huya.client.HuyaLiveChatClient;
import tech.ordinaryroad.live.chat.client.huya.config.HuyaLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.huya.listener.IHuyaMsgListener;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientBinaryFrameHandler;

@ChannelHandler.Sharable
public class HuyaBinaryFrameHandler
extends BaseNettyClientBinaryFrameHandler<HuyaLiveChatClient, HuyaBinaryFrameHandler, HuyaCmdEnum, IHuyaMsg, IHuyaMsgListener> {
    private static final Logger log = LoggerFactory.getLogger(HuyaBinaryFrameHandler.class);
    private final String ver;
    private ChannelHandlerContext channelHandlerContext;

    public HuyaBinaryFrameHandler(List<IHuyaMsgListener> iHuyaMsgListeners, HuyaLiveChatClient client, long roomId) {
        super(iHuyaMsgListeners, (BaseNettyClient)client, roomId);
        this.ver = ((HuyaLiveChatClientConfig)client.getConfig()).getVer();
    }

    public HuyaBinaryFrameHandler(List<IHuyaMsgListener> iHuyaMsgListeners, HuyaLiveChatClient client) {
        super(iHuyaMsgListeners, (BaseNettyClient)client);
        this.ver = ((HuyaLiveChatClientConfig)client.getConfig()).getVer();
    }

    public HuyaBinaryFrameHandler(List<IHuyaMsgListener> iHuyaMsgListeners, long roomId, String ver) {
        super(iHuyaMsgListeners, roomId);
        this.ver = ver;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.channelHandlerContext = ctx;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.channelHandlerContext = null;
    }

    public void onMsg(IMsg msg) {
        IHuyaMsg iHuyaMsg = (IHuyaMsg)msg;
        HuyaOperationEnum operationEnum = iHuyaMsg.getOperationEnum();
        if (operationEnum == HuyaOperationEnum.EWSCmdS2C_RegisterGroupRsp) {
            this.channelHandlerContext.writeAndFlush((Object)HuyaMsgFactory.getInstance((Object)this.getRoomId()).createGiftListReq(this.getVer()));
        } else if (operationEnum == HuyaOperationEnum.EWSCmd_WupRsp) {
            WupRsp wupRsp = (WupRsp)msg;
            String functionName = wupRsp.getTarsServantRequest().getFunctionName();
            HuyaWupFunctionEnum wupFunctionEnum = HuyaWupFunctionEnum.getByName((String)functionName);
            if (wupFunctionEnum == null) {
                if (log.isWarnEnabled()) {
                    log.warn("\u672a\u77e5 function {}", (Object)functionName);
                }
                return;
            }
            switch (wupFunctionEnum) {
                case doLaunch: {
                    this.channelHandlerContext.writeAndFlush((Object)HuyaMsgFactory.getInstance((Object)this.getRoomId()).createRegisterGroupReq());
                    break;
                }
                case getPropsList: {
                    GetPropsListRsp getPropsListRsp = new GetPropsListRsp();
                    getPropsListRsp = (GetPropsListRsp)wupRsp.getUniAttribute().getByClass("tRsp", (Object)getPropsListRsp);
                    for (PropsItem propsItem : getPropsListRsp.getVPropsItemList()) {
                        HuyaApis.GIFT_ITEMS.put(propsItem.getIPropsId(), propsItem);
                    }
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug("\u6682\u4e0d\u652f\u6301 function {}", (Object)wupFunctionEnum);
                }
            }
        }
    }

    public void onCmdMsg(HuyaCmdEnum cmd, ICmdMsg<HuyaCmdEnum> cmdMsg) {
        byte[] dataBytes;
        if (this.msgListeners.isEmpty()) {
            return;
        }
        if (cmdMsg instanceof WSPushMessage) {
            WSPushMessage wsPushMessage = (WSPushMessage)cmdMsg;
            dataBytes = wsPushMessage.getDataBytes();
        } else if (cmdMsg instanceof WSMsgItem) {
            WSMsgItem wsMsgItem = (WSMsgItem)cmdMsg;
            dataBytes = wsMsgItem.getSMsg();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("\u975eHuyaCmdMsg {}", cmdMsg.getClass());
            }
            return;
        }
        TarsInputStream tarsInputStream = HuyaCodecUtil.newUtf8TarsInputStream((byte[])dataBytes);
        switch (cmd) {
            case MessageNotice: {
                MessageNoticeMsg messageNoticeMsg = new MessageNoticeMsg(tarsInputStream);
                this.iteratorMsgListeners(msgListener -> msgListener.onDanmuMsg((Object)this, messageNoticeMsg));
                break;
            }
            case SendItemSubBroadcastPacket: {
                SendItemSubBroadcastPacketMsg sendItemSubBroadcastPacketMsg = new SendItemSubBroadcastPacketMsg(tarsInputStream);
                sendItemSubBroadcastPacketMsg.setPropsItem(HuyaApis.GIFT_ITEMS.getOrDefault(sendItemSubBroadcastPacketMsg.getIItemType(), PropsItem.DEFAULT));
                this.iteratorMsgListeners(msgListener -> msgListener.onGiftMsg((Object)this, sendItemSubBroadcastPacketMsg));
                break;
            }
            case VipEnterBanner: {
                VipEnterBannerMsg vipEnterBannerMsg = new VipEnterBannerMsg(tarsInputStream);
                this.iteratorMsgListeners(msgListener -> msgListener.onEnterRoomMsg((Object)this, vipEnterBannerMsg));
                break;
            }
            default: {
                this.iteratorMsgListeners(msgListener -> msgListener.onOtherCmdMsg((Object)this, (Enum)cmd, cmdMsg));
            }
        }
    }

    public String getVer() {
        return this.client != null ? ((HuyaLiveChatClientConfig)((HuyaLiveChatClient)this.client).getConfig()).getVer() : this.ver;
    }
}

