/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.douyin.netty.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.douyin.client.DouyinLiveChatClient;
import tech.ordinaryroad.live.chat.client.douyin.config.DouyinLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientConnectionHandler;

@ChannelHandler.Sharable
public class DouyinConnectionHandler
extends BaseNettyClientConnectionHandler<DouyinLiveChatClient, DouyinConnectionHandler> {
    private static final Logger log = LoggerFactory.getLogger(DouyinConnectionHandler.class);
    private final Object roomId;
    private String cookie;

    public DouyinConnectionHandler(WebSocketClientHandshaker handshaker, DouyinLiveChatClient client, IBaseConnectionListener<DouyinConnectionHandler> listener) {
        super(handshaker, (BaseNettyClient)client, listener);
        this.roomId = ((DouyinLiveChatClientConfig)client.getConfig()).getRoomId();
        this.cookie = ((DouyinLiveChatClientConfig)client.getConfig()).getCookie();
    }

    public DouyinConnectionHandler(WebSocketClientHandshaker handshaker, DouyinLiveChatClient client) {
        this(handshaker, client, null);
    }

    public DouyinConnectionHandler(WebSocketClientHandshaker handshaker, long roomId, IBaseConnectionListener<DouyinConnectionHandler> listener, String cookie) {
        super(handshaker, listener);
        this.roomId = roomId;
        this.cookie = cookie;
    }

    public DouyinConnectionHandler(WebSocketClientHandshaker handshaker, long roomId, IBaseConnectionListener<DouyinConnectionHandler> listener) {
        this(handshaker, roomId, listener, null);
    }

    public DouyinConnectionHandler(WebSocketClientHandshaker handshaker, long roomId, String cookie) {
        this(handshaker, roomId, null, cookie);
    }

    public DouyinConnectionHandler(WebSocketClientHandshaker handshaker, long roomId) {
        this(handshaker, roomId, null, null);
    }

    protected void sendHeartbeat(ChannelHandlerContext ctx) {
    }

    public void sendAuthRequest(Channel channel) {
    }

    protected long getHeartbeatPeriod() {
        if (this.client == null) {
            return 25L;
        }
        return ((DouyinLiveChatClientConfig)((DouyinLiveChatClient)this.client).getConfig()).getHeartbeatPeriod();
    }

    protected long getHeartbeatInitialDelay() {
        if (this.client == null) {
            return 15L;
        }
        return ((DouyinLiveChatClientConfig)((DouyinLiveChatClient)this.client).getConfig()).getHeartbeatInitialDelay();
    }

    public Object getRoomId() {
        return this.client != null ? ((DouyinLiveChatClientConfig)((DouyinLiveChatClient)this.client).getConfig()).getRoomId() : this.roomId;
    }

    private String getCookie() {
        return this.client != null ? ((DouyinLiveChatClientConfig)((DouyinLiveChatClient)this.client).getConfig()).getCookie() : this.cookie;
    }
}

