/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.douyin.netty.handler;

import cn.hutool.core.util.ZipUtil;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.msg.ICmdMsg;
import tech.ordinaryroad.live.chat.client.douyin.client.DouyinLiveChatClient;
import tech.ordinaryroad.live.chat.client.douyin.constant.DouyinCmdEnum;
import tech.ordinaryroad.live.chat.client.douyin.listener.IDouyinMsgListener;
import tech.ordinaryroad.live.chat.client.douyin.msg.DouyinDanmuMsg;
import tech.ordinaryroad.live.chat.client.douyin.msg.DouyinEnterRoomMsg;
import tech.ordinaryroad.live.chat.client.douyin.msg.DouyinGiftMsg;
import tech.ordinaryroad.live.chat.client.douyin.msg.base.IDouyinMsg;
import tech.ordinaryroad.live.chat.client.douyin.protobuf.douyin_cmd_msg;
import tech.ordinaryroad.live.chat.client.douyin.protobuf.douyin_webcast_chat_message_msg;
import tech.ordinaryroad.live.chat.client.douyin.protobuf.douyin_webcast_gift_message_msg;
import tech.ordinaryroad.live.chat.client.douyin.protobuf.douyin_webcast_member_message_msg;
import tech.ordinaryroad.live.chat.client.douyin.protobuf.douyin_websocket_frame;
import tech.ordinaryroad.live.chat.client.douyin.protobuf.douyin_websocket_frame_msg;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientBinaryFrameHandler;

@ChannelHandler.Sharable
public class DouyinBinaryFrameHandler
extends BaseNettyClientBinaryFrameHandler<DouyinLiveChatClient, DouyinBinaryFrameHandler, DouyinCmdEnum, IDouyinMsg, IDouyinMsgListener> {
    private static final Logger log = LoggerFactory.getLogger(DouyinBinaryFrameHandler.class);
    private ChannelHandlerContext channelHandlerContext;

    public DouyinBinaryFrameHandler(List<IDouyinMsgListener> iDouyinMsgListeners, DouyinLiveChatClient client) {
        super(iDouyinMsgListeners, (BaseNettyClient)client);
    }

    public DouyinBinaryFrameHandler(List<IDouyinMsgListener> iDouyinMsgListeners, long roomId) {
        super(iDouyinMsgListeners, roomId);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.channelHandlerContext = ctx;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.channelHandlerContext = null;
    }

    public void onCmdMsg(DouyinCmdEnum cmd, ICmdMsg<DouyinCmdEnum> cmdMsg) {
        if (this.msgListeners.isEmpty()) {
            return;
        }
        ByteString payload = ((douyin_cmd_msg)cmdMsg).getPayload();
        switch (cmd) {
            case WebcastChatMessage: {
                try {
                    douyin_webcast_chat_message_msg douyinWebcastChatMessageMsg = douyin_webcast_chat_message_msg.parseFrom(payload);
                    this.iteratorMsgListeners(msgListener -> msgListener.onDanmuMsg((Object)this, new DouyinDanmuMsg(douyinWebcastChatMessageMsg)));
                    break;
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
            case WebcastGiftMessage: {
                try {
                    douyin_webcast_gift_message_msg douyinWebcastGiftMessageMsg = douyin_webcast_gift_message_msg.parseFrom(payload);
                    this.iteratorMsgListeners(msgListener -> msgListener.onGiftMsg((Object)this, new DouyinGiftMsg(douyinWebcastGiftMessageMsg)));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new BaseException((Throwable)e);
                }
            }
            case WebcastMemberMessage: {
                try {
                    douyin_webcast_member_message_msg douyinWebcastMemberMessageMsg = douyin_webcast_member_message_msg.parseFrom(payload);
                    this.iteratorMsgListeners(msgListener -> msgListener.onEnterRoomMsg((Object)this, new DouyinEnterRoomMsg(douyinWebcastMemberMessageMsg)));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new BaseException((Throwable)e);
                }
            }
            default: {
                this.iteratorMsgListeners(msgListener -> msgListener.onOtherCmdMsg((Object)this, cmd, cmdMsg));
            }
        }
    }

    protected List<IDouyinMsg> decode(ByteBuf byteBuf) {
        try {
            douyin_websocket_frame douyinWebsocketFrame = douyin_websocket_frame.parseFrom(byteBuf.nioBuffer());
            ByteString payload = douyinWebsocketFrame.getPayload();
            byte[] bytes = ZipUtil.unGzip((InputStream)payload.newInput());
            douyin_websocket_frame_msg douyinWebsocketFrameMsg = douyin_websocket_frame_msg.parseFrom(bytes);
            if (douyinWebsocketFrameMsg.getNeedAck()) {
                douyin_websocket_frame ack = douyin_websocket_frame.newBuilder().setLogId(douyinWebsocketFrame.getLogId()).setPayloadType("ack").setPayload(douyinWebsocketFrameMsg.getInternalExtBytes()).build();
                this.channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])ack.toByteArray())));
            }
            return new ArrayList<IDouyinMsg>(douyinWebsocketFrameMsg.getMessagesListList());
        }
        catch (InvalidProtocolBufferException e) {
            throw new BaseException((Throwable)e);
        }
    }
}

