/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.douyin.client;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.GlobalHeaders;
import cn.hutool.http.Header;
import cn.hutool.http.HttpUtil;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.douyin.api.DouyinApis;
import tech.ordinaryroad.live.chat.client.douyin.config.DouyinLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.douyin.constant.DouyinCmdEnum;
import tech.ordinaryroad.live.chat.client.douyin.listener.IDouyinConnectionListener;
import tech.ordinaryroad.live.chat.client.douyin.listener.IDouyinMsgListener;
import tech.ordinaryroad.live.chat.client.douyin.msg.base.IDouyinMsg;
import tech.ordinaryroad.live.chat.client.douyin.netty.handler.DouyinBinaryFrameHandler;
import tech.ordinaryroad.live.chat.client.douyin.netty.handler.DouyinConnectionHandler;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.config.BaseNettyClientConfig;

public class DouyinLiveChatClient
extends BaseNettyClient<DouyinLiveChatClientConfig, DouyinCmdEnum, IDouyinMsg, IDouyinMsgListener, DouyinConnectionHandler, DouyinBinaryFrameHandler> {
    private static final Logger log = LoggerFactory.getLogger(DouyinLiveChatClient.class);
    private DouyinApis.RoomInitResult roomInitResult = new DouyinApis.RoomInitResult();

    public DouyinLiveChatClient(DouyinLiveChatClientConfig config, List<IDouyinMsgListener> msgListeners, IDouyinConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListeners(msgListeners);
        this.init();
    }

    public DouyinLiveChatClient(DouyinLiveChatClientConfig config, IDouyinMsgListener msgListener, IDouyinConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListener(msgListener);
        this.init();
    }

    public DouyinLiveChatClient(DouyinLiveChatClientConfig config, IDouyinMsgListener msgListener, IDouyinConnectionListener connectionListener) {
        this(config, msgListener, connectionListener, (EventLoopGroup)new NioEventLoopGroup());
    }

    public DouyinLiveChatClient(DouyinLiveChatClientConfig config, IDouyinMsgListener msgListener) {
        this(config, msgListener, null, (EventLoopGroup)new NioEventLoopGroup());
    }

    public DouyinLiveChatClient(DouyinLiveChatClientConfig config) {
        this(config, null);
    }

    public void init() {
        this.roomInitResult = DouyinApis.roomInit(((DouyinLiveChatClientConfig)this.getConfig()).getRoomId(), ((DouyinLiveChatClientConfig)this.getConfig()).getCookie());
        super.init();
    }

    public DouyinConnectionHandler initConnectionHandler(IBaseConnectionListener<DouyinConnectionHandler> clientConnectionListener) {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(Header.COOKIE.name(), (Object)("ttwid=" + this.roomInitResult.getTtwid()));
        headers.add(Header.USER_AGENT.name(), (Object)GlobalHeaders.INSTANCE.header(Header.USER_AGENT));
        return new DouyinConnectionHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.getWebsocketUri(), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)headers, (int)((DouyinLiveChatClientConfig)this.getConfig()).getMaxFramePayloadLength()), this, clientConnectionListener);
    }

    public DouyinBinaryFrameHandler initBinaryFrameHandler() {
        return new DouyinBinaryFrameHandler((List<IDouyinMsgListener>)this.msgListeners, this);
    }

    protected String getWebSocketUriString() {
        long realRoomId = this.roomInitResult.getRealRoomId();
        String userUniqueId = this.roomInitResult.getUserUniqueId();
        String webSocketUriString = super.getWebSocketUriString();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("app_name", "douyin_web");
        queryParams.put("version_code", ((DouyinLiveChatClientConfig)this.getConfig()).getVersionCode());
        queryParams.put("webcast_sdk_version", ((DouyinLiveChatClientConfig)this.getConfig()).getWebcastSdkVersion());
        queryParams.put("update_version_code", ((DouyinLiveChatClientConfig)this.getConfig()).getUpdateVersionCode());
        queryParams.put("compress", "gzip");
        queryParams.put("device_platform", "web");
        queryParams.put("cookie_enabled", "true");
        queryParams.put("screen_width", "800");
        queryParams.put("screen_height", "1280");
        queryParams.put("browser_language", "zh-CN");
        queryParams.put("browser_platform", "MacIntel");
        queryParams.put("browser_name", "Mozilla");
        queryParams.put("browser_version", "5.0%20(Macintosh;%20Intel%20Mac%20OS%20X%2010_15_7)%20AppleWebKit/537.36%20(KHTML,%20like%20Gecko)%20Chrome/116.0.0.0%20Safari/537.36");
        queryParams.put("browser_online", "true");
        queryParams.put("tz_name", "Asia/Shanghai");
        queryParams.put("host", "https://live.douyin.com");
        queryParams.put("im_path", "/webcast/im/fetch/");
        queryParams.put("endpoint", "live_pc");
        queryParams.put("identity", "audience");
        queryParams.put("support_wrds", "1");
        queryParams.put("heartbeatDuration ", "0");
        queryParams.put("live_id", "1");
        queryParams.put("did_rule", "3");
        queryParams.put("aid", "6383");
        queryParams.put("room_id", Long.toString(realRoomId));
        queryParams.put("user_unique_id", userUniqueId);
        queryParams.put("signature", "00000000");
        queryParams.put("cursor", "t-" + System.currentTimeMillis() + "_r-1_d-1_u-1_h-1");
        queryParams.put("internal_ext", "internal_src:dim|wss_push_room_id:" + realRoomId + "|wss_push_did:" + userUniqueId + "|dim_log_id:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + RandomUtil.randomNumbers((int)6) + RandomUtil.randomString((String)"0123456789ABCDEF", (int)20) + "|first_req_ms:" + System.currentTimeMillis() + "|fetch_time:" + System.currentTimeMillis() + "|seq:1|wss_info:0-" + System.currentTimeMillis() + "-0-0|wrds_kvs:WebcastRoomStatsMessage-" + System.nanoTime() + "_WebcastRoomRankMessage-" + System.nanoTime() + "_LotteryInfoSyncData-" + System.nanoTime() + "_WebcastActivityEmojiGroupsMessage-" + System.nanoTime());
        return webSocketUriString + "?" + HttpUtil.toParams(queryParams);
    }

    public void sendDanmu(Object danmu, Runnable success, Consumer<Throwable> failed) {
        super.sendDanmu(danmu, success, failed);
    }
}

