/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.douyin.api;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;

public class DouyinApis {
    private static final Logger log = LoggerFactory.getLogger(DouyinApis.class);
    public static final String KEY_COOKIE_TTWID = "ttwid";
    public static final String KEY_COOKIE_MS_TOKEN = "msToken";
    public static final String KEY_COOKIE_AC_NONCE = "__ac_nonce";
    public static final String MS_TOKEN_BASE_STRING = "abcdefghijklmnopqrstuvwxyz0123456789=_";
    public static final int MS_TOKEN_LENGTH = 107;
    public static final int AC_NONCE_LENGTH = 21;
    public static final String PATTERN_USER_UNIQUE_ID = "\\\\\"user_unique_id\\\\\":\\\\\"(\\d+)\\\\\"";
    public static final String PATTERN_ROOM_ID = "\\\\\"roomId\\\\\":\\\\\"(\\d+)\\\\\"";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomInitResult roomInit(Object roomId, String cookie) {
        Map cookieMap = OrLiveChatCookieUtil.parseCookieString((String)cookie);
        HttpResponse response1 = HttpUtil.createGet((String)"https://live.douyin.com/").cookie(cookie).execute();
        try {
            RoomInitResult roomInitResult;
            block11: {
                String ttwid = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)KEY_COOKIE_TTWID, () -> response1.getCookie(KEY_COOKIE_TTWID).getValue());
                String msToken = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)KEY_COOKIE_MS_TOKEN, () -> RandomUtil.randomString((String)MS_TOKEN_BASE_STRING, (int)107));
                String __ac_nonce = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)KEY_COOKIE_AC_NONCE, () -> RandomUtil.randomString((int)21));
                HttpResponse response2 = HttpUtil.createGet((String)("https://live.douyin.com/" + roomId)).cookie(StrUtil.emptyToDefault((CharSequence)cookie, (String)("ttwid=" + ttwid + "; " + KEY_COOKIE_MS_TOKEN + "=" + msToken + "; " + KEY_COOKIE_AC_NONCE + "=" + __ac_nonce))).execute();
                try {
                    long realRoomId;
                    if (response2.getStatus() != 200) {
                        throw new BaseException("\u83b7\u53d6" + roomId + "\u771f\u5b9e\u623f\u95f4ID\u5931\u8d25");
                    }
                    String user_unique_id = StrUtil.emptyToDefault((CharSequence)ReUtil.getGroup1((String)PATTERN_USER_UNIQUE_ID, (CharSequence)response2.body()), (String)RandomUtil.randomNumbers((int)19));
                    String realRoomIdString = ReUtil.getGroup1((String)PATTERN_ROOM_ID, (CharSequence)response2.body());
                    try {
                        realRoomId = NumberUtil.parseLong((String)realRoomIdString);
                    }
                    catch (Exception e) {
                        throw new BaseException("\u83b7\u53d6" + roomId + "\u771f\u5b9e\u623f\u95f4ID\u5931\u8d25");
                    }
                    roomInitResult = RoomInitResult.builder().ttwid(ttwid).msToken(msToken).acNonce(__ac_nonce).realRoomId(realRoomId).userUniqueId(user_unique_id).build();
                    if (Collections.singletonList(response2).get(0) == null) break block11;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(response2).get(0) != null) {
                        response2.close();
                    }
                    throw throwable;
                }
                response2.close();
            }
            return roomInitResult;
        }
        finally {
            if (Collections.singletonList(response1).get(0) != null) {
                response1.close();
            }
        }
    }

    public static RoomInitResult roomInit(Object roomId) {
        return DouyinApis.roomInit(roomId, null);
    }

    public static class RoomInitResult {
        private String ttwid;
        private String msToken;
        private String acNonce;
        private long realRoomId;
        private String userUniqueId;

        public static RoomInitResultBuilder builder() {
            return new RoomInitResultBuilder();
        }

        public String getTtwid() {
            return this.ttwid;
        }

        public String getMsToken() {
            return this.msToken;
        }

        public String getAcNonce() {
            return this.acNonce;
        }

        public long getRealRoomId() {
            return this.realRoomId;
        }

        public String getUserUniqueId() {
            return this.userUniqueId;
        }

        public void setTtwid(String ttwid) {
            this.ttwid = ttwid;
        }

        public void setMsToken(String msToken) {
            this.msToken = msToken;
        }

        public void setAcNonce(String acNonce) {
            this.acNonce = acNonce;
        }

        public void setRealRoomId(long realRoomId) {
            this.realRoomId = realRoomId;
        }

        public void setUserUniqueId(String userUniqueId) {
            this.userUniqueId = userUniqueId;
        }

        public RoomInitResult(String ttwid, String msToken, String acNonce, long realRoomId, String userUniqueId) {
            this.ttwid = ttwid;
            this.msToken = msToken;
            this.acNonce = acNonce;
            this.realRoomId = realRoomId;
            this.userUniqueId = userUniqueId;
        }

        public RoomInitResult() {
        }

        public static class RoomInitResultBuilder {
            private String ttwid;
            private String msToken;
            private String acNonce;
            private long realRoomId;
            private String userUniqueId;

            RoomInitResultBuilder() {
            }

            public RoomInitResultBuilder ttwid(String ttwid) {
                this.ttwid = ttwid;
                return this;
            }

            public RoomInitResultBuilder msToken(String msToken) {
                this.msToken = msToken;
                return this;
            }

            public RoomInitResultBuilder acNonce(String acNonce) {
                this.acNonce = acNonce;
                return this;
            }

            public RoomInitResultBuilder realRoomId(long realRoomId) {
                this.realRoomId = realRoomId;
                return this;
            }

            public RoomInitResultBuilder userUniqueId(String userUniqueId) {
                this.userUniqueId = userUniqueId;
                return this;
            }

            public RoomInitResult build() {
                return new RoomInitResult(this.ttwid, this.msToken, this.acNonce, this.realRoomId, this.userUniqueId);
            }

            public String toString() {
                return "DouyinApis.RoomInitResult.RoomInitResultBuilder(ttwid=" + this.ttwid + ", msToken=" + this.msToken + ", acNonce=" + this.acNonce + ", realRoomId=" + this.realRoomId + ", userUniqueId=" + this.userUniqueId + ")";
            }
        }
    }
}

