/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.commons.client.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;

public abstract class BaseLiveChatClientConfig {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final long DEFAULT_HEARTBEAT_INITIAL_DELAY = 15L;
    public static final long DEFAULT_HEARTBEAT_PERIOD = 25L;
    public static final long DEFAULT_MIN_SEND_DANMU_PERIOD = 3000L;
    private String websocketUri;
    private String cookie;
    private Object roomId;
    private boolean autoReconnect;
    private int reconnectDelay;
    private long heartbeatInitialDelay;
    private long heartbeatPeriod;
    private long minSendDanmuPeriod;

    public void setCookie(String cookie) {
        String oldValue = this.cookie;
        this.cookie = cookie;
        this.propertyChangeSupport.firePropertyChange("cookie", oldValue, cookie);
    }

    public void setRoomId(Object roomId) {
        if (!(roomId instanceof Number) && !(roomId instanceof String)) {
            throw new BaseException("\u623f\u95f4ID\u4ec5\u652f\u6301\u6570\u5b57\u6216\u5b57\u7b26\u4e32\uff0c\u6240\u4f20\u53c2\u6570\u7c7b\u578b\uff1a" + roomId.getClass() + "\u503c\uff1a" + roomId);
        }
        Object oldValue = this.roomId;
        this.roomId = roomId;
        this.propertyChangeSupport.firePropertyChange("roomId", oldValue, roomId);
    }

    public void setWebsocketUri(String websocketUri) {
        String oldValue = this.websocketUri;
        this.websocketUri = websocketUri;
        this.propertyChangeSupport.firePropertyChange("websocketUri", oldValue, websocketUri);
    }

    public void setMinSendDanmuPeriod(long minSendDanmuPeriod) {
        long oldValue = this.minSendDanmuPeriod;
        this.minSendDanmuPeriod = minSendDanmuPeriod;
        this.propertyChangeSupport.firePropertyChange("minSendDanmuPeriod", oldValue, minSendDanmuPeriod);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private static boolean $default$autoReconnect() {
        return Boolean.TRUE;
    }

    private static int $default$reconnectDelay() {
        return 5;
    }

    private static long $default$heartbeatInitialDelay() {
        return 15L;
    }

    private static long $default$heartbeatPeriod() {
        return 25L;
    }

    private static long $default$minSendDanmuPeriod() {
        return 3000L;
    }

    protected BaseLiveChatClientConfig(BaseLiveChatClientConfigBuilder<?, ?> b) {
        this.propertyChangeSupport = ((BaseLiveChatClientConfigBuilder)b).propertyChangeSupport;
        this.websocketUri = ((BaseLiveChatClientConfigBuilder)b).websocketUri;
        this.cookie = ((BaseLiveChatClientConfigBuilder)b).cookie;
        this.roomId = ((BaseLiveChatClientConfigBuilder)b).roomId;
        this.autoReconnect = ((BaseLiveChatClientConfigBuilder)b).autoReconnect$set ? ((BaseLiveChatClientConfigBuilder)b).autoReconnect$value : BaseLiveChatClientConfig.$default$autoReconnect();
        this.reconnectDelay = ((BaseLiveChatClientConfigBuilder)b).reconnectDelay$set ? ((BaseLiveChatClientConfigBuilder)b).reconnectDelay$value : BaseLiveChatClientConfig.$default$reconnectDelay();
        this.heartbeatInitialDelay = ((BaseLiveChatClientConfigBuilder)b).heartbeatInitialDelay$set ? ((BaseLiveChatClientConfigBuilder)b).heartbeatInitialDelay$value : BaseLiveChatClientConfig.$default$heartbeatInitialDelay();
        this.heartbeatPeriod = ((BaseLiveChatClientConfigBuilder)b).heartbeatPeriod$set ? ((BaseLiveChatClientConfigBuilder)b).heartbeatPeriod$value : BaseLiveChatClientConfig.$default$heartbeatPeriod();
        this.minSendDanmuPeriod = ((BaseLiveChatClientConfigBuilder)b).minSendDanmuPeriod$set ? ((BaseLiveChatClientConfigBuilder)b).minSendDanmuPeriod$value : BaseLiveChatClientConfig.$default$minSendDanmuPeriod();
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public String getWebsocketUri() {
        return this.websocketUri;
    }

    public String getCookie() {
        return this.cookie;
    }

    public Object getRoomId() {
        return this.roomId;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    public long getHeartbeatInitialDelay() {
        return this.heartbeatInitialDelay;
    }

    public long getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public long getMinSendDanmuPeriod() {
        return this.minSendDanmuPeriod;
    }

    public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public void setHeartbeatInitialDelay(long heartbeatInitialDelay) {
        this.heartbeatInitialDelay = heartbeatInitialDelay;
    }

    public void setHeartbeatPeriod(long heartbeatPeriod) {
        this.heartbeatPeriod = heartbeatPeriod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseLiveChatClientConfig)) {
            return false;
        }
        BaseLiveChatClientConfig other = (BaseLiveChatClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoReconnect() != other.isAutoReconnect()) {
            return false;
        }
        if (this.getReconnectDelay() != other.getReconnectDelay()) {
            return false;
        }
        if (this.getHeartbeatInitialDelay() != other.getHeartbeatInitialDelay()) {
            return false;
        }
        if (this.getHeartbeatPeriod() != other.getHeartbeatPeriod()) {
            return false;
        }
        if (this.getMinSendDanmuPeriod() != other.getMinSendDanmuPeriod()) {
            return false;
        }
        PropertyChangeSupport this$propertyChangeSupport = this.getPropertyChangeSupport();
        PropertyChangeSupport other$propertyChangeSupport = other.getPropertyChangeSupport();
        if (this$propertyChangeSupport == null ? other$propertyChangeSupport != null : !this$propertyChangeSupport.equals(other$propertyChangeSupport)) {
            return false;
        }
        String this$websocketUri = this.getWebsocketUri();
        String other$websocketUri = other.getWebsocketUri();
        if (this$websocketUri == null ? other$websocketUri != null : !this$websocketUri.equals(other$websocketUri)) {
            return false;
        }
        String this$cookie = this.getCookie();
        String other$cookie = other.getCookie();
        if (this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie)) {
            return false;
        }
        Object this$roomId = this.getRoomId();
        Object other$roomId = other.getRoomId();
        return !(this$roomId == null ? other$roomId != null : !this$roomId.equals(other$roomId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseLiveChatClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoReconnect() ? 79 : 97);
        result = result * 59 + this.getReconnectDelay();
        long $heartbeatInitialDelay = this.getHeartbeatInitialDelay();
        result = result * 59 + (int)($heartbeatInitialDelay >>> 32 ^ $heartbeatInitialDelay);
        long $heartbeatPeriod = this.getHeartbeatPeriod();
        result = result * 59 + (int)($heartbeatPeriod >>> 32 ^ $heartbeatPeriod);
        long $minSendDanmuPeriod = this.getMinSendDanmuPeriod();
        result = result * 59 + (int)($minSendDanmuPeriod >>> 32 ^ $minSendDanmuPeriod);
        PropertyChangeSupport $propertyChangeSupport = this.getPropertyChangeSupport();
        result = result * 59 + ($propertyChangeSupport == null ? 43 : $propertyChangeSupport.hashCode());
        String $websocketUri = this.getWebsocketUri();
        result = result * 59 + ($websocketUri == null ? 43 : $websocketUri.hashCode());
        String $cookie = this.getCookie();
        result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
        Object $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : $roomId.hashCode());
        return result;
    }

    public String toString() {
        return "BaseLiveChatClientConfig(propertyChangeSupport=" + this.getPropertyChangeSupport() + ", websocketUri=" + this.getWebsocketUri() + ", cookie=" + this.getCookie() + ", roomId=" + this.getRoomId() + ", autoReconnect=" + this.isAutoReconnect() + ", reconnectDelay=" + this.getReconnectDelay() + ", heartbeatInitialDelay=" + this.getHeartbeatInitialDelay() + ", heartbeatPeriod=" + this.getHeartbeatPeriod() + ", minSendDanmuPeriod=" + this.getMinSendDanmuPeriod() + ")";
    }

    public BaseLiveChatClientConfig() {
        this.autoReconnect = BaseLiveChatClientConfig.$default$autoReconnect();
        this.reconnectDelay = BaseLiveChatClientConfig.$default$reconnectDelay();
        this.heartbeatInitialDelay = BaseLiveChatClientConfig.$default$heartbeatInitialDelay();
        this.heartbeatPeriod = BaseLiveChatClientConfig.$default$heartbeatPeriod();
        this.minSendDanmuPeriod = BaseLiveChatClientConfig.$default$minSendDanmuPeriod();
    }

    public BaseLiveChatClientConfig(PropertyChangeSupport propertyChangeSupport, String websocketUri, String cookie, Object roomId, boolean autoReconnect, int reconnectDelay, long heartbeatInitialDelay, long heartbeatPeriod, long minSendDanmuPeriod) {
        this.propertyChangeSupport = propertyChangeSupport;
        this.websocketUri = websocketUri;
        this.cookie = cookie;
        this.roomId = roomId;
        this.autoReconnect = autoReconnect;
        this.reconnectDelay = reconnectDelay;
        this.heartbeatInitialDelay = heartbeatInitialDelay;
        this.heartbeatPeriod = heartbeatPeriod;
        this.minSendDanmuPeriod = minSendDanmuPeriod;
    }

    public static abstract class BaseLiveChatClientConfigBuilder<C extends BaseLiveChatClientConfig, B extends BaseLiveChatClientConfigBuilder<C, B>> {
        private PropertyChangeSupport propertyChangeSupport;
        private String websocketUri;
        private String cookie;
        private Object roomId;
        private boolean autoReconnect$set;
        private boolean autoReconnect$value;
        private boolean reconnectDelay$set;
        private int reconnectDelay$value;
        private boolean heartbeatInitialDelay$set;
        private long heartbeatInitialDelay$value;
        private boolean heartbeatPeriod$set;
        private long heartbeatPeriod$value;
        private boolean minSendDanmuPeriod$set;
        private long minSendDanmuPeriod$value;

        protected B $fillValuesFrom(C instance) {
            BaseLiveChatClientConfigBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BaseLiveChatClientConfig instance, BaseLiveChatClientConfigBuilder<?, ?> b) {
            b.propertyChangeSupport(instance.propertyChangeSupport);
            b.websocketUri(instance.websocketUri);
            b.cookie(instance.cookie);
            b.roomId(instance.roomId);
            b.autoReconnect(instance.autoReconnect);
            b.reconnectDelay(instance.reconnectDelay);
            b.heartbeatInitialDelay(instance.heartbeatInitialDelay);
            b.heartbeatPeriod(instance.heartbeatPeriod);
            b.minSendDanmuPeriod(instance.minSendDanmuPeriod);
        }

        public B propertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
            this.propertyChangeSupport = propertyChangeSupport;
            return this.self();
        }

        public B websocketUri(String websocketUri) {
            this.websocketUri = websocketUri;
            return this.self();
        }

        public B cookie(String cookie) {
            this.cookie = cookie;
            return this.self();
        }

        public B roomId(Object roomId) {
            this.roomId = roomId;
            return this.self();
        }

        public B autoReconnect(boolean autoReconnect) {
            this.autoReconnect$value = autoReconnect;
            this.autoReconnect$set = true;
            return this.self();
        }

        public B reconnectDelay(int reconnectDelay) {
            this.reconnectDelay$value = reconnectDelay;
            this.reconnectDelay$set = true;
            return this.self();
        }

        public B heartbeatInitialDelay(long heartbeatInitialDelay) {
            this.heartbeatInitialDelay$value = heartbeatInitialDelay;
            this.heartbeatInitialDelay$set = true;
            return this.self();
        }

        public B heartbeatPeriod(long heartbeatPeriod) {
            this.heartbeatPeriod$value = heartbeatPeriod;
            this.heartbeatPeriod$set = true;
            return this.self();
        }

        public B minSendDanmuPeriod(long minSendDanmuPeriod) {
            this.minSendDanmuPeriod$value = minSendDanmuPeriod;
            this.minSendDanmuPeriod$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "BaseLiveChatClientConfig.BaseLiveChatClientConfigBuilder(propertyChangeSupport=" + this.propertyChangeSupport + ", websocketUri=" + this.websocketUri + ", cookie=" + this.cookie + ", roomId=" + this.roomId + ", autoReconnect$value=" + this.autoReconnect$value + ", reconnectDelay$value=" + this.reconnectDelay$value + ", heartbeatInitialDelay$value=" + this.heartbeatInitialDelay$value + ", heartbeatPeriod$value=" + this.heartbeatPeriod$value + ", minSendDanmuPeriod$value=" + this.minSendDanmuPeriod$value + ")";
        }
    }
}

