/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.huya.msg;

import com.qq.tars.protocol.tars.TarsInputStream;
import com.qq.tars.protocol.tars.TarsOutputStream;
import com.qq.tars.protocol.tars.TarsStructBase;
import java.util.HashMap;
import java.util.Map;

public class ConnectParaInfo
extends TarsStructBase {
    private long lUid = 0L;
    private String sGuid = "";
    private String sUA = "";
    private String sAppSrc = "";
    private String sMid = "";
    private String sExp = "";
    private int iTokenType = 0;
    private String sToken = "";
    private String sCookie = "";
    private String sTraceId = "";
    private Map<String, String> mCustomHeaders = new HashMap<String, String>(){
        {
            this.put("", "");
        }
    };

    public void writeTo(TarsOutputStream os) {
        os.write(this.lUid, 0);
        os.write(this.sGuid, 1);
        os.write(this.sUA, 2);
        os.write(this.sAppSrc, 3);
        os.write(this.sMid, 4);
        os.write(this.sExp, 5);
        os.write(this.iTokenType, 6);
        os.write(this.sToken, 7);
        os.write(this.sCookie, 8);
        os.write(this.sTraceId, 9);
        os.write(this.mCustomHeaders, 10);
    }

    public void readFrom(TarsInputStream is) {
        this.lUid = is.read(this.lUid, 0, false);
        this.sGuid = is.read(this.sGuid, 1, false);
        this.sUA = is.read(this.sUA, 2, false);
        this.sAppSrc = is.read(this.sAppSrc, 3, false);
        this.sMid = is.read(this.sMid, 4, false);
        this.sExp = is.read(this.sExp, 5, false);
        this.iTokenType = is.read(this.iTokenType, 6, false);
        this.sToken = is.read(this.sToken, 7, false);
        this.sCookie = is.read(this.sCookie, 8, false);
        this.sTraceId = is.read(this.sTraceId, 9, false);
        this.mCustomHeaders = is.readMap(this.mCustomHeaders, 10, false);
    }

    public static ConnectParaInfo newWSConnectParaInfo(String ver, String sExp, String appSrc) {
        final ConnectParaInfo wsConnectParaInfo = new ConnectParaInfo();
        wsConnectParaInfo.sUA = String.format("webh5&%s&websocket", ver);
        wsConnectParaInfo.sAppSrc = appSrc;
        wsConnectParaInfo.sExp = sExp;
        wsConnectParaInfo.mCustomHeaders = new HashMap<String, String>(){
            {
                this.put("HUYA_NET", "0");
                this.put("HUYA_VSDKUA", wsConnectParaInfo.sUA);
            }
        };
        return wsConnectParaInfo;
    }

    public long getLUid() {
        return this.lUid;
    }

    public String getSGuid() {
        return this.sGuid;
    }

    public String getSUA() {
        return this.sUA;
    }

    public String getSAppSrc() {
        return this.sAppSrc;
    }

    public String getSMid() {
        return this.sMid;
    }

    public String getSExp() {
        return this.sExp;
    }

    public int getITokenType() {
        return this.iTokenType;
    }

    public String getSToken() {
        return this.sToken;
    }

    public String getSCookie() {
        return this.sCookie;
    }

    public String getSTraceId() {
        return this.sTraceId;
    }

    public Map<String, String> getMCustomHeaders() {
        return this.mCustomHeaders;
    }

    public void setLUid(long lUid) {
        this.lUid = lUid;
    }

    public void setSGuid(String sGuid) {
        this.sGuid = sGuid;
    }

    public void setSUA(String sUA) {
        this.sUA = sUA;
    }

    public void setSAppSrc(String sAppSrc) {
        this.sAppSrc = sAppSrc;
    }

    public void setSMid(String sMid) {
        this.sMid = sMid;
    }

    public void setSExp(String sExp) {
        this.sExp = sExp;
    }

    public void setITokenType(int iTokenType) {
        this.iTokenType = iTokenType;
    }

    public void setSToken(String sToken) {
        this.sToken = sToken;
    }

    public void setSCookie(String sCookie) {
        this.sCookie = sCookie;
    }

    public void setSTraceId(String sTraceId) {
        this.sTraceId = sTraceId;
    }

    public void setMCustomHeaders(Map<String, String> mCustomHeaders) {
        this.mCustomHeaders = mCustomHeaders;
    }

    public ConnectParaInfo(long lUid, String sGuid, String sUA, String sAppSrc, String sMid, String sExp, int iTokenType, String sToken, String sCookie, String sTraceId, Map<String, String> mCustomHeaders) {
        this.lUid = lUid;
        this.sGuid = sGuid;
        this.sUA = sUA;
        this.sAppSrc = sAppSrc;
        this.sMid = sMid;
        this.sExp = sExp;
        this.iTokenType = iTokenType;
        this.sToken = sToken;
        this.sCookie = sCookie;
        this.sTraceId = sTraceId;
        this.mCustomHeaders = mCustomHeaders;
    }

    public ConnectParaInfo() {
    }
}

