/*
 * MIT License
 *
 * Copyright (c) 2023 OrdinaryRoad
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package tech.ordinaryroad.live.chat.client.codec.bilibili.constant;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * @author mjz
 * @date 2023/1/6
 */
@Getter
@RequiredArgsConstructor
public enum BilibiliCmdEnum {

    // region 最新CMD
    BIG_R_WELCOME,
    CHANGE_ROOM_INFO,
    /**
     * 礼物连击
     */
    COMBO_SEND,
    CUT_OFF,
    DANMU_GIFT_LOTTERY_START,
    DANMU_GIFT_LOTTERY_END,
    DANMU_GIFT_LOTTERY_AWARD,
    WARNING,
    /**
     * 收到礼物
     */
    DANMU_MSG,
    /**
     * 游客状态下，5分钟后会出现登录提示，弹幕中的用户名、用户id等信息将不再可见
     */
    LOG_IN_NOTICE,
    USER_TOAST_MSG,
    GUARD_ACHIEVEMENT_ROOM,
    /**
     * 开始直播
     */
    LIVE,
    REENTER_LIVE_ROOM,
    MESSAGEBOX_USER_GAIN_MEDAL,
    MESSAGEBOX_USER_MEDAL_CHANGE,
    MESSAGEBOX_USER_MEDAL_COMPENSATION,
    LITTLE_TIPS,
    LITTLE_MESSAGE_BOX,
    NOTICE_MSG,
    PK_MATCH,
    PK_PRE,
    PK_START,
    PK_PROCESS,
    PK_END,
    PK_SETTLE,
    PK_AGAIN,
    PK_MIC_END,
    PK_BATTLE_PRE_NEW,
    PK_BATTLE_START_NEW,
    PK_BATTLE_PROCESS_NEW,
    PK_BATTLE_FINAL_PROCESS,
    PK_BATTLE_PRO_TYPE,
    PK_BATTLE_GIFT,
    PK_BATTLE_SPECIAL_GIFT,
    PK_BATTLE_CRIT,
    PK_BATTLE_VOTES_ADD,
    PK_BATTLE_END,
    PK_BATTLE_SETTLE_NEW,
    PK_BATTLE_PUNISH_END,
    PK_BATTLE_VIDEO_PUNISH_BEGIN,
    PK_BATTLE_VIDEO_PUNISH_END,
    PK_BATTLE_RANK_CHANGE,
    PK_BATTLE_ABNORMAL,
    PK_BATTLE_MULTIPLE_BEGIN,
    PK_BATTLE_MULTIPLE_RES,
    PK_BATTLE_MULTIPLE_DRAW_RES,
    PK_BATTLE_MULTIPLE_AWARD,
    /**
     * 主播准备中
     */
    PREPARING,
    ROOM_REFRESH,
    ROOM_SKIN_MSG,
    TV_START,
    RAFFLE_START,
    TV_END,
    RAFFLE_END,
    PK_LOTTERY_START,
    GUARD_LOTTERY_START,
    ROOM_BLOCK_INTO,
    ROOM_BLOCK_MSG,
    ROOM_KICKOUT,
    ROOM_LOCK,
    ROOM_LIMIT,
    ROOM_SILENT_ON,
    ROOM_SILENT_OFF,
    /**
     * 收到礼物
     */
    SEND_GIFT,
    SEND_GIFT_V2,
    SEND_TOP,
    SPECIAL_GIFT,
    GIFT_PANEL_PLAN,
    INTERACT_WORD,
    /**
     * 欢迎高能用户、(舰长?待验证)特殊消息
     */
    ENTRY_EFFECT,
    ENTRY_EFFECT_MUST_RECEIVE,
    BOX_ACTIVITY_START,
    WIN_ACTIVITY,
    WIN_ACTIVITY_USER,
    ROOM_RANK,
    HOUR_RANK_AWARDS,
    LOL_ACTIVITY,
    ROOM_REAL_TIME_MESSAGE_UPDATE,
    VOICE_JOIN_STATUS,
    ROOM_CHANGE,
    /**
     * 醒目留言
     */
    SUPER_CHAT_MESSAGE,
    /**
     * 删除醒目留言
     */
    SUPER_CHAT_MESSAGE_DELETE,
    SUPER_CHAT_ENTRANCE,
    SUPER_CHAT_AUDIT,
    ANCHOR_LOT_CHECKSTATUS,
    ANCHOR_LOT_START,
    ANCHOR_LOT_END,
    ANCHOR_LOT_AWARD,
    ANCHOR_LOTTERY_ACTIVITY,
    CHASE_FRAME_SWITCH,
    WATCH_LPL_EXPIRED,
    VIDEO_CONNECTION_JOIN_START,
    VIDEO_CONNECTION_JOIN_END,
    VIDEO_CONNECTION_MSG,
    ROOM_BANNER,
    WIDGET_BANNER,
    ONLINE_RANK_V2,
    ONLINE_RANK_TOP3,
    HOT_RANK_CHANGED_V2,
    HOT_RANK_SETTLEMENT_V2,
    POPULAR_RANK_CHANGED,
    AREA_RANK_CHANGED,
    VTR_GIFT_LOTTERY,
    COMMON_NOTICE_DANMAKU,
    RED_POCKET_START,
    FULL_SCREEN_SPECIAL_EFFECT,
    POPULARITY_RED_POCKET_V2_START,
    POPULARITY_RED_POCKET_V2_WINNER_LIST,
    POPULARITY_RED_POCKET_V2_NEW,
    USER_PANEL_RED_ALARM,
    SHOPPING_CART_SHOW,
    Revenue_PayLimit,
    THERMAL_STORM_DANMU_BEGIN,
    THERMAL_STORM_DANMU_UPDATE,
    THERMAL_STORM_DANMU_CANCEL,
    THERMAL_STORM_DANMU_OVER,
    MILESTONE_UPDATE_EVENT,
    WEB_REPORT_CONTROL,
    RANK_REM,
    LIVE_PLAYER_LOG_RECYCLE,
    LIVE_INTERNAL_ROOM_LOGIN,
    LIVE_OPEN_PLATFORM_GAME,
    /**
     * 观看人数变化
     */
    WATCHED_CHANGE,
    USER_TITLE_GET,
    GUARD_BENEFIT_RECEIVE,
    GUARD_HONOR_THOUSAND,
    PLAY_TOGETHER,
    LIVE_OPEN_PLATFORM_CLOUD_GAME,
    DANMU_AGGREGATION,
    GIFT_STAR_PROCESS,
    WIDGET_GIFT_STAR_PROCESS,
    WIDGET_WISH_LIST,
    COLLECTION_PRAISE_STATUS,
    COLLECTION_PRAISE_UPDATE_PROCESS,
    USER_VIRTUAL_MVP,
    ROOM_SWITCH_INFO_CONFIG_CHANGE,
    LIKE_SO_HOT,
    /**
     * 点赞数更新
     */
    LIKE_INFO_V3_UPDATE,
    /**
     * 为主播点赞
     */
    LIKE_INFO_V3_CLICK,
    LIKE_GUIDE_USER,
    STARLIVE_PK_MSG,
    MULTI_VOICE_STATUS_SYNC,
    LIVE_PANEL_ICON_INFO,
    PLAYTOGETHER_SERVICE_CARD_CHANGE,
    OFFICIAL_ROOM_EVENT,
    MULTI_VOICE_PK_STATUS,
    MULTI_VOICE_OPERATIN,
    VOICE_CHAT_UPDATE,
    MULTI_VOICE_PK_HAT_STATUS,
    MULTI_VOICE_OWNER_LEAVE,
    MULTI_VOICE_SEND_EMOJI,
    WEALTH_NOTIFY,
    REDIRECT_EMPTY_PAGE,
    INTERACT_JOIN,
    INTERACT_OPERATION,
    MULTI_VOICE_APPLICATION,
    INTERACT_LEAVE,
    LPL_REALTIME_STATUS_CHANGED,
    SUPER_VIP_CONNECT_DIG,
    DM_INTERACTION,
    POPULAR_RANK_GUIDE_CARD,
    MULTI_CONN_BEHAVIOR,
    LIVE_INTERACT_GAME_STATE_CHANGE,
    GUARD_LEADER_NOTICE,
    PK_INFO,
    UNIVERSAL_EVENT_GIFT,

    SYS_MSG,
    SYS_GIFT,
    GUARD_MSG,
    END,
    CLOSE,
    BLOCK,
    ROUND,
    WELCOME,
    REFRESH,
    ACTIVITY_RED_PACKET,
    HOT_ROOM_NOTIFY,
    PLAY_TAG,
    PLAY_PROGRESS_BAR,
    // endregion

    // region 旧版CMD，可能已经无效
    /**
     * 有人上舰
     */
    GUARD_BUY,
    /**
     * 欢迎舰长
     */
    WELCOME_GUARD,
    HOT_RANK_CHANGED,
    LIVE_INTERACTIVE_GAME,
    /**
     * 高能榜数量更新
     */
    ONLINE_RANK_COUNT,
    PK_BATTLE_PROCESS,
    PK_BATTLE_SETTLE,
    PK_BATTLE_SETTLE_USER,
    PK_BATTLE_SETTLE_V2,
    /**
     * 停止直播的房间ID列表
     */
    STOP_LIVE_ROOM_LIST,
    SUPER_CHAT_MESSAGE_JPN,
    LIVE_MULTI_VIEW_CHANGE,
    RECOMMEND_CARD,
    PK_BATTLE_ENTRANCE,
    PK_BATTLE_START,
    PK_BATTLE_PRE,
    // endregion
    ;

    public static BilibiliCmdEnum getByString(String cmd) {
        try {
            return BilibiliCmdEnum.valueOf(cmd);
        } catch (Exception e) {
            return null;
        }
    }
}
