/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.listener.impl;

import cn.hutool.core.util.StrUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.nio.charset.StandardCharsets;
import tech.ordinaryroad.live.chat.client.bilibili.listener.IBilibiliMsgListener;
import tech.ordinaryroad.live.chat.client.bilibili.msg.BilibiliLiveStatusChangeMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.DanmuMsgMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.InteractWordMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.LikeInfoV3ClickMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.SendGiftMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.SendSmsReplyMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.SuperChatMessageMsg;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.msg.IMsg;
import tech.ordinaryroad.live.chat.client.websocket.client.WebSocketLiveChatClient;
import tech.ordinaryroad.live.chat.client.websocket.config.WebSocketLiveChatClientConfig;

public class BilibiliForwardMsgListener
implements IBilibiliMsgListener {
    private final WebSocketLiveChatClient webSocketLiveChatClient;

    public BilibiliForwardMsgListener(String webSocketUri) {
        if (StrUtil.isBlank((CharSequence)webSocketUri)) {
            throw new BaseException("\u8f6c\u53d1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.webSocketLiveChatClient = new WebSocketLiveChatClient(((WebSocketLiveChatClientConfig.WebSocketLiveChatClientConfigBuilder)WebSocketLiveChatClientConfig.builder().websocketUri(webSocketUri)).build());
        this.webSocketLiveChatClient.connect();
    }

    public void onDanmuMsg(DanmuMsgMsg msg) {
        this.forward(msg);
    }

    public void onGiftMsg(SendGiftMsg msg) {
        this.forward(msg);
    }

    public void onSuperChatMsg(SuperChatMessageMsg msg) {
        this.forward(msg);
    }

    public void onEnterRoomMsg(InteractWordMsg msg) {
        this.forward(msg);
    }

    public void onLikeMsg(LikeInfoV3ClickMsg msg) {
        this.forward(msg);
    }

    @Override
    public void onEntryEffect(SendSmsReplyMsg msg) {
        this.forward(msg);
    }

    @Override
    public void onWatchedChange(SendSmsReplyMsg msg) {
        this.forward(msg);
    }

    @Override
    public void onClickUpdate(SendSmsReplyMsg msg) {
        this.forward(msg);
    }

    public void onLiveStatusMsg(BilibiliLiveStatusChangeMsg msg) {
        this.forward(msg);
    }

    private void forward(IMsg msg) {
        if (this.webSocketLiveChatClient == null) {
            return;
        }
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
        byteBuf.writeCharSequence((CharSequence)msg.toString(), StandardCharsets.UTF_8);
        this.webSocketLiveChatClient.send((Object)new BinaryWebSocketFrame(byteBuf));
    }

    public void destroyForwardClient() {
        this.webSocketLiveChatClient.destroy();
    }
}

