/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.netty.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.api.BilibiliApis;
import tech.ordinaryroad.live.chat.client.bilibili.client.BilibiliLiveChatClient;
import tech.ordinaryroad.live.chat.client.bilibili.config.BilibiliLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.bilibili.constant.ProtoverEnum;
import tech.ordinaryroad.live.chat.client.bilibili.msg.factory.BilibiliMsgFactory;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientConnectionHandler;

@ChannelHandler.Sharable
public class BilibiliConnectionHandler
extends BaseNettyClientConnectionHandler<BilibiliLiveChatClient, BilibiliConnectionHandler> {
    private static final Logger log = LoggerFactory.getLogger(BilibiliConnectionHandler.class);
    private final long roomId;
    private final ProtoverEnum protover;
    private String cookie;
    private final BilibiliApis.RoomInitResult roomInitResult;

    public BilibiliConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, BilibiliLiveChatClient client, IBaseConnectionListener<BilibiliConnectionHandler> listener) {
        super(webSocketProtocolHandler, (BaseNettyClient)client, listener);
        this.roomInitResult = client.getRoomInitResult();
        this.roomId = ((BilibiliLiveChatClientConfig)client.getConfig()).getRoomId();
        this.protover = ((BilibiliLiveChatClientConfig)client.getConfig()).getProtover();
        this.cookie = ((BilibiliLiveChatClientConfig)client.getConfig()).getCookie();
    }

    public BilibiliConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, BilibiliLiveChatClient client) {
        this(webSocketProtocolHandler, client, null);
    }

    public BilibiliConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, BilibiliApis.RoomInitResult roomInitResult, long roomId, ProtoverEnum protover, IBaseConnectionListener<BilibiliConnectionHandler> listener, String cookie) {
        super(webSocketProtocolHandler, listener);
        this.roomInitResult = roomInitResult;
        this.roomId = roomId;
        this.protover = protover;
        this.cookie = cookie;
    }

    public BilibiliConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, BilibiliApis.RoomInitResult roomInitResult, long roomId, ProtoverEnum protover, IBaseConnectionListener<BilibiliConnectionHandler> listener) {
        this(webSocketProtocolHandler, roomInitResult, roomId, protover, listener, null);
    }

    public BilibiliConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, BilibiliApis.RoomInitResult roomInitResult, long roomId, ProtoverEnum protover, String cookie) {
        this(webSocketProtocolHandler, roomInitResult, roomId, protover, null, cookie);
    }

    public BilibiliConnectionHandler(Supplier<WebSocketClientProtocolHandler> webSocketProtocolHandler, BilibiliApis.RoomInitResult roomInitResult, long roomId, ProtoverEnum protover) {
        this(webSocketProtocolHandler, roomInitResult, roomId, protover, null, null);
    }

    public void sendHeartbeat(Channel channel) {
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u9001\u5fc3\u8df3\u5305");
        }
        channel.writeAndFlush((Object)BilibiliConnectionHandler.getWebSocketFrameFactory(this.getRoomId()).createHeartbeat(this.getProtover())).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5fc3\u8df3\u5305\u53d1\u9001\u5b8c\u6210");
                }
            } else {
                log.error("\u5fc3\u8df3\u5305\u53d1\u9001\u5931\u8d25", future.cause());
            }
        }));
    }

    private static BilibiliMsgFactory getWebSocketFrameFactory(long roomId) {
        return BilibiliMsgFactory.getInstance(roomId);
    }

    public void sendAuthRequest(Channel channel) {
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u9001\u8ba4\u8bc1\u5305");
        }
        channel.writeAndFlush((Object)BilibiliConnectionHandler.getWebSocketFrameFactory(this.getRoomId()).createAuth(this.getProtover(), this.roomInitResult)).addListener(future -> {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u8ba4\u8bc1\u5305\u53d1\u9001\u5b8c\u6210");
                }
            } else {
                log.error("\u8ba4\u8bc1\u5305\u53d1\u9001\u5931\u8d25", future.cause());
            }
        });
    }

    public long getRoomId() {
        return this.client != null ? ((BilibiliLiveChatClientConfig)((BilibiliLiveChatClient)this.client).getConfig()).getRoomId() : this.roomId;
    }

    private ProtoverEnum getProtover() {
        return this.client != null ? ((BilibiliLiveChatClientConfig)((BilibiliLiveChatClient)this.client).getConfig()).getProtover() : this.protover;
    }

    private String getCookie() {
        return this.client != null ? ((BilibiliLiveChatClientConfig)((BilibiliLiveChatClient)this.client).getConfig()).getCookie() : this.cookie;
    }
}

