/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.msg.factory;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.NumberUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import tech.ordinaryroad.live.chat.client.bilibili.api.BilibiliApis;
import tech.ordinaryroad.live.chat.client.bilibili.constant.ProtoverEnum;
import tech.ordinaryroad.live.chat.client.bilibili.msg.AuthMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.HeartbeatMsg;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;

public class BilibiliMsgFactory {
    private static final TimedCache<Long, BilibiliMsgFactory> FACTORY_CACHE = new TimedCache(TimeUnit.DAYS.toMillis(1L), new ConcurrentHashMap());
    private static final TimedCache<ProtoverEnum, HeartbeatMsg> HEARTBEAT_MSG_CACHE = new TimedCache(TimeUnit.DAYS.toMillis(1L), new ConcurrentHashMap());
    private final long roomId;

    public BilibiliMsgFactory(long roomId) {
        this.roomId = roomId;
    }

    public static BilibiliMsgFactory getInstance(long roomId) {
        if (!FACTORY_CACHE.containsKey((Object)roomId)) {
            FACTORY_CACHE.put((Object)roomId, (Object)new BilibiliMsgFactory(roomId));
        }
        return (BilibiliMsgFactory)FACTORY_CACHE.get((Object)roomId);
    }

    public AuthMsg createAuth(ProtoverEnum protover, BilibiliApis.RoomInitResult roomInitResult) {
        try {
            String buvid3 = roomInitResult.getBuvid3();
            long realRoomId = roomInitResult.getRoomPlayInfoResult().getRoom_id();
            AuthMsg authMsg = new AuthMsg(realRoomId, protover.getCode(), buvid3, roomInitResult.getDanmuinfoResult().getToken());
            authMsg.setUid(NumberUtil.parseLong((String)roomInitResult.getUid()));
            return authMsg;
        }
        catch (Exception e) {
            throw new BaseException(String.format("\u8ba4\u8bc1\u5305\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u623f\u95f4\u53f7\u662f\u5426\u6b63\u786e\u3002roomId: %d, msg: %s", this.roomId, e.getMessage()));
        }
    }

    public HeartbeatMsg createHeartbeat(ProtoverEnum protover) {
        if (!HEARTBEAT_MSG_CACHE.containsKey((Object)protover)) {
            HEARTBEAT_MSG_CACHE.put((Object)protover, (Object)new HeartbeatMsg(protover.getCode()));
        }
        return (HeartbeatMsg)HEARTBEAT_MSG_CACHE.get((Object)protover);
    }
}

