/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.msg;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import tech.ordinaryroad.live.chat.client.bilibili.constant.OperationEnum;
import tech.ordinaryroad.live.chat.client.bilibili.msg.base.BaseBilibiliCmdMsg;
import tech.ordinaryroad.live.chat.client.commons.base.constant.LiveStatusAction;
import tech.ordinaryroad.live.chat.client.commons.base.msg.ILiveStatusChangeMsg;

public class BilibiliLiveStatusChangeMsg
extends BaseBilibiliCmdMsg
implements ILiveStatusChangeMsg {
    private JsonNode data;

    @Override
    public OperationEnum getOperationEnum() {
        return OperationEnum.SEND_SMS_REPLY;
    }

    public LiveStatusAction getLiveStatusAction(Object roomId) {
        switch (this.getCmdEnum()) {
            case LIVE: {
                return LiveStatusAction.BEGIN;
            }
            case STOP_LIVE_ROOM_LIST: {
                ArrayNode roomIdList = (ArrayNode)this.data.withArray("room_id_list");
                for (JsonNode jsonNode : roomIdList) {
                    if (jsonNode.asLong() != NumberUtil.parseLong((String)StrUtil.toStringOrNull((Object)roomId))) continue;
                    return LiveStatusAction.END;
                }
                break;
            }
        }
        return null;
    }

    public JsonNode getData() {
        return this.data;
    }

    public void setData(JsonNode data) {
        this.data = data;
    }

    public BilibiliLiveStatusChangeMsg(JsonNode data) {
        this.data = data;
    }

    public BilibiliLiveStatusChangeMsg() {
    }
}

