/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.api;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.api.request.BilibiliLikeReportV3Request;
import tech.ordinaryroad.live.chat.client.bilibili.api.request.BilibiliSendMsgRequest;
import tech.ordinaryroad.live.chat.client.bilibili.config.BilibiliLiveStatusEnum;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.msg.BaseMsg;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatHttpUtil;

public class BilibiliApis {
    private static final Logger log = LoggerFactory.getLogger(BilibiliApis.class);
    public static final TimedCache<Long, String> GIFT_IMG_CACHE = new TimedCache(TimeUnit.DAYS.toMillis(1L));
    public static final String KEY_COOKIE_CSRF = "bili_jct";
    public static final String KEY_UID = "DedeUserID";
    public static final String PATTERN_REAL_ROOM_ID = "\\\"roomInitRes\\\".+\\{\\\"room_id\\\":(\\d+)";
    private static final String API_FRONTEND_FINGER_SPI = "https://api.bilibili.com/x/frontend/finger/spi";
    private static final String API_V = "https://data.bilibili.com/v/";
    private static final String API_WEB_INTERFACE_NAV = "https://api.bilibili.com/x/web-interface/nav";
    private static final String API_DANMU_INFO = "https://api.live.bilibili.com/xlive/web-room/v1/index/getDanmuInfo";
    private static final String API_ROOM_PLAY_INFO = "https://api.live.bilibili.com/xlive/web-room/v2/index/getRoomPlayInfo";

    public static RoomInitResult roomInit(long roomId, String cookie) {
        RoomPlayInfoResult roomPlayInfo = BilibiliApis.getRoomPlayInfo(roomId, cookie);
        long realRoomId = roomPlayInfo.room_id;
        String b_3 = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)"buvid3", BilibiliApis::v);
        DanmuinfoResult danmuInfo = BilibiliApis.getDanmuInfo(realRoomId, cookie);
        return new RoomInitResult.RoomInitResultBuilder().buvid3(b_3).uid(OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_UID, () -> "0")).danmuinfoResult(danmuInfo).roomPlayInfoResult(roomPlayInfo).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode roomGiftConfig(long roomId, String cookie) {
        HttpResponse response = OrLiveChatHttpUtil.createGet((String)("https://api.live.bilibili.com/xlive/web-room/v1/giftPanel/roomGiftConfig?platform=pc&source=live&build=0&global_version=0&room_id=" + roomId)).cookie(cookie).execute();
        try {
            JsonNode jsonNode = BilibiliApis.responseInterceptor(response.body());
            return jsonNode;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    public static JsonNode frontendFingerSpi() {
        JsonNode jsonNode;
        block6: {
            HttpResponse response = OrLiveChatHttpUtil.createGet((String)API_FRONTEND_FINGER_SPI).execute();
            try {
                jsonNode = BilibiliApis.responseInterceptor(response.body());
                if (Collections.singletonList(response).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(response).get(0) != null) {
                    response.close();
                }
                throw throwable;
            }
            response.close();
        }
        return jsonNode;
    }

    public static String v() {
        String string;
        block6: {
            HttpResponse response = OrLiveChatHttpUtil.createGet((String)API_V).execute();
            try {
                string = response.getCookieValue("buvid3");
                if (Collections.singletonList(response).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(response).get(0) != null) {
                    response.close();
                }
                throw throwable;
            }
            response.close();
        }
        return string;
    }

    public static void webInterfaceNav(String cookie) {
        HttpResponse response = OrLiveChatHttpUtil.createGet((String)API_WEB_INTERFACE_NAV).cookie(cookie).execute();
        if (Collections.singletonList(response).get(0) != null) {
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DanmuinfoResult getDanmuInfo(long roomId, int type, String cookie) {
        DanmuinfoResult danmuinfoResult;
        block6: {
            HttpResponse response = OrLiveChatHttpUtil.createGet((String)("https://api.live.bilibili.com/xlive/web-room/v1/index/getDanmuInfo?id=" + roomId + "&type=" + type)).cookie(cookie).execute();
            try {
                danmuinfoResult = (DanmuinfoResult)BaseMsg.OBJECT_MAPPER.readValue(BilibiliApis.responseInterceptor(response.body()).toString(), DanmuinfoResult.class);
                if (Collections.singletonList(response).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(response).get(0) != null) {
                    response.close();
                }
                throw throwable;
            }
            response.close();
        }
        return danmuinfoResult;
    }

    public static DanmuinfoResult getDanmuInfo(long roomId, String cookie) {
        return BilibiliApis.getDanmuInfo(roomId, 0, cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomPlayInfoResult getRoomPlayInfo(long roomId, int no_playurl, String cookie) {
        RoomPlayInfoResult roomPlayInfoResult;
        block6: {
            HttpResponse response = OrLiveChatHttpUtil.createGet((String)("https://api.live.bilibili.com/xlive/web-room/v2/index/getRoomPlayInfo?room_id=" + roomId + "&no_playurl=" + no_playurl + "&mask=1&qn=0&platform=web&protocol=0,1&format=0,1,2&codec=0,1,2&dolby=5&panorama=1")).cookie(cookie).execute();
            try {
                roomPlayInfoResult = (RoomPlayInfoResult)BaseMsg.OBJECT_MAPPER.readValue(BilibiliApis.responseInterceptor(response.body()).toString(), RoomPlayInfoResult.class);
                if (Collections.singletonList(response).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(response).get(0) != null) {
                    response.close();
                }
                throw throwable;
            }
            response.close();
        }
        return roomPlayInfoResult;
    }

    public static RoomPlayInfoResult getRoomPlayInfo(long roomId, String cookie) {
        return BilibiliApis.getRoomPlayInfo(roomId, 1, cookie);
    }

    public static String getGiftImgById(long giftId, long roomId) {
        if (!GIFT_IMG_CACHE.containsKey((Object)giftId)) {
            ThreadUtil.execAsync(() -> BilibiliApis.updateGiftImgCache(roomId, null));
        }
        return (String)GIFT_IMG_CACHE.get((Object)giftId);
    }

    public static void updateGiftImgCache(long roomId, String cookie) {
        JsonNode jsonNode = BilibiliApis.roomGiftConfig(roomId, cookie);
        for (JsonNode node : jsonNode.get("global_gift").get("list")) {
            long giftId = node.get("id").asLong();
            String giftImgUrl = node.get("webp").asText();
            GIFT_IMG_CACHE.put((Object)giftId, (Object)giftImgUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMsg(BilibiliSendMsgRequest request, String cookie) {
        if (StrUtil.isBlank((CharSequence)cookie)) {
            throw new BaseException("\u53d1\u9001\u5f39\u5e55\u63a5\u53e3cookie\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map stringObjectMap = BeanUtil.beanToMap((Object)request, (String[])new String[0]);
        HttpResponse execute = HttpUtil.createPost((String)"https://api.live.bilibili.com/msg/send").cookie(cookie).form(stringObjectMap).execute();
        try {
            BilibiliApis.responseInterceptor(execute.body());
        }
        finally {
            if (Collections.singletonList(execute).get(0) != null) {
                execute.close();
            }
        }
    }

    public static void sendMsg(String msg, long realRoomId, String cookie) {
        String biliJct = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_COOKIE_CSRF, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570bili_jct");
        });
        BilibiliSendMsgRequest request = new BilibiliSendMsgRequest(msg, StrUtil.toString((Object)ZonedDateTime.now(ZoneId.of("Asia/Shanghai")).toEpochSecond()), realRoomId, biliJct, biliJct);
        BilibiliApis.sendMsg(request, cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void likeReportV3(BilibiliLikeReportV3Request request, String cookie) {
        if (StrUtil.isBlank((CharSequence)cookie)) {
            throw new BaseException("\u4e3a\u4e3b\u64ad\u70b9\u8d5e\u63a5\u53e3cookie\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map stringObjectMap = BeanUtil.beanToMap((Object)request, (String[])new String[0]);
        HttpResponse execute = HttpUtil.createPost((String)"https://api.live.bilibili.com/xlive/app-ucenter/v1/like_info_v3/like/likeReportV3").cookie(cookie).form(stringObjectMap).execute();
        try {
            BilibiliApis.responseInterceptor(execute.body());
        }
        finally {
            if (Collections.singletonList(execute).get(0) != null) {
                execute.close();
            }
        }
    }

    public static void likeReportV3(long anchor_id, long realRoomId, String cookie) {
        String uid = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_UID, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570DedeUserID");
        });
        String biliJct = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_COOKIE_CSRF, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570bili_jct");
        });
        BilibiliLikeReportV3Request request = new BilibiliLikeReportV3Request(realRoomId, uid, anchor_id, biliJct, biliJct);
        BilibiliApis.likeReportV3(request, cookie);
    }

    private static JsonNode responseInterceptor(String responseString) {
        try {
            JsonNode jsonNode = BaseMsg.OBJECT_MAPPER.readTree(responseString);
            int code = jsonNode.get("code").asInt();
            if (code == 0) {
                return jsonNode.get("data");
            }
            throw new BaseException(jsonNode.get("message").asText());
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public static class RoomPlayInfoResult {
        private long room_id;
        private int short_id;
        private long uid;
        private boolean is_hidden;
        private boolean is_locked;
        private boolean is_portrait;
        private BilibiliLiveStatusEnum live_status;
        private int hidden_till;
        private int lock_till;
        private boolean encrypted;
        private boolean pwd_verified;
        private long live_time;
        private int room_shield;
        private List<Integer> all_special_types;
        private JsonNode playurl_info;
        private int official_type;
        private int official_room_id;
        private int risk_with_delay;

        public static RoomPlayInfoResultBuilder builder() {
            return new RoomPlayInfoResultBuilder();
        }

        public long getRoom_id() {
            return this.room_id;
        }

        public int getShort_id() {
            return this.short_id;
        }

        public long getUid() {
            return this.uid;
        }

        public boolean is_hidden() {
            return this.is_hidden;
        }

        public boolean is_locked() {
            return this.is_locked;
        }

        public boolean is_portrait() {
            return this.is_portrait;
        }

        public BilibiliLiveStatusEnum getLive_status() {
            return this.live_status;
        }

        public int getHidden_till() {
            return this.hidden_till;
        }

        public int getLock_till() {
            return this.lock_till;
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public boolean isPwd_verified() {
            return this.pwd_verified;
        }

        public long getLive_time() {
            return this.live_time;
        }

        public int getRoom_shield() {
            return this.room_shield;
        }

        public List<Integer> getAll_special_types() {
            return this.all_special_types;
        }

        public JsonNode getPlayurl_info() {
            return this.playurl_info;
        }

        public int getOfficial_type() {
            return this.official_type;
        }

        public int getOfficial_room_id() {
            return this.official_room_id;
        }

        public int getRisk_with_delay() {
            return this.risk_with_delay;
        }

        public void setRoom_id(long room_id) {
            this.room_id = room_id;
        }

        public void setShort_id(int short_id) {
            this.short_id = short_id;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public void set_hidden(boolean is_hidden) {
            this.is_hidden = is_hidden;
        }

        public void set_locked(boolean is_locked) {
            this.is_locked = is_locked;
        }

        public void set_portrait(boolean is_portrait) {
            this.is_portrait = is_portrait;
        }

        public void setLive_status(BilibiliLiveStatusEnum live_status) {
            this.live_status = live_status;
        }

        public void setHidden_till(int hidden_till) {
            this.hidden_till = hidden_till;
        }

        public void setLock_till(int lock_till) {
            this.lock_till = lock_till;
        }

        public void setEncrypted(boolean encrypted) {
            this.encrypted = encrypted;
        }

        public void setPwd_verified(boolean pwd_verified) {
            this.pwd_verified = pwd_verified;
        }

        public void setLive_time(long live_time) {
            this.live_time = live_time;
        }

        public void setRoom_shield(int room_shield) {
            this.room_shield = room_shield;
        }

        public void setAll_special_types(List<Integer> all_special_types) {
            this.all_special_types = all_special_types;
        }

        public void setPlayurl_info(JsonNode playurl_info) {
            this.playurl_info = playurl_info;
        }

        public void setOfficial_type(int official_type) {
            this.official_type = official_type;
        }

        public void setOfficial_room_id(int official_room_id) {
            this.official_room_id = official_room_id;
        }

        public void setRisk_with_delay(int risk_with_delay) {
            this.risk_with_delay = risk_with_delay;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoomPlayInfoResult)) {
                return false;
            }
            RoomPlayInfoResult other = (RoomPlayInfoResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRoom_id() != other.getRoom_id()) {
                return false;
            }
            if (this.getShort_id() != other.getShort_id()) {
                return false;
            }
            if (this.getUid() != other.getUid()) {
                return false;
            }
            if (this.is_hidden() != other.is_hidden()) {
                return false;
            }
            if (this.is_locked() != other.is_locked()) {
                return false;
            }
            if (this.is_portrait() != other.is_portrait()) {
                return false;
            }
            if (this.getHidden_till() != other.getHidden_till()) {
                return false;
            }
            if (this.getLock_till() != other.getLock_till()) {
                return false;
            }
            if (this.isEncrypted() != other.isEncrypted()) {
                return false;
            }
            if (this.isPwd_verified() != other.isPwd_verified()) {
                return false;
            }
            if (this.getLive_time() != other.getLive_time()) {
                return false;
            }
            if (this.getRoom_shield() != other.getRoom_shield()) {
                return false;
            }
            if (this.getOfficial_type() != other.getOfficial_type()) {
                return false;
            }
            if (this.getOfficial_room_id() != other.getOfficial_room_id()) {
                return false;
            }
            if (this.getRisk_with_delay() != other.getRisk_with_delay()) {
                return false;
            }
            BilibiliLiveStatusEnum this$live_status = this.getLive_status();
            BilibiliLiveStatusEnum other$live_status = other.getLive_status();
            if (this$live_status == null ? other$live_status != null : !((Object)((Object)this$live_status)).equals((Object)other$live_status)) {
                return false;
            }
            List<Integer> this$all_special_types = this.getAll_special_types();
            List<Integer> other$all_special_types = other.getAll_special_types();
            if (this$all_special_types == null ? other$all_special_types != null : !((Object)this$all_special_types).equals(other$all_special_types)) {
                return false;
            }
            JsonNode this$playurl_info = this.getPlayurl_info();
            JsonNode other$playurl_info = other.getPlayurl_info();
            return !(this$playurl_info == null ? other$playurl_info != null : !this$playurl_info.equals(other$playurl_info));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoomPlayInfoResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $room_id = this.getRoom_id();
            result = result * 59 + (int)($room_id >>> 32 ^ $room_id);
            result = result * 59 + this.getShort_id();
            long $uid = this.getUid();
            result = result * 59 + (int)($uid >>> 32 ^ $uid);
            result = result * 59 + (this.is_hidden() ? 79 : 97);
            result = result * 59 + (this.is_locked() ? 79 : 97);
            result = result * 59 + (this.is_portrait() ? 79 : 97);
            result = result * 59 + this.getHidden_till();
            result = result * 59 + this.getLock_till();
            result = result * 59 + (this.isEncrypted() ? 79 : 97);
            result = result * 59 + (this.isPwd_verified() ? 79 : 97);
            long $live_time = this.getLive_time();
            result = result * 59 + (int)($live_time >>> 32 ^ $live_time);
            result = result * 59 + this.getRoom_shield();
            result = result * 59 + this.getOfficial_type();
            result = result * 59 + this.getOfficial_room_id();
            result = result * 59 + this.getRisk_with_delay();
            BilibiliLiveStatusEnum $live_status = this.getLive_status();
            result = result * 59 + ($live_status == null ? 43 : ((Object)((Object)$live_status)).hashCode());
            List<Integer> $all_special_types = this.getAll_special_types();
            result = result * 59 + ($all_special_types == null ? 43 : ((Object)$all_special_types).hashCode());
            JsonNode $playurl_info = this.getPlayurl_info();
            result = result * 59 + ($playurl_info == null ? 43 : $playurl_info.hashCode());
            return result;
        }

        public String toString() {
            return "BilibiliApis.RoomPlayInfoResult(room_id=" + this.getRoom_id() + ", short_id=" + this.getShort_id() + ", uid=" + this.getUid() + ", is_hidden=" + this.is_hidden() + ", is_locked=" + this.is_locked() + ", is_portrait=" + this.is_portrait() + ", live_status=" + (Object)((Object)this.getLive_status()) + ", hidden_till=" + this.getHidden_till() + ", lock_till=" + this.getLock_till() + ", encrypted=" + this.isEncrypted() + ", pwd_verified=" + this.isPwd_verified() + ", live_time=" + this.getLive_time() + ", room_shield=" + this.getRoom_shield() + ", all_special_types=" + this.getAll_special_types() + ", playurl_info=" + this.getPlayurl_info() + ", official_type=" + this.getOfficial_type() + ", official_room_id=" + this.getOfficial_room_id() + ", risk_with_delay=" + this.getRisk_with_delay() + ")";
        }

        public RoomPlayInfoResult(long room_id, int short_id, long uid, boolean is_hidden, boolean is_locked, boolean is_portrait, BilibiliLiveStatusEnum live_status, int hidden_till, int lock_till, boolean encrypted, boolean pwd_verified, long live_time, int room_shield, List<Integer> all_special_types, JsonNode playurl_info, int official_type, int official_room_id, int risk_with_delay) {
            this.room_id = room_id;
            this.short_id = short_id;
            this.uid = uid;
            this.is_hidden = is_hidden;
            this.is_locked = is_locked;
            this.is_portrait = is_portrait;
            this.live_status = live_status;
            this.hidden_till = hidden_till;
            this.lock_till = lock_till;
            this.encrypted = encrypted;
            this.pwd_verified = pwd_verified;
            this.live_time = live_time;
            this.room_shield = room_shield;
            this.all_special_types = all_special_types;
            this.playurl_info = playurl_info;
            this.official_type = official_type;
            this.official_room_id = official_room_id;
            this.risk_with_delay = risk_with_delay;
        }

        public RoomPlayInfoResult() {
        }

        public static class RoomPlayInfoResultBuilder {
            private long room_id;
            private int short_id;
            private long uid;
            private boolean is_hidden;
            private boolean is_locked;
            private boolean is_portrait;
            private BilibiliLiveStatusEnum live_status;
            private int hidden_till;
            private int lock_till;
            private boolean encrypted;
            private boolean pwd_verified;
            private long live_time;
            private int room_shield;
            private List<Integer> all_special_types;
            private JsonNode playurl_info;
            private int official_type;
            private int official_room_id;
            private int risk_with_delay;

            RoomPlayInfoResultBuilder() {
            }

            public RoomPlayInfoResultBuilder room_id(long room_id) {
                this.room_id = room_id;
                return this;
            }

            public RoomPlayInfoResultBuilder short_id(int short_id) {
                this.short_id = short_id;
                return this;
            }

            public RoomPlayInfoResultBuilder uid(long uid) {
                this.uid = uid;
                return this;
            }

            public RoomPlayInfoResultBuilder is_hidden(boolean is_hidden) {
                this.is_hidden = is_hidden;
                return this;
            }

            public RoomPlayInfoResultBuilder is_locked(boolean is_locked) {
                this.is_locked = is_locked;
                return this;
            }

            public RoomPlayInfoResultBuilder is_portrait(boolean is_portrait) {
                this.is_portrait = is_portrait;
                return this;
            }

            public RoomPlayInfoResultBuilder live_status(BilibiliLiveStatusEnum live_status) {
                this.live_status = live_status;
                return this;
            }

            public RoomPlayInfoResultBuilder hidden_till(int hidden_till) {
                this.hidden_till = hidden_till;
                return this;
            }

            public RoomPlayInfoResultBuilder lock_till(int lock_till) {
                this.lock_till = lock_till;
                return this;
            }

            public RoomPlayInfoResultBuilder encrypted(boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public RoomPlayInfoResultBuilder pwd_verified(boolean pwd_verified) {
                this.pwd_verified = pwd_verified;
                return this;
            }

            public RoomPlayInfoResultBuilder live_time(long live_time) {
                this.live_time = live_time;
                return this;
            }

            public RoomPlayInfoResultBuilder room_shield(int room_shield) {
                this.room_shield = room_shield;
                return this;
            }

            public RoomPlayInfoResultBuilder all_special_types(List<Integer> all_special_types) {
                this.all_special_types = all_special_types;
                return this;
            }

            public RoomPlayInfoResultBuilder playurl_info(JsonNode playurl_info) {
                this.playurl_info = playurl_info;
                return this;
            }

            public RoomPlayInfoResultBuilder official_type(int official_type) {
                this.official_type = official_type;
                return this;
            }

            public RoomPlayInfoResultBuilder official_room_id(int official_room_id) {
                this.official_room_id = official_room_id;
                return this;
            }

            public RoomPlayInfoResultBuilder risk_with_delay(int risk_with_delay) {
                this.risk_with_delay = risk_with_delay;
                return this;
            }

            public RoomPlayInfoResult build() {
                return new RoomPlayInfoResult(this.room_id, this.short_id, this.uid, this.is_hidden, this.is_locked, this.is_portrait, this.live_status, this.hidden_till, this.lock_till, this.encrypted, this.pwd_verified, this.live_time, this.room_shield, this.all_special_types, this.playurl_info, this.official_type, this.official_room_id, this.risk_with_delay);
            }

            public String toString() {
                return "BilibiliApis.RoomPlayInfoResult.RoomPlayInfoResultBuilder(room_id=" + this.room_id + ", short_id=" + this.short_id + ", uid=" + this.uid + ", is_hidden=" + this.is_hidden + ", is_locked=" + this.is_locked + ", is_portrait=" + this.is_portrait + ", live_status=" + (Object)((Object)this.live_status) + ", hidden_till=" + this.hidden_till + ", lock_till=" + this.lock_till + ", encrypted=" + this.encrypted + ", pwd_verified=" + this.pwd_verified + ", live_time=" + this.live_time + ", room_shield=" + this.room_shield + ", all_special_types=" + this.all_special_types + ", playurl_info=" + this.playurl_info + ", official_type=" + this.official_type + ", official_room_id=" + this.official_room_id + ", risk_with_delay=" + this.risk_with_delay + ")";
            }
        }
    }

    public static class DanmuinfoResult {
        private String group;
        private int business_id;
        private double refresh_row_factor;
        private int refresh_rate;
        private int max_delay;
        private String token;
        private List<Host_list> host_list;

        public static DanmuinfoResultBuilder builder() {
            return new DanmuinfoResultBuilder();
        }

        public String getGroup() {
            return this.group;
        }

        public int getBusiness_id() {
            return this.business_id;
        }

        public double getRefresh_row_factor() {
            return this.refresh_row_factor;
        }

        public int getRefresh_rate() {
            return this.refresh_rate;
        }

        public int getMax_delay() {
            return this.max_delay;
        }

        public String getToken() {
            return this.token;
        }

        public List<Host_list> getHost_list() {
            return this.host_list;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setBusiness_id(int business_id) {
            this.business_id = business_id;
        }

        public void setRefresh_row_factor(double refresh_row_factor) {
            this.refresh_row_factor = refresh_row_factor;
        }

        public void setRefresh_rate(int refresh_rate) {
            this.refresh_rate = refresh_rate;
        }

        public void setMax_delay(int max_delay) {
            this.max_delay = max_delay;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setHost_list(List<Host_list> host_list) {
            this.host_list = host_list;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DanmuinfoResult)) {
                return false;
            }
            DanmuinfoResult other = (DanmuinfoResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBusiness_id() != other.getBusiness_id()) {
                return false;
            }
            if (Double.compare(this.getRefresh_row_factor(), other.getRefresh_row_factor()) != 0) {
                return false;
            }
            if (this.getRefresh_rate() != other.getRefresh_rate()) {
                return false;
            }
            if (this.getMax_delay() != other.getMax_delay()) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            List<Host_list> this$host_list = this.getHost_list();
            List<Host_list> other$host_list = other.getHost_list();
            return !(this$host_list == null ? other$host_list != null : !((Object)this$host_list).equals(other$host_list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DanmuinfoResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBusiness_id();
            long $refresh_row_factor = Double.doubleToLongBits(this.getRefresh_row_factor());
            result = result * 59 + (int)($refresh_row_factor >>> 32 ^ $refresh_row_factor);
            result = result * 59 + this.getRefresh_rate();
            result = result * 59 + this.getMax_delay();
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            List<Host_list> $host_list = this.getHost_list();
            result = result * 59 + ($host_list == null ? 43 : ((Object)$host_list).hashCode());
            return result;
        }

        public String toString() {
            return "BilibiliApis.DanmuinfoResult(group=" + this.getGroup() + ", business_id=" + this.getBusiness_id() + ", refresh_row_factor=" + this.getRefresh_row_factor() + ", refresh_rate=" + this.getRefresh_rate() + ", max_delay=" + this.getMax_delay() + ", token=" + this.getToken() + ", host_list=" + this.getHost_list() + ")";
        }

        public DanmuinfoResult(String group, int business_id, double refresh_row_factor, int refresh_rate, int max_delay, String token, List<Host_list> host_list) {
            this.group = group;
            this.business_id = business_id;
            this.refresh_row_factor = refresh_row_factor;
            this.refresh_rate = refresh_rate;
            this.max_delay = max_delay;
            this.token = token;
            this.host_list = host_list;
        }

        public DanmuinfoResult() {
        }

        public static class DanmuinfoResultBuilder {
            private String group;
            private int business_id;
            private double refresh_row_factor;
            private int refresh_rate;
            private int max_delay;
            private String token;
            private List<Host_list> host_list;

            DanmuinfoResultBuilder() {
            }

            public DanmuinfoResultBuilder group(String group) {
                this.group = group;
                return this;
            }

            public DanmuinfoResultBuilder business_id(int business_id) {
                this.business_id = business_id;
                return this;
            }

            public DanmuinfoResultBuilder refresh_row_factor(double refresh_row_factor) {
                this.refresh_row_factor = refresh_row_factor;
                return this;
            }

            public DanmuinfoResultBuilder refresh_rate(int refresh_rate) {
                this.refresh_rate = refresh_rate;
                return this;
            }

            public DanmuinfoResultBuilder max_delay(int max_delay) {
                this.max_delay = max_delay;
                return this;
            }

            public DanmuinfoResultBuilder token(String token) {
                this.token = token;
                return this;
            }

            public DanmuinfoResultBuilder host_list(List<Host_list> host_list) {
                this.host_list = host_list;
                return this;
            }

            public DanmuinfoResult build() {
                return new DanmuinfoResult(this.group, this.business_id, this.refresh_row_factor, this.refresh_rate, this.max_delay, this.token, this.host_list);
            }

            public String toString() {
                return "BilibiliApis.DanmuinfoResult.DanmuinfoResultBuilder(group=" + this.group + ", business_id=" + this.business_id + ", refresh_row_factor=" + this.refresh_row_factor + ", refresh_rate=" + this.refresh_rate + ", max_delay=" + this.max_delay + ", token=" + this.token + ", host_list=" + this.host_list + ")";
            }
        }
    }

    public static class RoomInitResult {
        private String buvid3;
        private String uid;
        private DanmuinfoResult danmuinfoResult = new DanmuinfoResult();
        private RoomPlayInfoResult roomPlayInfoResult = new RoomPlayInfoResult();

        public static RoomInitResultBuilder builder() {
            return new RoomInitResultBuilder();
        }

        public String getBuvid3() {
            return this.buvid3;
        }

        public String getUid() {
            return this.uid;
        }

        public DanmuinfoResult getDanmuinfoResult() {
            return this.danmuinfoResult;
        }

        public RoomPlayInfoResult getRoomPlayInfoResult() {
            return this.roomPlayInfoResult;
        }

        public void setBuvid3(String buvid3) {
            this.buvid3 = buvid3;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public void setDanmuinfoResult(DanmuinfoResult danmuinfoResult) {
            this.danmuinfoResult = danmuinfoResult;
        }

        public void setRoomPlayInfoResult(RoomPlayInfoResult roomPlayInfoResult) {
            this.roomPlayInfoResult = roomPlayInfoResult;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoomInitResult)) {
                return false;
            }
            RoomInitResult other = (RoomInitResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$buvid3 = this.getBuvid3();
            String other$buvid3 = other.getBuvid3();
            if (this$buvid3 == null ? other$buvid3 != null : !this$buvid3.equals(other$buvid3)) {
                return false;
            }
            String this$uid = this.getUid();
            String other$uid = other.getUid();
            if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
                return false;
            }
            DanmuinfoResult this$danmuinfoResult = this.getDanmuinfoResult();
            DanmuinfoResult other$danmuinfoResult = other.getDanmuinfoResult();
            if (this$danmuinfoResult == null ? other$danmuinfoResult != null : !((Object)this$danmuinfoResult).equals(other$danmuinfoResult)) {
                return false;
            }
            RoomPlayInfoResult this$roomPlayInfoResult = this.getRoomPlayInfoResult();
            RoomPlayInfoResult other$roomPlayInfoResult = other.getRoomPlayInfoResult();
            return !(this$roomPlayInfoResult == null ? other$roomPlayInfoResult != null : !((Object)this$roomPlayInfoResult).equals(other$roomPlayInfoResult));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoomInitResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $buvid3 = this.getBuvid3();
            result = result * 59 + ($buvid3 == null ? 43 : $buvid3.hashCode());
            String $uid = this.getUid();
            result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
            DanmuinfoResult $danmuinfoResult = this.getDanmuinfoResult();
            result = result * 59 + ($danmuinfoResult == null ? 43 : ((Object)$danmuinfoResult).hashCode());
            RoomPlayInfoResult $roomPlayInfoResult = this.getRoomPlayInfoResult();
            result = result * 59 + ($roomPlayInfoResult == null ? 43 : ((Object)$roomPlayInfoResult).hashCode());
            return result;
        }

        public String toString() {
            return "BilibiliApis.RoomInitResult(buvid3=" + this.getBuvid3() + ", uid=" + this.getUid() + ", danmuinfoResult=" + this.getDanmuinfoResult() + ", roomPlayInfoResult=" + this.getRoomPlayInfoResult() + ")";
        }

        public RoomInitResult(String buvid3, String uid, DanmuinfoResult danmuinfoResult, RoomPlayInfoResult roomPlayInfoResult) {
            this.buvid3 = buvid3;
            this.uid = uid;
            this.danmuinfoResult = danmuinfoResult;
            this.roomPlayInfoResult = roomPlayInfoResult;
        }

        public RoomInitResult() {
        }

        public static class RoomInitResultBuilder {
            private String buvid3;
            private String uid;
            private DanmuinfoResult danmuinfoResult;
            private RoomPlayInfoResult roomPlayInfoResult;

            RoomInitResultBuilder() {
            }

            public RoomInitResultBuilder buvid3(String buvid3) {
                this.buvid3 = buvid3;
                return this;
            }

            public RoomInitResultBuilder uid(String uid) {
                this.uid = uid;
                return this;
            }

            public RoomInitResultBuilder danmuinfoResult(DanmuinfoResult danmuinfoResult) {
                this.danmuinfoResult = danmuinfoResult;
                return this;
            }

            public RoomInitResultBuilder roomPlayInfoResult(RoomPlayInfoResult roomPlayInfoResult) {
                this.roomPlayInfoResult = roomPlayInfoResult;
                return this;
            }

            public RoomInitResult build() {
                return new RoomInitResult(this.buvid3, this.uid, this.danmuinfoResult, this.roomPlayInfoResult);
            }

            public String toString() {
                return "BilibiliApis.RoomInitResult.RoomInitResultBuilder(buvid3=" + this.buvid3 + ", uid=" + this.uid + ", danmuinfoResult=" + this.danmuinfoResult + ", roomPlayInfoResult=" + this.roomPlayInfoResult + ")";
            }
        }
    }

    public static class Host_list {
        private String host;
        private int port;
        private int wss_port;
        private int ws_port;

        public static Host_listBuilder builder() {
            return new Host_listBuilder();
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public int getWss_port() {
            return this.wss_port;
        }

        public int getWs_port() {
            return this.ws_port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setWss_port(int wss_port) {
            this.wss_port = wss_port;
        }

        public void setWs_port(int ws_port) {
            this.ws_port = ws_port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Host_list)) {
                return false;
            }
            Host_list other = (Host_list)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getWss_port() != other.getWss_port()) {
                return false;
            }
            if (this.getWs_port() != other.getWs_port()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Host_list;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            result = result * 59 + this.getWss_port();
            result = result * 59 + this.getWs_port();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "BilibiliApis.Host_list(host=" + this.getHost() + ", port=" + this.getPort() + ", wss_port=" + this.getWss_port() + ", ws_port=" + this.getWs_port() + ")";
        }

        public Host_list(String host, int port, int wss_port, int ws_port) {
            this.host = host;
            this.port = port;
            this.wss_port = wss_port;
            this.ws_port = ws_port;
        }

        public Host_list() {
        }

        public static class Host_listBuilder {
            private String host;
            private int port;
            private int wss_port;
            private int ws_port;

            Host_listBuilder() {
            }

            public Host_listBuilder host(String host) {
                this.host = host;
                return this;
            }

            public Host_listBuilder port(int port) {
                this.port = port;
                return this;
            }

            public Host_listBuilder wss_port(int wss_port) {
                this.wss_port = wss_port;
                return this;
            }

            public Host_listBuilder ws_port(int ws_port) {
                this.ws_port = ws_port;
                return this;
            }

            public Host_list build() {
                return new Host_list(this.host, this.port, this.wss_port, this.ws_port);
            }

            public String toString() {
                return "BilibiliApis.Host_list.Host_listBuilder(host=" + this.host + ", port=" + this.port + ", wss_port=" + this.wss_port + ", ws_port=" + this.ws_port + ")";
            }
        }
    }
}

