/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.util;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.decoder.BrotliInputStream;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.constant.OperationEnum;
import tech.ordinaryroad.live.chat.client.bilibili.constant.ProtoverEnum;
import tech.ordinaryroad.live.chat.client.bilibili.msg.AuthReplyMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.HeartbeatMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.HeartbeatReplyMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.SendSmsReplyMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.base.BaseBilibiliMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.base.IBilibiliMsg;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;

public class BilibiliCodecUtil {
    private static final Logger log = LoggerFactory.getLogger(BilibiliCodecUtil.class);
    public static int sequence = 0;
    public static final short FRAME_HEADER_LENGTH = 16;

    public static ByteBuf encode(BaseBilibiliMsg msg) {
        ByteBuf out = Unpooled.buffer((int)16);
        String bodyJsonString = "";
        if (!(msg instanceof HeartbeatMsg) && "{}".equals(bodyJsonString = msg.toString())) {
            bodyJsonString = "";
        }
        byte[] bodyBytes = bodyJsonString.getBytes(StandardCharsets.UTF_8);
        int length = bodyBytes.length + 16;
        out.writeInt(length);
        out.writeShort(16);
        out.writeShort(msg.getProtoverEnum().getCode());
        out.writeInt(msg.getOperationEnum().getCode());
        out.writeInt(++sequence);
        out.writeBytes(bodyBytes);
        return out;
    }

    public static List<IBilibiliMsg> decode(ByteBuf in) {
        ArrayList<IBilibiliMsg> msgList = new ArrayList<IBilibiliMsg>();
        LinkedList<ByteBuf> pendingByteBuf = new LinkedList<ByteBuf>();
        do {
            Optional<IBilibiliMsg> msg = BilibiliCodecUtil.doDecode(in, pendingByteBuf);
            msg.ifPresent(msgList::add);
        } while ((in = (ByteBuf)pendingByteBuf.poll()) != null);
        return msgList;
    }

    private static Optional<IBilibiliMsg> doDecode(ByteBuf in, Queue<ByteBuf> pendingByteBuf) {
        short protoverCode;
        block34: {
            OperationEnum operationEnum;
            int length = in.readInt();
            short frameHeaderLength = in.readShort();
            protoverCode = in.readShort();
            int operationCode = in.readInt();
            int sequence = in.readInt();
            int contentLength = length - frameHeaderLength;
            byte[] inputBytes = new byte[contentLength];
            in.readBytes(inputBytes);
            if (in.readableBytes() != 0) {
                pendingByteBuf.offer(in);
            }
            if ((operationEnum = OperationEnum.getByCode(operationCode)) == null) {
                throw new BaseException(String.format("\u672a\u77e5operation: %d", operationCode));
            }
            if (protoverCode == ProtoverEnum.NORMAL_ZLIB.getCode()) {
                switch (operationEnum) {
                    case SEND_SMS_REPLY: {
                        Inflater inflater = new Inflater();
                        inflater.reset();
                        inflater.setInput(inputBytes);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(contentLength);
                        try {
                            byte[] bytes = new byte[1024];
                            while (!inflater.finished()) {
                                int count = inflater.inflate(bytes);
                                byteArrayOutputStream.write(bytes, 0, count);
                            }
                        }
                        catch (DataFormatException e) {
                            throw new BaseException((Throwable)e);
                        }
                        inflater.end();
                        return BilibiliCodecUtil.doDecode(Unpooled.wrappedBuffer((byte[])byteArrayOutputStream.toByteArray()), pendingByteBuf);
                    }
                    case HEARTBEAT_REPLY: {
                        BigInteger bigInteger = new BigInteger(inputBytes);
                        return BilibiliCodecUtil.parse(operationEnum, String.format("{\"popularity\":%d}", bigInteger));
                    }
                }
                String s = new String(inputBytes, StandardCharsets.UTF_8);
                return BilibiliCodecUtil.parse(operationEnum, s);
            }
            if (protoverCode == ProtoverEnum.NORMAL_NO_COMPRESSION.getCode()) {
                switch (operationEnum) {
                    case HEARTBEAT_REPLY: {
                        BigInteger bigInteger = new BigInteger(inputBytes);
                        return BilibiliCodecUtil.parse(operationEnum, String.format("{\"popularity\":%d}", bigInteger));
                    }
                }
                String s = new String(inputBytes, StandardCharsets.UTF_8);
                return BilibiliCodecUtil.parse(operationEnum, s);
            }
            if (protoverCode == ProtoverEnum.HEARTBEAT_AUTH_NO_COMPRESSION.getCode()) {
                switch (operationEnum) {
                    case HEARTBEAT_REPLY: {
                        BigInteger bigInteger = new BigInteger(inputBytes);
                        return BilibiliCodecUtil.parse(operationEnum, String.format("{\"popularity\":%d}", bigInteger));
                    }
                }
                String s = new String(inputBytes, StandardCharsets.UTF_8);
                return BilibiliCodecUtil.parse(operationEnum, s);
            }
            if (protoverCode != ProtoverEnum.NORMAL_BROTLI.getCode()) break block34;
            switch (operationEnum) {
                case SEND_SMS_REPLY: {
                    Brotli4jLoader.ensureAvailability();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputBytes);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(contentLength);
                    byte[] bytes = new byte[1024];
                    BrotliInputStream brotliInputStream = null;
                    ByteBuf wrappedBuffer = null;
                    try {
                        int count;
                        brotliInputStream = new BrotliInputStream((InputStream)byteArrayInputStream);
                        while ((count = brotliInputStream.read(bytes)) > -1) {
                            byteArrayOutputStream.write(bytes, 0, count);
                        }
                        wrappedBuffer = Unpooled.wrappedBuffer((byte[])byteArrayOutputStream.toByteArray());
                    }
                    catch (IOException e) {
                        throw new BaseException((Throwable)e);
                    }
                    finally {
                        try {
                            if (brotliInputStream != null) {
                                brotliInputStream.close();
                            }
                            byteArrayOutputStream.close();
                        }
                        catch (IOException e) {
                            log.error("\u89e3\u538b\u5931\u8d25", (Throwable)e);
                        }
                    }
                    return BilibiliCodecUtil.doDecode(wrappedBuffer, pendingByteBuf);
                }
                case HEARTBEAT_REPLY: {
                    BigInteger bigInteger = new BigInteger(inputBytes);
                    return BilibiliCodecUtil.parse(operationEnum, String.format("{\"popularity\":%d}", bigInteger));
                }
            }
            String s = new String(inputBytes, StandardCharsets.UTF_8);
            return BilibiliCodecUtil.parse(operationEnum, s);
        }
        if (log.isWarnEnabled()) {
            log.warn("\u6682\u4e0d\u652f\u6301\u7684\u7248\u672c\uff1a{}", (Object)protoverCode);
        }
        return Optional.empty();
    }

    public static Optional<IBilibiliMsg> parse(OperationEnum operation, String jsonString) {
        switch (operation) {
            case SEND_SMS_REPLY: {
                try {
                    return Optional.ofNullable((IBilibiliMsg)BaseBilibiliMsg.OBJECT_MAPPER.readValue(jsonString, SendSmsReplyMsg.class));
                }
                catch (JsonProcessingException e) {
                    throw new BaseException((Throwable)e);
                }
            }
            case AUTH_REPLY: {
                try {
                    return Optional.ofNullable((IBilibiliMsg)BaseBilibiliMsg.OBJECT_MAPPER.readValue(jsonString, AuthReplyMsg.class));
                }
                catch (JsonProcessingException e) {
                    throw new BaseException((Throwable)e);
                }
            }
            case HEARTBEAT_REPLY: {
                try {
                    return Optional.ofNullable((IBilibiliMsg)BaseBilibiliMsg.OBJECT_MAPPER.readValue(jsonString, HeartbeatReplyMsg.class));
                }
                catch (JsonProcessingException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u6682\u4e0d\u652f\u6301 {}", (Object)operation);
        }
        return Optional.empty();
    }
}

