/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.netty.frame.factory;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.NumberUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tech.ordinaryroad.live.chat.client.bilibili.api.BilibiliApis;
import tech.ordinaryroad.live.chat.client.bilibili.constant.ProtoverEnum;
import tech.ordinaryroad.live.chat.client.bilibili.msg.AuthMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.HeartbeatMsg;
import tech.ordinaryroad.live.chat.client.bilibili.netty.frame.AuthWebSocketFrame;
import tech.ordinaryroad.live.chat.client.bilibili.netty.frame.HeartbeatWebSocketFrame;
import tech.ordinaryroad.live.chat.client.bilibili.util.BilibiliCodecUtil;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;

public class BilibiliWebSocketFrameFactory {
    private static final ConcurrentHashMap<Long, BilibiliWebSocketFrameFactory> CACHE = new ConcurrentHashMap();
    private final long roomId;
    private static volatile HeartbeatMsg heartbeatMsg;

    public BilibiliWebSocketFrameFactory(long roomId) {
        this.roomId = roomId;
    }

    public static synchronized BilibiliWebSocketFrameFactory getInstance(long roomId) {
        return CACHE.computeIfAbsent(roomId, aLong -> new BilibiliWebSocketFrameFactory(roomId));
    }

    public AuthWebSocketFrame createAuth(ProtoverEnum protover, String cookie) {
        try {
            Map cookieMap = OrLiveChatCookieUtil.parseCookieString((String)cookie);
            String buvid3 = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)"buvid3", () -> UUID.randomUUID().toString());
            String uid = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)"DedeUserID", () -> "0");
            BilibiliApis.RoomInitResult data = BilibiliApis.roomInit(this.roomId, cookie);
            JsonNode danmuInfo = BilibiliApis.getDanmuInfo(this.roomId, 0, cookie);
            long realRoomId = data.getRoom_id();
            AuthMsg authMsg = new AuthMsg(realRoomId, protover.getCode(), buvid3, danmuInfo.get("token").asText());
            authMsg.setUid(NumberUtil.parseLong((String)uid));
            return new AuthWebSocketFrame(BilibiliCodecUtil.encode(authMsg));
        }
        catch (Exception e) {
            throw new BaseException(String.format("\u8ba4\u8bc1\u5305\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u623f\u95f4\u53f7\u662f\u5426\u6b63\u786e\u3002roomId: %d, msg: %s", this.roomId, e.getMessage()));
        }
    }

    public AuthWebSocketFrame createAuth(ProtoverEnum protover) {
        return this.createAuth(protover, null);
    }

    public HeartbeatWebSocketFrame createHeartbeat(ProtoverEnum protover) {
        return new HeartbeatWebSocketFrame(BilibiliCodecUtil.encode(this.getHeartbeatMsg(protover)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeartbeatMsg getHeartbeatMsg(ProtoverEnum protover) {
        if (heartbeatMsg == null) {
            BilibiliWebSocketFrameFactory bilibiliWebSocketFrameFactory = this;
            synchronized (bilibiliWebSocketFrameFactory) {
                if (heartbeatMsg == null) {
                    heartbeatMsg = new HeartbeatMsg(protover.getCode());
                }
            }
        }
        return heartbeatMsg;
    }
}

