/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.api;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.api.request.BilibiliLikeReportV3Request;
import tech.ordinaryroad.live.chat.client.bilibili.api.request.BilibiliSendMsgRequest;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.msg.BaseMsg;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;

public class BilibiliApis {
    private static final Logger log = LoggerFactory.getLogger(BilibiliApis.class);
    public static final TimedCache<Long, String> GIFT_IMG_CACHE = new TimedCache(TimeUnit.DAYS.toMillis(1L));
    public static final String KEY_COOKIE_CSRF = "bili_jct";
    public static final String KEY_UID = "DedeUserID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomInitResult roomInit(long roomId, String cookie) {
        RoomInitResult roomInitResult;
        block6: {
            HttpResponse response = BilibiliApis.createGetRequest("https://api.live.bilibili.com/room/v1/Room/room_init?id=" + roomId, cookie).execute();
            try {
                JsonNode dataJsonNode = BilibiliApis.responseInterceptor(response.body());
                roomInitResult = (RoomInitResult)BaseMsg.OBJECT_MAPPER.readValue(dataJsonNode.toString(), RoomInitResult.class);
                if (Collections.singletonList(response).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(response).get(0) != null) {
                    response.close();
                }
                throw throwable;
            }
            response.close();
        }
        return roomInitResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode roomGiftConfig(long roomId, String cookie) {
        HttpResponse response = BilibiliApis.createGetRequest("https://api.live.bilibili.com/xlive/web-room/v1/giftPanel/roomGiftConfig?platform=pc&source=live&build=0&global_version=0&room_id=" + roomId, cookie).execute();
        try {
            JsonNode jsonNode = BilibiliApis.responseInterceptor(response.body());
            return jsonNode;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode getDanmuInfo(long roomId, int type, String cookie) {
        HttpResponse response = BilibiliApis.createGetRequest("https://api.live.bilibili.com/xlive/web-room/v1/index/getDanmuInfo?id=" + roomId + "&type=" + type, cookie).execute();
        try {
            JsonNode jsonNode = BilibiliApis.responseInterceptor(response.body());
            return jsonNode;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    public static String getGiftImgById(long giftId, long roomId) {
        if (!GIFT_IMG_CACHE.containsKey((Object)giftId)) {
            ThreadUtil.execAsync(() -> BilibiliApis.updateGiftImgCache(roomId, null));
        }
        return (String)GIFT_IMG_CACHE.get((Object)giftId);
    }

    public static void updateGiftImgCache(long roomId, String cookie) {
        JsonNode jsonNode = BilibiliApis.roomGiftConfig(roomId, cookie);
        for (JsonNode node : jsonNode.get("global_gift").get("list")) {
            long giftId = node.get("id").asLong();
            String giftImgUrl = node.get("webp").asText();
            GIFT_IMG_CACHE.put((Object)giftId, (Object)giftImgUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMsg(BilibiliSendMsgRequest request, String cookie) {
        if (StrUtil.isBlank((CharSequence)cookie)) {
            throw new BaseException("\u53d1\u9001\u5f39\u5e55\u63a5\u53e3cookie\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map stringObjectMap = BeanUtil.beanToMap((Object)request, (String[])new String[0]);
        HttpResponse execute = HttpUtil.createPost((String)"https://api.live.bilibili.com/msg/send").cookie(cookie).form(stringObjectMap).execute();
        try {
            BilibiliApis.responseInterceptor(execute.body());
        }
        finally {
            if (Collections.singletonList(execute).get(0) != null) {
                execute.close();
            }
        }
    }

    public static void sendMsg(String msg, long realRoomId, String cookie) {
        String biliJct = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_COOKIE_CSRF, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570bili_jct");
        });
        BilibiliSendMsgRequest request = new BilibiliSendMsgRequest(msg, StrUtil.toString((Object)ZonedDateTime.now(ZoneId.of("Asia/Shanghai")).toEpochSecond()), realRoomId, biliJct, biliJct);
        BilibiliApis.sendMsg(request, cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void likeReportV3(BilibiliLikeReportV3Request request, String cookie) {
        if (StrUtil.isBlank((CharSequence)cookie)) {
            throw new BaseException("\u4e3a\u4e3b\u64ad\u70b9\u8d5e\u63a5\u53e3cookie\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map stringObjectMap = BeanUtil.beanToMap((Object)request, (String[])new String[0]);
        HttpResponse execute = HttpUtil.createPost((String)"https://api.live.bilibili.com/xlive/app-ucenter/v1/like_info_v3/like/likeReportV3").cookie(cookie).form(stringObjectMap).execute();
        try {
            BilibiliApis.responseInterceptor(execute.body());
        }
        finally {
            if (Collections.singletonList(execute).get(0) != null) {
                execute.close();
            }
        }
    }

    public static void likeReportV3(long anchor_id, long realRoomId, String cookie) {
        String uid = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_UID, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570DedeUserID");
        });
        String biliJct = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_COOKIE_CSRF, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570bili_jct");
        });
        BilibiliLikeReportV3Request request = new BilibiliLikeReportV3Request(realRoomId, uid, anchor_id, biliJct, biliJct);
        BilibiliApis.likeReportV3(request, cookie);
    }

    public static HttpRequest createGetRequest(String url, String cookies) {
        return HttpUtil.createGet((String)url).cookie(cookies);
    }

    private static JsonNode responseInterceptor(String responseString) {
        try {
            JsonNode jsonNode = BaseMsg.OBJECT_MAPPER.readTree(responseString);
            int code = jsonNode.get("code").asInt();
            if (code == 0) {
                return jsonNode.get("data");
            }
            throw new BaseException(jsonNode.get("message").asText());
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public static class RoomInitResult {
        private long room_id;
        private int short_id;
        private long uid;
        private int need_p2p;
        private boolean is_hidden;
        private boolean is_locked;
        private boolean is_portrait;
        private int live_status;
        private int hidden_till;
        private int lock_till;
        private boolean encrypted;
        private boolean pwd_verified;
        private long live_time;
        private int room_shield;
        private int is_sp;
        private int special_type;

        public static RoomInitResultBuilder builder() {
            return new RoomInitResultBuilder();
        }

        public long getRoom_id() {
            return this.room_id;
        }

        public int getShort_id() {
            return this.short_id;
        }

        public long getUid() {
            return this.uid;
        }

        public int getNeed_p2p() {
            return this.need_p2p;
        }

        public boolean is_hidden() {
            return this.is_hidden;
        }

        public boolean is_locked() {
            return this.is_locked;
        }

        public boolean is_portrait() {
            return this.is_portrait;
        }

        public int getLive_status() {
            return this.live_status;
        }

        public int getHidden_till() {
            return this.hidden_till;
        }

        public int getLock_till() {
            return this.lock_till;
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public boolean isPwd_verified() {
            return this.pwd_verified;
        }

        public long getLive_time() {
            return this.live_time;
        }

        public int getRoom_shield() {
            return this.room_shield;
        }

        public int getIs_sp() {
            return this.is_sp;
        }

        public int getSpecial_type() {
            return this.special_type;
        }

        public void setRoom_id(long room_id) {
            this.room_id = room_id;
        }

        public void setShort_id(int short_id) {
            this.short_id = short_id;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public void setNeed_p2p(int need_p2p) {
            this.need_p2p = need_p2p;
        }

        public void set_hidden(boolean is_hidden) {
            this.is_hidden = is_hidden;
        }

        public void set_locked(boolean is_locked) {
            this.is_locked = is_locked;
        }

        public void set_portrait(boolean is_portrait) {
            this.is_portrait = is_portrait;
        }

        public void setLive_status(int live_status) {
            this.live_status = live_status;
        }

        public void setHidden_till(int hidden_till) {
            this.hidden_till = hidden_till;
        }

        public void setLock_till(int lock_till) {
            this.lock_till = lock_till;
        }

        public void setEncrypted(boolean encrypted) {
            this.encrypted = encrypted;
        }

        public void setPwd_verified(boolean pwd_verified) {
            this.pwd_verified = pwd_verified;
        }

        public void setLive_time(long live_time) {
            this.live_time = live_time;
        }

        public void setRoom_shield(int room_shield) {
            this.room_shield = room_shield;
        }

        public void setIs_sp(int is_sp) {
            this.is_sp = is_sp;
        }

        public void setSpecial_type(int special_type) {
            this.special_type = special_type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoomInitResult)) {
                return false;
            }
            RoomInitResult other = (RoomInitResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRoom_id() != other.getRoom_id()) {
                return false;
            }
            if (this.getShort_id() != other.getShort_id()) {
                return false;
            }
            if (this.getUid() != other.getUid()) {
                return false;
            }
            if (this.getNeed_p2p() != other.getNeed_p2p()) {
                return false;
            }
            if (this.is_hidden() != other.is_hidden()) {
                return false;
            }
            if (this.is_locked() != other.is_locked()) {
                return false;
            }
            if (this.is_portrait() != other.is_portrait()) {
                return false;
            }
            if (this.getLive_status() != other.getLive_status()) {
                return false;
            }
            if (this.getHidden_till() != other.getHidden_till()) {
                return false;
            }
            if (this.getLock_till() != other.getLock_till()) {
                return false;
            }
            if (this.isEncrypted() != other.isEncrypted()) {
                return false;
            }
            if (this.isPwd_verified() != other.isPwd_verified()) {
                return false;
            }
            if (this.getLive_time() != other.getLive_time()) {
                return false;
            }
            if (this.getRoom_shield() != other.getRoom_shield()) {
                return false;
            }
            if (this.getIs_sp() != other.getIs_sp()) {
                return false;
            }
            return this.getSpecial_type() == other.getSpecial_type();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoomInitResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $room_id = this.getRoom_id();
            result = result * 59 + (int)($room_id >>> 32 ^ $room_id);
            result = result * 59 + this.getShort_id();
            long $uid = this.getUid();
            result = result * 59 + (int)($uid >>> 32 ^ $uid);
            result = result * 59 + this.getNeed_p2p();
            result = result * 59 + (this.is_hidden() ? 79 : 97);
            result = result * 59 + (this.is_locked() ? 79 : 97);
            result = result * 59 + (this.is_portrait() ? 79 : 97);
            result = result * 59 + this.getLive_status();
            result = result * 59 + this.getHidden_till();
            result = result * 59 + this.getLock_till();
            result = result * 59 + (this.isEncrypted() ? 79 : 97);
            result = result * 59 + (this.isPwd_verified() ? 79 : 97);
            long $live_time = this.getLive_time();
            result = result * 59 + (int)($live_time >>> 32 ^ $live_time);
            result = result * 59 + this.getRoom_shield();
            result = result * 59 + this.getIs_sp();
            result = result * 59 + this.getSpecial_type();
            return result;
        }

        public String toString() {
            return "BilibiliApis.RoomInitResult(room_id=" + this.getRoom_id() + ", short_id=" + this.getShort_id() + ", uid=" + this.getUid() + ", need_p2p=" + this.getNeed_p2p() + ", is_hidden=" + this.is_hidden() + ", is_locked=" + this.is_locked() + ", is_portrait=" + this.is_portrait() + ", live_status=" + this.getLive_status() + ", hidden_till=" + this.getHidden_till() + ", lock_till=" + this.getLock_till() + ", encrypted=" + this.isEncrypted() + ", pwd_verified=" + this.isPwd_verified() + ", live_time=" + this.getLive_time() + ", room_shield=" + this.getRoom_shield() + ", is_sp=" + this.getIs_sp() + ", special_type=" + this.getSpecial_type() + ")";
        }

        public RoomInitResult(long room_id, int short_id, long uid, int need_p2p, boolean is_hidden, boolean is_locked, boolean is_portrait, int live_status, int hidden_till, int lock_till, boolean encrypted, boolean pwd_verified, long live_time, int room_shield, int is_sp, int special_type) {
            this.room_id = room_id;
            this.short_id = short_id;
            this.uid = uid;
            this.need_p2p = need_p2p;
            this.is_hidden = is_hidden;
            this.is_locked = is_locked;
            this.is_portrait = is_portrait;
            this.live_status = live_status;
            this.hidden_till = hidden_till;
            this.lock_till = lock_till;
            this.encrypted = encrypted;
            this.pwd_verified = pwd_verified;
            this.live_time = live_time;
            this.room_shield = room_shield;
            this.is_sp = is_sp;
            this.special_type = special_type;
        }

        public RoomInitResult() {
        }

        public static class RoomInitResultBuilder {
            private long room_id;
            private int short_id;
            private long uid;
            private int need_p2p;
            private boolean is_hidden;
            private boolean is_locked;
            private boolean is_portrait;
            private int live_status;
            private int hidden_till;
            private int lock_till;
            private boolean encrypted;
            private boolean pwd_verified;
            private long live_time;
            private int room_shield;
            private int is_sp;
            private int special_type;

            RoomInitResultBuilder() {
            }

            public RoomInitResultBuilder room_id(long room_id) {
                this.room_id = room_id;
                return this;
            }

            public RoomInitResultBuilder short_id(int short_id) {
                this.short_id = short_id;
                return this;
            }

            public RoomInitResultBuilder uid(long uid) {
                this.uid = uid;
                return this;
            }

            public RoomInitResultBuilder need_p2p(int need_p2p) {
                this.need_p2p = need_p2p;
                return this;
            }

            public RoomInitResultBuilder is_hidden(boolean is_hidden) {
                this.is_hidden = is_hidden;
                return this;
            }

            public RoomInitResultBuilder is_locked(boolean is_locked) {
                this.is_locked = is_locked;
                return this;
            }

            public RoomInitResultBuilder is_portrait(boolean is_portrait) {
                this.is_portrait = is_portrait;
                return this;
            }

            public RoomInitResultBuilder live_status(int live_status) {
                this.live_status = live_status;
                return this;
            }

            public RoomInitResultBuilder hidden_till(int hidden_till) {
                this.hidden_till = hidden_till;
                return this;
            }

            public RoomInitResultBuilder lock_till(int lock_till) {
                this.lock_till = lock_till;
                return this;
            }

            public RoomInitResultBuilder encrypted(boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public RoomInitResultBuilder pwd_verified(boolean pwd_verified) {
                this.pwd_verified = pwd_verified;
                return this;
            }

            public RoomInitResultBuilder live_time(long live_time) {
                this.live_time = live_time;
                return this;
            }

            public RoomInitResultBuilder room_shield(int room_shield) {
                this.room_shield = room_shield;
                return this;
            }

            public RoomInitResultBuilder is_sp(int is_sp) {
                this.is_sp = is_sp;
                return this;
            }

            public RoomInitResultBuilder special_type(int special_type) {
                this.special_type = special_type;
                return this;
            }

            public RoomInitResult build() {
                return new RoomInitResult(this.room_id, this.short_id, this.uid, this.need_p2p, this.is_hidden, this.is_locked, this.is_portrait, this.live_status, this.hidden_till, this.lock_till, this.encrypted, this.pwd_verified, this.live_time, this.room_shield, this.is_sp, this.special_type);
            }

            public String toString() {
                return "BilibiliApis.RoomInitResult.RoomInitResultBuilder(room_id=" + this.room_id + ", short_id=" + this.short_id + ", uid=" + this.uid + ", need_p2p=" + this.need_p2p + ", is_hidden=" + this.is_hidden + ", is_locked=" + this.is_locked + ", is_portrait=" + this.is_portrait + ", live_status=" + this.live_status + ", hidden_till=" + this.hidden_till + ", lock_till=" + this.lock_till + ", encrypted=" + this.encrypted + ", pwd_verified=" + this.pwd_verified + ", live_time=" + this.live_time + ", room_shield=" + this.room_shield + ", is_sp=" + this.is_sp + ", special_type=" + this.special_type + ")";
            }
        }
    }
}

