/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.netty.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.client.BilibiliLiveChatClient;
import tech.ordinaryroad.live.chat.client.bilibili.config.BilibiliLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.bilibili.constant.ProtoverEnum;
import tech.ordinaryroad.live.chat.client.bilibili.netty.frame.factory.BilibiliWebSocketFrameFactory;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientConnectionHandler;

@ChannelHandler.Sharable
public class BilibiliConnectionHandler
extends BaseNettyClientConnectionHandler<BilibiliLiveChatClient, BilibiliConnectionHandler> {
    private static final Logger log = LoggerFactory.getLogger(BilibiliConnectionHandler.class);
    private final long roomId;
    private final ProtoverEnum protover;
    private String cookie;

    public BilibiliConnectionHandler(WebSocketClientHandshaker handshaker, BilibiliLiveChatClient client, IBaseConnectionListener<BilibiliConnectionHandler> listener) {
        super(handshaker, (BaseNettyClient)client, listener);
        this.roomId = ((BilibiliLiveChatClientConfig)client.getConfig()).getRoomId();
        this.protover = ((BilibiliLiveChatClientConfig)client.getConfig()).getProtover();
        this.cookie = ((BilibiliLiveChatClientConfig)client.getConfig()).getCookie();
    }

    public BilibiliConnectionHandler(WebSocketClientHandshaker handshaker, BilibiliLiveChatClient client) {
        this(handshaker, client, null);
    }

    public BilibiliConnectionHandler(WebSocketClientHandshaker handshaker, long roomId, ProtoverEnum protover, IBaseConnectionListener<BilibiliConnectionHandler> listener, String cookie) {
        super(handshaker, listener);
        this.roomId = roomId;
        this.protover = protover;
        this.cookie = cookie;
    }

    public BilibiliConnectionHandler(WebSocketClientHandshaker handshaker, long roomId, ProtoverEnum protover, IBaseConnectionListener<BilibiliConnectionHandler> listener) {
        this(handshaker, roomId, protover, listener, null);
    }

    public BilibiliConnectionHandler(WebSocketClientHandshaker handshaker, long roomId, ProtoverEnum protover, String cookie) {
        this(handshaker, roomId, protover, null, cookie);
    }

    public BilibiliConnectionHandler(WebSocketClientHandshaker handshaker, long roomId, ProtoverEnum protover) {
        this(handshaker, roomId, protover, null, null);
    }

    protected void sendHeartbeat(ChannelHandlerContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u9001\u5fc3\u8df3\u5305");
        }
        ctx.writeAndFlush((Object)BilibiliConnectionHandler.getWebSocketFrameFactory(this.getRoomId()).createHeartbeat(this.getProtover())).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5fc3\u8df3\u5305\u53d1\u9001\u5b8c\u6210");
                }
            } else {
                log.error("\u5fc3\u8df3\u5305\u53d1\u9001\u5931\u8d25", future.cause());
            }
        }));
    }

    private static BilibiliWebSocketFrameFactory getWebSocketFrameFactory(long roomId) {
        return BilibiliWebSocketFrameFactory.getInstance(roomId);
    }

    public void sendAuthRequest(Channel channel) {
        log.debug("\u53d1\u9001\u8ba4\u8bc1\u5305");
        channel.writeAndFlush((Object)BilibiliConnectionHandler.getWebSocketFrameFactory(this.getRoomId()).createAuth(this.getProtover(), this.getCookie()));
    }

    public long getRoomId() {
        return this.client != null ? ((BilibiliLiveChatClientConfig)((BilibiliLiveChatClient)this.client).getConfig()).getRoomId() : this.roomId;
    }

    private ProtoverEnum getProtover() {
        return this.client != null ? ((BilibiliLiveChatClientConfig)((BilibiliLiveChatClient)this.client).getConfig()).getProtover() : this.protover;
    }

    private String getCookie() {
        return this.client != null ? ((BilibiliLiveChatClientConfig)((BilibiliLiveChatClient)this.client).getConfig()).getCookie() : this.cookie;
    }

    protected long getHeartbeatPeriod() {
        if (this.client == null) {
            return 25L;
        }
        return ((BilibiliLiveChatClientConfig)((BilibiliLiveChatClient)this.client).getConfig()).getHeartbeatPeriod();
    }

    protected long getHeartbeatInitialDelay() {
        if (this.client == null) {
            return 15L;
        }
        return ((BilibiliLiveChatClientConfig)((BilibiliLiveChatClient)this.client).getConfig()).getHeartbeatInitialDelay();
    }
}

