/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.client.BilibiliLiveChatClient;
import tech.ordinaryroad.live.chat.client.bilibili.constant.BilibiliCmdEnum;
import tech.ordinaryroad.live.chat.client.bilibili.listener.IBilibiliSendSmsReplyMsgListener;
import tech.ordinaryroad.live.chat.client.bilibili.msg.SendSmsReplyMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.base.IBilibiliMsg;
import tech.ordinaryroad.live.chat.client.bilibili.util.BilibiliCodecUtil;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseMsgListener;
import tech.ordinaryroad.live.chat.client.commons.base.msg.BaseCmdMsg;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientBinaryFrameHandler;

@ChannelHandler.Sharable
public class BilibiliBinaryFrameHandler
extends BaseNettyClientBinaryFrameHandler<BilibiliLiveChatClient, BilibiliBinaryFrameHandler, BilibiliCmdEnum, IBilibiliMsg, IBilibiliSendSmsReplyMsgListener> {
    private static final Logger log = LoggerFactory.getLogger(BilibiliBinaryFrameHandler.class);

    public BilibiliBinaryFrameHandler(IBilibiliSendSmsReplyMsgListener listener, BilibiliLiveChatClient client) {
        super((IBaseMsgListener)listener, (BaseNettyClient)client);
    }

    public BilibiliBinaryFrameHandler(IBilibiliSendSmsReplyMsgListener listener, long roomId) {
        super((IBaseMsgListener)listener, roomId);
    }

    public void onCmdMsg(BilibiliCmdEnum cmd, BaseCmdMsg<BilibiliCmdEnum> cmdMsg) {
        super.onCmdMsg((Enum)cmd, cmdMsg);
        if (this.listener == null) {
            return;
        }
        SendSmsReplyMsg sendSmsReplyMsg = (SendSmsReplyMsg)cmdMsg;
        switch (cmd) {
            case DANMU_MSG: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onDanmuMsg(this, sendSmsReplyMsg);
                break;
            }
            case SEND_GIFT: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onSendGift(this, sendSmsReplyMsg);
                break;
            }
            case INTERACT_WORD: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onEnterRoom(this, sendSmsReplyMsg);
                break;
            }
            case ENTRY_EFFECT: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onEntryEffect(this, sendSmsReplyMsg);
                break;
            }
            case WATCHED_CHANGE: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onWatchedChange(this, sendSmsReplyMsg);
                break;
            }
            case LIKE_INFO_V3_CLICK: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onClickLike(this, sendSmsReplyMsg);
                break;
            }
            case LIKE_INFO_V3_UPDATE: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onClickUpdate(this, sendSmsReplyMsg);
                break;
            }
            case HOT_RANK_CHANGED_V2: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onOtherCmdMsg((Object)this, cmd, sendSmsReplyMsg);
                break;
            }
            case ONLINE_RANK_COUNT: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onOtherCmdMsg((Object)this, cmd, sendSmsReplyMsg);
                break;
            }
            case ROOM_REAL_TIME_MESSAGE_UPDATE: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onOtherCmdMsg((Object)this, cmd, sendSmsReplyMsg);
                break;
            }
            case STOP_LIVE_ROOM_LIST: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onOtherCmdMsg((Object)this, cmd, sendSmsReplyMsg);
                break;
            }
            case ONLINE_RANK_V2: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onOtherCmdMsg((Object)this, cmd, sendSmsReplyMsg);
                break;
            }
            default: {
                ((IBilibiliSendSmsReplyMsgListener)this.listener).onOtherCmdMsg((Object)this, cmd, cmdMsg);
            }
        }
    }

    protected List<IBilibiliMsg> decode(ByteBuf byteBuf) {
        return BilibiliCodecUtil.decode(byteBuf);
    }
}

