/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.api;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BilibiliApis {
    private static final Logger log = LoggerFactory.getLogger(BilibiliApis.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode roomInit(long roomId, String cookie) {
        HttpResponse response = BilibiliApis.createGetRequest("https://api.live.bilibili.com/room/v1/Room/room_init?id=" + roomId, cookie).execute();
        try {
            JsonNode jsonNode = BilibiliApis.responseInterceptor(response.body());
            return jsonNode;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode getDanmuInfo(long roomId, int type, String cookie) {
        HttpResponse response = BilibiliApis.createGetRequest("https://api.live.bilibili.com/xlive/web-room/v1/index/getDanmuInfo?id=" + roomId + "&type=" + type, cookie).execute();
        try {
            JsonNode jsonNode = BilibiliApis.responseInterceptor(response.body());
            return jsonNode;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    public static HttpRequest createGetRequest(String url, String cookies) {
        return HttpUtil.createGet((String)url).cookie(cookies);
    }

    private static JsonNode responseInterceptor(String responseString) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseString);
            int code = jsonNode.get("code").asInt();
            if (code == 0) {
                return jsonNode.get("data");
            }
            throw new RuntimeException(jsonNode.get("message").asText());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

