/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.netty.handler;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.TreeNode;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.client.BilibiliLiveChatClient;
import tech.ordinaryroad.live.chat.client.bilibili.constant.BilibiliCmdEnum;
import tech.ordinaryroad.live.chat.client.bilibili.listener.IBilibiliMsgListener;
import tech.ordinaryroad.live.chat.client.bilibili.msg.DanmuMsgMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.InteractWordMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.SendGiftMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.SendSmsReplyMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.SuperChatMessageMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.base.BaseBilibiliMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.base.IBilibiliMsg;
import tech.ordinaryroad.live.chat.client.bilibili.util.BilibiliCodecUtil;
import tech.ordinaryroad.live.chat.client.commons.base.msg.ICmdMsg;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientBinaryFrameHandler;

@ChannelHandler.Sharable
public class BilibiliBinaryFrameHandler
extends BaseNettyClientBinaryFrameHandler<BilibiliLiveChatClient, BilibiliBinaryFrameHandler, BilibiliCmdEnum, IBilibiliMsg, IBilibiliMsgListener> {
    private static final Logger log = LoggerFactory.getLogger(BilibiliBinaryFrameHandler.class);

    public BilibiliBinaryFrameHandler(List<IBilibiliMsgListener> msgListeners, BilibiliLiveChatClient client) {
        super(msgListeners, (BaseNettyClient)client);
    }

    public BilibiliBinaryFrameHandler(List<IBilibiliMsgListener> msgListeners, long roomId) {
        super(msgListeners, roomId);
    }

    public void onCmdMsg(BilibiliCmdEnum cmd, ICmdMsg<BilibiliCmdEnum> cmdMsg) {
        if (this.msgListeners.isEmpty()) {
            return;
        }
        SendSmsReplyMsg sendSmsReplyMsg = (SendSmsReplyMsg)cmdMsg;
        switch (cmd) {
            case DANMU_MSG: {
                DanmuMsgMsg danmuMsgMsg = new DanmuMsgMsg();
                danmuMsgMsg.setProtover(sendSmsReplyMsg.getProtover());
                danmuMsgMsg.setInfo(sendSmsReplyMsg.getInfo());
                danmuMsgMsg.setDm_v2(StrUtil.toStringOrNull(sendSmsReplyMsg.getUnknownProperties().get("dm_v2")));
                this.iteratorMsgListeners(msgListener -> msgListener.onDanmuMsg((Object)this, danmuMsgMsg));
                break;
            }
            case SEND_GIFT: {
                SendGiftMsg sendGiftMsg = new SendGiftMsg();
                sendGiftMsg.setRoomId(this.getRoomIdAsLong());
                sendGiftMsg.setProtover(sendSmsReplyMsg.getProtover());
                SendGiftMsg.Data data = (SendGiftMsg.Data)BaseBilibiliMsg.OBJECT_MAPPER.treeToValue((TreeNode)sendSmsReplyMsg.getData(), SendGiftMsg.Data.class);
                sendGiftMsg.setData(data);
                this.iteratorMsgListeners(msgListener -> {
                    msgListener.onGiftMsg((Object)this, sendGiftMsg);
                    msgListener.onSendGift(this, sendSmsReplyMsg);
                });
                break;
            }
            case SUPER_CHAT_MESSAGE: {
                SuperChatMessageMsg superChatMessageMsg = new SuperChatMessageMsg();
                superChatMessageMsg.setProtover(sendSmsReplyMsg.getProtover());
                superChatMessageMsg.setRoomid(sendSmsReplyMsg.getRoomid());
                SuperChatMessageMsg.Data data = (SuperChatMessageMsg.Data)BaseBilibiliMsg.OBJECT_MAPPER.treeToValue((TreeNode)sendSmsReplyMsg.getData(), SuperChatMessageMsg.Data.class);
                superChatMessageMsg.setData(data);
                this.iteratorMsgListeners(msgListener -> msgListener.onSuperChatMsg((Object)this, superChatMessageMsg));
                break;
            }
            case INTERACT_WORD: {
                InteractWordMsg interactWordMsg = new InteractWordMsg();
                interactWordMsg.setProtover(sendSmsReplyMsg.getProtover());
                InteractWordMsg.Data data = (InteractWordMsg.Data)BaseBilibiliMsg.OBJECT_MAPPER.treeToValue((TreeNode)sendSmsReplyMsg.getData(), InteractWordMsg.Data.class);
                interactWordMsg.setData(data);
                this.iteratorMsgListeners(msgListener -> {
                    msgListener.onEnterRoomMsg((Object)this, interactWordMsg);
                    msgListener.onEnterRoom(this, sendSmsReplyMsg);
                });
                break;
            }
            case ENTRY_EFFECT: {
                this.iteratorMsgListeners(msgListener -> msgListener.onEntryEffect(this, sendSmsReplyMsg));
                break;
            }
            case WATCHED_CHANGE: {
                this.iteratorMsgListeners(msgListener -> msgListener.onWatchedChange(this, sendSmsReplyMsg));
                break;
            }
            case LIKE_INFO_V3_CLICK: {
                this.iteratorMsgListeners(msgListener -> msgListener.onClickLike(this, sendSmsReplyMsg));
                break;
            }
            case LIKE_INFO_V3_UPDATE: {
                this.iteratorMsgListeners(msgListener -> msgListener.onClickUpdate(this, sendSmsReplyMsg));
                break;
            }
            default: {
                this.iteratorMsgListeners(msgListener -> msgListener.onOtherCmdMsg((Object)this, cmd, cmdMsg));
                break;
            }
        }
    }

    protected List<IBilibiliMsg> decode(ByteBuf byteBuf) {
        return BilibiliCodecUtil.decode(byteBuf);
    }
}

