/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.msg;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import tech.ordinaryroad.live.chat.client.bilibili.api.BilibiliApis;
import tech.ordinaryroad.live.chat.client.bilibili.constant.OperationEnum;
import tech.ordinaryroad.live.chat.client.bilibili.msg.base.BaseBilibiliMsg;
import tech.ordinaryroad.live.chat.client.bilibili.msg.dto.MedalInfo;
import tech.ordinaryroad.live.chat.client.commons.base.msg.IGiftMsg;

public class SendGiftMsg
extends BaseBilibiliMsg
implements IGiftMsg {
    private Data data;
    private long roomId;

    public String getBadgeName() {
        if (this.data == null || this.data.medal_info == null) {
            return super.getBadgeName();
        }
        return this.data.medal_info.getMedal_name();
    }

    public byte getBadgeLevel() {
        if (this.data == null || this.data.medal_info == null) {
            return super.getBadgeLevel();
        }
        return this.data.medal_info.getMedal_level();
    }

    public long getUid() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.getUid();
    }

    public String getUsername() {
        if (this.data == null) {
            return "";
        }
        return this.data.getUname();
    }

    public String getUserAvatar() {
        if (this.data == null) {
            return "";
        }
        return this.data.getFace();
    }

    public String getGiftName() {
        if (this.data == null) {
            return "\u672a\u77e5\u793c\u7269";
        }
        return this.data.getGiftName();
    }

    public String getGiftImg() {
        return BilibiliApis.getGiftImgById(this.data.giftId, this.roomId);
    }

    public long getGiftId() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.getGiftId();
    }

    public int getGiftCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getNum();
    }

    public int getGiftPrice() {
        if (this.data == null) {
            return -1;
        }
        return this.data.getPrice();
    }

    public long getReceiveUid() {
        if (this.data == null || this.data.getReceive_user_info() == null) {
            return 0L;
        }
        return this.data.getReceive_user_info().getUid();
    }

    public String getReceiveUsername() {
        if (this.data == null || this.data.getReceive_user_info() == null) {
            return "";
        }
        return this.data.getReceive_user_info().getUname();
    }

    @Override
    public OperationEnum getOperationEnum() {
        return OperationEnum.SEND_SMS_REPLY;
    }

    public Data getData() {
        return this.data;
    }

    public long getRoomId() {
        return this.roomId;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public void setRoomId(long roomId) {
        this.roomId = roomId;
    }

    public SendGiftMsg(Data data, long roomId) {
        this.data = data;
        this.roomId = roomId;
    }

    public SendGiftMsg() {
    }

    public static class Data {
        private int draw;
        private int gold;
        private int silver;
        private int num;
        private int total_coin;
        private int effect;
        private int broadcast_id;
        private int crit_prob;
        private int guard_level;
        private long rcost;
        private long uid;
        private long timestamp;
        private int giftId;
        private int giftType;
        @JsonProperty(value="super")
        private int _super;
        private int super_gift_num;
        private int super_batch_gift_num;
        private int remain;
        private int discount_price;
        private int price;
        private String beatId;
        private String biz_source;
        private String action;
        private String coin_type;
        private String uname;
        private String face;
        private String batch_combo_id;
        private String rnd;
        private String giftName;
        private String original_gift_name;
        private Combo_send combo_send;
        private Batch_combo_send batch_combo_send;
        private String tag_image;
        private String top_list;
        private String send_master;
        private boolean is_first;
        private int demarcation;
        private int combo_stay_time;
        private int combo_total_coin;
        private String tid;
        private int effect_block;
        private int is_special_batch;
        private int combo_resources_id;
        private int magnification;
        private String name_color;
        private MedalInfo medal_info;
        private int svga_block;
        private JsonNode blind_gift;
        private int float_sc_resource_id;
        @JsonProperty(value="switch")
        private boolean _switch;
        private int face_effect_type;
        private int face_effect_id;
        private boolean is_naming;
        private Receive_user_info receive_user_info;
        private boolean is_join_receiver;
        private Bag_gift bag_gift;
        private int wealth_level;
        private final Map<String, JsonNode> unknownProperties = new HashMap<String, JsonNode>();

        @JsonAnyGetter
        public Map<String, JsonNode> getUnknownProperties() {
            return this.unknownProperties;
        }

        @JsonAnySetter
        public void setOther(String key, JsonNode value) {
            this.unknownProperties.put(key, value);
        }

        public int getDraw() {
            return this.draw;
        }

        public int getGold() {
            return this.gold;
        }

        public int getSilver() {
            return this.silver;
        }

        public int getNum() {
            return this.num;
        }

        public int getTotal_coin() {
            return this.total_coin;
        }

        public int getEffect() {
            return this.effect;
        }

        public int getBroadcast_id() {
            return this.broadcast_id;
        }

        public int getCrit_prob() {
            return this.crit_prob;
        }

        public int getGuard_level() {
            return this.guard_level;
        }

        public long getRcost() {
            return this.rcost;
        }

        public long getUid() {
            return this.uid;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getGiftId() {
            return this.giftId;
        }

        public int getGiftType() {
            return this.giftType;
        }

        public int get_super() {
            return this._super;
        }

        public int getSuper_gift_num() {
            return this.super_gift_num;
        }

        public int getSuper_batch_gift_num() {
            return this.super_batch_gift_num;
        }

        public int getRemain() {
            return this.remain;
        }

        public int getDiscount_price() {
            return this.discount_price;
        }

        public int getPrice() {
            return this.price;
        }

        public String getBeatId() {
            return this.beatId;
        }

        public String getBiz_source() {
            return this.biz_source;
        }

        public String getAction() {
            return this.action;
        }

        public String getCoin_type() {
            return this.coin_type;
        }

        public String getUname() {
            return this.uname;
        }

        public String getFace() {
            return this.face;
        }

        public String getBatch_combo_id() {
            return this.batch_combo_id;
        }

        public String getRnd() {
            return this.rnd;
        }

        public String getGiftName() {
            return this.giftName;
        }

        public String getOriginal_gift_name() {
            return this.original_gift_name;
        }

        public Combo_send getCombo_send() {
            return this.combo_send;
        }

        public Batch_combo_send getBatch_combo_send() {
            return this.batch_combo_send;
        }

        public String getTag_image() {
            return this.tag_image;
        }

        public String getTop_list() {
            return this.top_list;
        }

        public String getSend_master() {
            return this.send_master;
        }

        public boolean is_first() {
            return this.is_first;
        }

        public int getDemarcation() {
            return this.demarcation;
        }

        public int getCombo_stay_time() {
            return this.combo_stay_time;
        }

        public int getCombo_total_coin() {
            return this.combo_total_coin;
        }

        public String getTid() {
            return this.tid;
        }

        public int getEffect_block() {
            return this.effect_block;
        }

        public int getIs_special_batch() {
            return this.is_special_batch;
        }

        public int getCombo_resources_id() {
            return this.combo_resources_id;
        }

        public int getMagnification() {
            return this.magnification;
        }

        public String getName_color() {
            return this.name_color;
        }

        public MedalInfo getMedal_info() {
            return this.medal_info;
        }

        public int getSvga_block() {
            return this.svga_block;
        }

        public JsonNode getBlind_gift() {
            return this.blind_gift;
        }

        public int getFloat_sc_resource_id() {
            return this.float_sc_resource_id;
        }

        public boolean is_switch() {
            return this._switch;
        }

        public int getFace_effect_type() {
            return this.face_effect_type;
        }

        public int getFace_effect_id() {
            return this.face_effect_id;
        }

        public boolean is_naming() {
            return this.is_naming;
        }

        public Receive_user_info getReceive_user_info() {
            return this.receive_user_info;
        }

        public boolean is_join_receiver() {
            return this.is_join_receiver;
        }

        public Bag_gift getBag_gift() {
            return this.bag_gift;
        }

        public int getWealth_level() {
            return this.wealth_level;
        }

        public void setDraw(int draw) {
            this.draw = draw;
        }

        public void setGold(int gold) {
            this.gold = gold;
        }

        public void setSilver(int silver) {
            this.silver = silver;
        }

        public void setNum(int num) {
            this.num = num;
        }

        public void setTotal_coin(int total_coin) {
            this.total_coin = total_coin;
        }

        public void setEffect(int effect) {
            this.effect = effect;
        }

        public void setBroadcast_id(int broadcast_id) {
            this.broadcast_id = broadcast_id;
        }

        public void setCrit_prob(int crit_prob) {
            this.crit_prob = crit_prob;
        }

        public void setGuard_level(int guard_level) {
            this.guard_level = guard_level;
        }

        public void setRcost(long rcost) {
            this.rcost = rcost;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setGiftId(int giftId) {
            this.giftId = giftId;
        }

        public void setGiftType(int giftType) {
            this.giftType = giftType;
        }

        @JsonProperty(value="super")
        public void set_super(int _super) {
            this._super = _super;
        }

        public void setSuper_gift_num(int super_gift_num) {
            this.super_gift_num = super_gift_num;
        }

        public void setSuper_batch_gift_num(int super_batch_gift_num) {
            this.super_batch_gift_num = super_batch_gift_num;
        }

        public void setRemain(int remain) {
            this.remain = remain;
        }

        public void setDiscount_price(int discount_price) {
            this.discount_price = discount_price;
        }

        public void setPrice(int price) {
            this.price = price;
        }

        public void setBeatId(String beatId) {
            this.beatId = beatId;
        }

        public void setBiz_source(String biz_source) {
            this.biz_source = biz_source;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void setCoin_type(String coin_type) {
            this.coin_type = coin_type;
        }

        public void setUname(String uname) {
            this.uname = uname;
        }

        public void setFace(String face) {
            this.face = face;
        }

        public void setBatch_combo_id(String batch_combo_id) {
            this.batch_combo_id = batch_combo_id;
        }

        public void setRnd(String rnd) {
            this.rnd = rnd;
        }

        public void setGiftName(String giftName) {
            this.giftName = giftName;
        }

        public void setOriginal_gift_name(String original_gift_name) {
            this.original_gift_name = original_gift_name;
        }

        public void setCombo_send(Combo_send combo_send) {
            this.combo_send = combo_send;
        }

        public void setBatch_combo_send(Batch_combo_send batch_combo_send) {
            this.batch_combo_send = batch_combo_send;
        }

        public void setTag_image(String tag_image) {
            this.tag_image = tag_image;
        }

        public void setTop_list(String top_list) {
            this.top_list = top_list;
        }

        public void setSend_master(String send_master) {
            this.send_master = send_master;
        }

        public void set_first(boolean is_first) {
            this.is_first = is_first;
        }

        public void setDemarcation(int demarcation) {
            this.demarcation = demarcation;
        }

        public void setCombo_stay_time(int combo_stay_time) {
            this.combo_stay_time = combo_stay_time;
        }

        public void setCombo_total_coin(int combo_total_coin) {
            this.combo_total_coin = combo_total_coin;
        }

        public void setTid(String tid) {
            this.tid = tid;
        }

        public void setEffect_block(int effect_block) {
            this.effect_block = effect_block;
        }

        public void setIs_special_batch(int is_special_batch) {
            this.is_special_batch = is_special_batch;
        }

        public void setCombo_resources_id(int combo_resources_id) {
            this.combo_resources_id = combo_resources_id;
        }

        public void setMagnification(int magnification) {
            this.magnification = magnification;
        }

        public void setName_color(String name_color) {
            this.name_color = name_color;
        }

        public void setMedal_info(MedalInfo medal_info) {
            this.medal_info = medal_info;
        }

        public void setSvga_block(int svga_block) {
            this.svga_block = svga_block;
        }

        public void setBlind_gift(JsonNode blind_gift) {
            this.blind_gift = blind_gift;
        }

        public void setFloat_sc_resource_id(int float_sc_resource_id) {
            this.float_sc_resource_id = float_sc_resource_id;
        }

        @JsonProperty(value="switch")
        public void set_switch(boolean _switch) {
            this._switch = _switch;
        }

        public void setFace_effect_type(int face_effect_type) {
            this.face_effect_type = face_effect_type;
        }

        public void setFace_effect_id(int face_effect_id) {
            this.face_effect_id = face_effect_id;
        }

        public void set_naming(boolean is_naming) {
            this.is_naming = is_naming;
        }

        public void setReceive_user_info(Receive_user_info receive_user_info) {
            this.receive_user_info = receive_user_info;
        }

        public void set_join_receiver(boolean is_join_receiver) {
            this.is_join_receiver = is_join_receiver;
        }

        public void setBag_gift(Bag_gift bag_gift) {
            this.bag_gift = bag_gift;
        }

        public void setWealth_level(int wealth_level) {
            this.wealth_level = wealth_level;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDraw() != other.getDraw()) {
                return false;
            }
            if (this.getGold() != other.getGold()) {
                return false;
            }
            if (this.getSilver() != other.getSilver()) {
                return false;
            }
            if (this.getNum() != other.getNum()) {
                return false;
            }
            if (this.getTotal_coin() != other.getTotal_coin()) {
                return false;
            }
            if (this.getEffect() != other.getEffect()) {
                return false;
            }
            if (this.getBroadcast_id() != other.getBroadcast_id()) {
                return false;
            }
            if (this.getCrit_prob() != other.getCrit_prob()) {
                return false;
            }
            if (this.getGuard_level() != other.getGuard_level()) {
                return false;
            }
            if (this.getRcost() != other.getRcost()) {
                return false;
            }
            if (this.getUid() != other.getUid()) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            if (this.getGiftId() != other.getGiftId()) {
                return false;
            }
            if (this.getGiftType() != other.getGiftType()) {
                return false;
            }
            if (this.get_super() != other.get_super()) {
                return false;
            }
            if (this.getSuper_gift_num() != other.getSuper_gift_num()) {
                return false;
            }
            if (this.getSuper_batch_gift_num() != other.getSuper_batch_gift_num()) {
                return false;
            }
            if (this.getRemain() != other.getRemain()) {
                return false;
            }
            if (this.getDiscount_price() != other.getDiscount_price()) {
                return false;
            }
            if (this.getPrice() != other.getPrice()) {
                return false;
            }
            if (this.is_first() != other.is_first()) {
                return false;
            }
            if (this.getDemarcation() != other.getDemarcation()) {
                return false;
            }
            if (this.getCombo_stay_time() != other.getCombo_stay_time()) {
                return false;
            }
            if (this.getCombo_total_coin() != other.getCombo_total_coin()) {
                return false;
            }
            if (this.getEffect_block() != other.getEffect_block()) {
                return false;
            }
            if (this.getIs_special_batch() != other.getIs_special_batch()) {
                return false;
            }
            if (this.getCombo_resources_id() != other.getCombo_resources_id()) {
                return false;
            }
            if (this.getMagnification() != other.getMagnification()) {
                return false;
            }
            if (this.getSvga_block() != other.getSvga_block()) {
                return false;
            }
            if (this.getFloat_sc_resource_id() != other.getFloat_sc_resource_id()) {
                return false;
            }
            if (this.is_switch() != other.is_switch()) {
                return false;
            }
            if (this.getFace_effect_type() != other.getFace_effect_type()) {
                return false;
            }
            if (this.getFace_effect_id() != other.getFace_effect_id()) {
                return false;
            }
            if (this.is_naming() != other.is_naming()) {
                return false;
            }
            if (this.is_join_receiver() != other.is_join_receiver()) {
                return false;
            }
            if (this.getWealth_level() != other.getWealth_level()) {
                return false;
            }
            String this$beatId = this.getBeatId();
            String other$beatId = other.getBeatId();
            if (this$beatId == null ? other$beatId != null : !this$beatId.equals(other$beatId)) {
                return false;
            }
            String this$biz_source = this.getBiz_source();
            String other$biz_source = other.getBiz_source();
            if (this$biz_source == null ? other$biz_source != null : !this$biz_source.equals(other$biz_source)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$coin_type = this.getCoin_type();
            String other$coin_type = other.getCoin_type();
            if (this$coin_type == null ? other$coin_type != null : !this$coin_type.equals(other$coin_type)) {
                return false;
            }
            String this$uname = this.getUname();
            String other$uname = other.getUname();
            if (this$uname == null ? other$uname != null : !this$uname.equals(other$uname)) {
                return false;
            }
            String this$face = this.getFace();
            String other$face = other.getFace();
            if (this$face == null ? other$face != null : !this$face.equals(other$face)) {
                return false;
            }
            String this$batch_combo_id = this.getBatch_combo_id();
            String other$batch_combo_id = other.getBatch_combo_id();
            if (this$batch_combo_id == null ? other$batch_combo_id != null : !this$batch_combo_id.equals(other$batch_combo_id)) {
                return false;
            }
            String this$rnd = this.getRnd();
            String other$rnd = other.getRnd();
            if (this$rnd == null ? other$rnd != null : !this$rnd.equals(other$rnd)) {
                return false;
            }
            String this$giftName = this.getGiftName();
            String other$giftName = other.getGiftName();
            if (this$giftName == null ? other$giftName != null : !this$giftName.equals(other$giftName)) {
                return false;
            }
            String this$original_gift_name = this.getOriginal_gift_name();
            String other$original_gift_name = other.getOriginal_gift_name();
            if (this$original_gift_name == null ? other$original_gift_name != null : !this$original_gift_name.equals(other$original_gift_name)) {
                return false;
            }
            Combo_send this$combo_send = this.getCombo_send();
            Combo_send other$combo_send = other.getCombo_send();
            if (this$combo_send == null ? other$combo_send != null : !((Object)this$combo_send).equals(other$combo_send)) {
                return false;
            }
            Batch_combo_send this$batch_combo_send = this.getBatch_combo_send();
            Batch_combo_send other$batch_combo_send = other.getBatch_combo_send();
            if (this$batch_combo_send == null ? other$batch_combo_send != null : !((Object)this$batch_combo_send).equals(other$batch_combo_send)) {
                return false;
            }
            String this$tag_image = this.getTag_image();
            String other$tag_image = other.getTag_image();
            if (this$tag_image == null ? other$tag_image != null : !this$tag_image.equals(other$tag_image)) {
                return false;
            }
            String this$top_list = this.getTop_list();
            String other$top_list = other.getTop_list();
            if (this$top_list == null ? other$top_list != null : !this$top_list.equals(other$top_list)) {
                return false;
            }
            String this$send_master = this.getSend_master();
            String other$send_master = other.getSend_master();
            if (this$send_master == null ? other$send_master != null : !this$send_master.equals(other$send_master)) {
                return false;
            }
            String this$tid = this.getTid();
            String other$tid = other.getTid();
            if (this$tid == null ? other$tid != null : !this$tid.equals(other$tid)) {
                return false;
            }
            String this$name_color = this.getName_color();
            String other$name_color = other.getName_color();
            if (this$name_color == null ? other$name_color != null : !this$name_color.equals(other$name_color)) {
                return false;
            }
            MedalInfo this$medal_info = this.getMedal_info();
            MedalInfo other$medal_info = other.getMedal_info();
            if (this$medal_info == null ? other$medal_info != null : !((Object)this$medal_info).equals(other$medal_info)) {
                return false;
            }
            JsonNode this$blind_gift = this.getBlind_gift();
            JsonNode other$blind_gift = other.getBlind_gift();
            if (this$blind_gift == null ? other$blind_gift != null : !this$blind_gift.equals(other$blind_gift)) {
                return false;
            }
            Receive_user_info this$receive_user_info = this.getReceive_user_info();
            Receive_user_info other$receive_user_info = other.getReceive_user_info();
            if (this$receive_user_info == null ? other$receive_user_info != null : !((Object)this$receive_user_info).equals(other$receive_user_info)) {
                return false;
            }
            Bag_gift this$bag_gift = this.getBag_gift();
            Bag_gift other$bag_gift = other.getBag_gift();
            if (this$bag_gift == null ? other$bag_gift != null : !((Object)this$bag_gift).equals(other$bag_gift)) {
                return false;
            }
            Map<String, JsonNode> this$unknownProperties = this.getUnknownProperties();
            Map<String, JsonNode> other$unknownProperties = other.getUnknownProperties();
            return !(this$unknownProperties == null ? other$unknownProperties != null : !((Object)this$unknownProperties).equals(other$unknownProperties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDraw();
            result = result * 59 + this.getGold();
            result = result * 59 + this.getSilver();
            result = result * 59 + this.getNum();
            result = result * 59 + this.getTotal_coin();
            result = result * 59 + this.getEffect();
            result = result * 59 + this.getBroadcast_id();
            result = result * 59 + this.getCrit_prob();
            result = result * 59 + this.getGuard_level();
            long $rcost = this.getRcost();
            result = result * 59 + (int)($rcost >>> 32 ^ $rcost);
            long $uid = this.getUid();
            result = result * 59 + (int)($uid >>> 32 ^ $uid);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            result = result * 59 + this.getGiftId();
            result = result * 59 + this.getGiftType();
            result = result * 59 + this.get_super();
            result = result * 59 + this.getSuper_gift_num();
            result = result * 59 + this.getSuper_batch_gift_num();
            result = result * 59 + this.getRemain();
            result = result * 59 + this.getDiscount_price();
            result = result * 59 + this.getPrice();
            result = result * 59 + (this.is_first() ? 79 : 97);
            result = result * 59 + this.getDemarcation();
            result = result * 59 + this.getCombo_stay_time();
            result = result * 59 + this.getCombo_total_coin();
            result = result * 59 + this.getEffect_block();
            result = result * 59 + this.getIs_special_batch();
            result = result * 59 + this.getCombo_resources_id();
            result = result * 59 + this.getMagnification();
            result = result * 59 + this.getSvga_block();
            result = result * 59 + this.getFloat_sc_resource_id();
            result = result * 59 + (this.is_switch() ? 79 : 97);
            result = result * 59 + this.getFace_effect_type();
            result = result * 59 + this.getFace_effect_id();
            result = result * 59 + (this.is_naming() ? 79 : 97);
            result = result * 59 + (this.is_join_receiver() ? 79 : 97);
            result = result * 59 + this.getWealth_level();
            String $beatId = this.getBeatId();
            result = result * 59 + ($beatId == null ? 43 : $beatId.hashCode());
            String $biz_source = this.getBiz_source();
            result = result * 59 + ($biz_source == null ? 43 : $biz_source.hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $coin_type = this.getCoin_type();
            result = result * 59 + ($coin_type == null ? 43 : $coin_type.hashCode());
            String $uname = this.getUname();
            result = result * 59 + ($uname == null ? 43 : $uname.hashCode());
            String $face = this.getFace();
            result = result * 59 + ($face == null ? 43 : $face.hashCode());
            String $batch_combo_id = this.getBatch_combo_id();
            result = result * 59 + ($batch_combo_id == null ? 43 : $batch_combo_id.hashCode());
            String $rnd = this.getRnd();
            result = result * 59 + ($rnd == null ? 43 : $rnd.hashCode());
            String $giftName = this.getGiftName();
            result = result * 59 + ($giftName == null ? 43 : $giftName.hashCode());
            String $original_gift_name = this.getOriginal_gift_name();
            result = result * 59 + ($original_gift_name == null ? 43 : $original_gift_name.hashCode());
            Combo_send $combo_send = this.getCombo_send();
            result = result * 59 + ($combo_send == null ? 43 : ((Object)$combo_send).hashCode());
            Batch_combo_send $batch_combo_send = this.getBatch_combo_send();
            result = result * 59 + ($batch_combo_send == null ? 43 : ((Object)$batch_combo_send).hashCode());
            String $tag_image = this.getTag_image();
            result = result * 59 + ($tag_image == null ? 43 : $tag_image.hashCode());
            String $top_list = this.getTop_list();
            result = result * 59 + ($top_list == null ? 43 : $top_list.hashCode());
            String $send_master = this.getSend_master();
            result = result * 59 + ($send_master == null ? 43 : $send_master.hashCode());
            String $tid = this.getTid();
            result = result * 59 + ($tid == null ? 43 : $tid.hashCode());
            String $name_color = this.getName_color();
            result = result * 59 + ($name_color == null ? 43 : $name_color.hashCode());
            MedalInfo $medal_info = this.getMedal_info();
            result = result * 59 + ($medal_info == null ? 43 : ((Object)$medal_info).hashCode());
            JsonNode $blind_gift = this.getBlind_gift();
            result = result * 59 + ($blind_gift == null ? 43 : $blind_gift.hashCode());
            Receive_user_info $receive_user_info = this.getReceive_user_info();
            result = result * 59 + ($receive_user_info == null ? 43 : ((Object)$receive_user_info).hashCode());
            Bag_gift $bag_gift = this.getBag_gift();
            result = result * 59 + ($bag_gift == null ? 43 : ((Object)$bag_gift).hashCode());
            Map<String, JsonNode> $unknownProperties = this.getUnknownProperties();
            result = result * 59 + ($unknownProperties == null ? 43 : ((Object)$unknownProperties).hashCode());
            return result;
        }

        public String toString() {
            return "SendGiftMsg.Data(draw=" + this.getDraw() + ", gold=" + this.getGold() + ", silver=" + this.getSilver() + ", num=" + this.getNum() + ", total_coin=" + this.getTotal_coin() + ", effect=" + this.getEffect() + ", broadcast_id=" + this.getBroadcast_id() + ", crit_prob=" + this.getCrit_prob() + ", guard_level=" + this.getGuard_level() + ", rcost=" + this.getRcost() + ", uid=" + this.getUid() + ", timestamp=" + this.getTimestamp() + ", giftId=" + this.getGiftId() + ", giftType=" + this.getGiftType() + ", _super=" + this.get_super() + ", super_gift_num=" + this.getSuper_gift_num() + ", super_batch_gift_num=" + this.getSuper_batch_gift_num() + ", remain=" + this.getRemain() + ", discount_price=" + this.getDiscount_price() + ", price=" + this.getPrice() + ", beatId=" + this.getBeatId() + ", biz_source=" + this.getBiz_source() + ", action=" + this.getAction() + ", coin_type=" + this.getCoin_type() + ", uname=" + this.getUname() + ", face=" + this.getFace() + ", batch_combo_id=" + this.getBatch_combo_id() + ", rnd=" + this.getRnd() + ", giftName=" + this.getGiftName() + ", original_gift_name=" + this.getOriginal_gift_name() + ", combo_send=" + this.getCombo_send() + ", batch_combo_send=" + this.getBatch_combo_send() + ", tag_image=" + this.getTag_image() + ", top_list=" + this.getTop_list() + ", send_master=" + this.getSend_master() + ", is_first=" + this.is_first() + ", demarcation=" + this.getDemarcation() + ", combo_stay_time=" + this.getCombo_stay_time() + ", combo_total_coin=" + this.getCombo_total_coin() + ", tid=" + this.getTid() + ", effect_block=" + this.getEffect_block() + ", is_special_batch=" + this.getIs_special_batch() + ", combo_resources_id=" + this.getCombo_resources_id() + ", magnification=" + this.getMagnification() + ", name_color=" + this.getName_color() + ", medal_info=" + this.getMedal_info() + ", svga_block=" + this.getSvga_block() + ", blind_gift=" + this.getBlind_gift() + ", float_sc_resource_id=" + this.getFloat_sc_resource_id() + ", _switch=" + this.is_switch() + ", face_effect_type=" + this.getFace_effect_type() + ", face_effect_id=" + this.getFace_effect_id() + ", is_naming=" + this.is_naming() + ", receive_user_info=" + this.getReceive_user_info() + ", is_join_receiver=" + this.is_join_receiver() + ", bag_gift=" + this.getBag_gift() + ", wealth_level=" + this.getWealth_level() + ", unknownProperties=" + this.getUnknownProperties() + ")";
        }
    }

    public static class Receive_user_info {
        private String uname;
        private long uid;
        private final Map<String, JsonNode> unknownProperties = new HashMap<String, JsonNode>();

        @JsonAnyGetter
        public Map<String, JsonNode> getUnknownProperties() {
            return this.unknownProperties;
        }

        @JsonAnySetter
        public void setOther(String key, JsonNode value) {
            this.unknownProperties.put(key, value);
        }

        public String getUname() {
            return this.uname;
        }

        public long getUid() {
            return this.uid;
        }

        public void setUname(String uname) {
            this.uname = uname;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Receive_user_info)) {
                return false;
            }
            Receive_user_info other = (Receive_user_info)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUid() != other.getUid()) {
                return false;
            }
            String this$uname = this.getUname();
            String other$uname = other.getUname();
            if (this$uname == null ? other$uname != null : !this$uname.equals(other$uname)) {
                return false;
            }
            Map<String, JsonNode> this$unknownProperties = this.getUnknownProperties();
            Map<String, JsonNode> other$unknownProperties = other.getUnknownProperties();
            return !(this$unknownProperties == null ? other$unknownProperties != null : !((Object)this$unknownProperties).equals(other$unknownProperties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Receive_user_info;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $uid = this.getUid();
            result = result * 59 + (int)($uid >>> 32 ^ $uid);
            String $uname = this.getUname();
            result = result * 59 + ($uname == null ? 43 : $uname.hashCode());
            Map<String, JsonNode> $unknownProperties = this.getUnknownProperties();
            result = result * 59 + ($unknownProperties == null ? 43 : ((Object)$unknownProperties).hashCode());
            return result;
        }

        public String toString() {
            return "SendGiftMsg.Receive_user_info(uname=" + this.getUname() + ", uid=" + this.getUid() + ", unknownProperties=" + this.getUnknownProperties() + ")";
        }
    }

    public static class Bag_gift {
        private int show_price;
        private int price_for_show;
        private final Map<String, JsonNode> unknownProperties = new HashMap<String, JsonNode>();

        @JsonAnyGetter
        public Map<String, JsonNode> getUnknownProperties() {
            return this.unknownProperties;
        }

        @JsonAnySetter
        public void setOther(String key, JsonNode value) {
            this.unknownProperties.put(key, value);
        }

        public int getShow_price() {
            return this.show_price;
        }

        public int getPrice_for_show() {
            return this.price_for_show;
        }

        public void setShow_price(int show_price) {
            this.show_price = show_price;
        }

        public void setPrice_for_show(int price_for_show) {
            this.price_for_show = price_for_show;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bag_gift)) {
                return false;
            }
            Bag_gift other = (Bag_gift)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getShow_price() != other.getShow_price()) {
                return false;
            }
            if (this.getPrice_for_show() != other.getPrice_for_show()) {
                return false;
            }
            Map<String, JsonNode> this$unknownProperties = this.getUnknownProperties();
            Map<String, JsonNode> other$unknownProperties = other.getUnknownProperties();
            return !(this$unknownProperties == null ? other$unknownProperties != null : !((Object)this$unknownProperties).equals(other$unknownProperties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Bag_gift;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShow_price();
            result = result * 59 + this.getPrice_for_show();
            Map<String, JsonNode> $unknownProperties = this.getUnknownProperties();
            result = result * 59 + ($unknownProperties == null ? 43 : ((Object)$unknownProperties).hashCode());
            return result;
        }

        public String toString() {
            return "SendGiftMsg.Bag_gift(show_price=" + this.getShow_price() + ", price_for_show=" + this.getPrice_for_show() + ", unknownProperties=" + this.getUnknownProperties() + ")";
        }
    }

    public static class Batch_combo_send {
        private long uid;
        private int gift_num;
        private int batch_combo_num;
        private int gift_id;
        private String batch_combo_id;
        private String gift_name;
        private String action;
        private String uname;
        private String send_master;
        private JsonNode blind_gift;
        private final Map<String, JsonNode> unknownProperties = new HashMap<String, JsonNode>();

        @JsonAnyGetter
        public Map<String, JsonNode> getUnknownProperties() {
            return this.unknownProperties;
        }

        @JsonAnySetter
        public void setOther(String key, JsonNode value) {
            this.unknownProperties.put(key, value);
        }

        public long getUid() {
            return this.uid;
        }

        public int getGift_num() {
            return this.gift_num;
        }

        public int getBatch_combo_num() {
            return this.batch_combo_num;
        }

        public int getGift_id() {
            return this.gift_id;
        }

        public String getBatch_combo_id() {
            return this.batch_combo_id;
        }

        public String getGift_name() {
            return this.gift_name;
        }

        public String getAction() {
            return this.action;
        }

        public String getUname() {
            return this.uname;
        }

        public String getSend_master() {
            return this.send_master;
        }

        public JsonNode getBlind_gift() {
            return this.blind_gift;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public void setGift_num(int gift_num) {
            this.gift_num = gift_num;
        }

        public void setBatch_combo_num(int batch_combo_num) {
            this.batch_combo_num = batch_combo_num;
        }

        public void setGift_id(int gift_id) {
            this.gift_id = gift_id;
        }

        public void setBatch_combo_id(String batch_combo_id) {
            this.batch_combo_id = batch_combo_id;
        }

        public void setGift_name(String gift_name) {
            this.gift_name = gift_name;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void setUname(String uname) {
            this.uname = uname;
        }

        public void setSend_master(String send_master) {
            this.send_master = send_master;
        }

        public void setBlind_gift(JsonNode blind_gift) {
            this.blind_gift = blind_gift;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Batch_combo_send)) {
                return false;
            }
            Batch_combo_send other = (Batch_combo_send)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUid() != other.getUid()) {
                return false;
            }
            if (this.getGift_num() != other.getGift_num()) {
                return false;
            }
            if (this.getBatch_combo_num() != other.getBatch_combo_num()) {
                return false;
            }
            if (this.getGift_id() != other.getGift_id()) {
                return false;
            }
            String this$batch_combo_id = this.getBatch_combo_id();
            String other$batch_combo_id = other.getBatch_combo_id();
            if (this$batch_combo_id == null ? other$batch_combo_id != null : !this$batch_combo_id.equals(other$batch_combo_id)) {
                return false;
            }
            String this$gift_name = this.getGift_name();
            String other$gift_name = other.getGift_name();
            if (this$gift_name == null ? other$gift_name != null : !this$gift_name.equals(other$gift_name)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$uname = this.getUname();
            String other$uname = other.getUname();
            if (this$uname == null ? other$uname != null : !this$uname.equals(other$uname)) {
                return false;
            }
            String this$send_master = this.getSend_master();
            String other$send_master = other.getSend_master();
            if (this$send_master == null ? other$send_master != null : !this$send_master.equals(other$send_master)) {
                return false;
            }
            JsonNode this$blind_gift = this.getBlind_gift();
            JsonNode other$blind_gift = other.getBlind_gift();
            if (this$blind_gift == null ? other$blind_gift != null : !this$blind_gift.equals(other$blind_gift)) {
                return false;
            }
            Map<String, JsonNode> this$unknownProperties = this.getUnknownProperties();
            Map<String, JsonNode> other$unknownProperties = other.getUnknownProperties();
            return !(this$unknownProperties == null ? other$unknownProperties != null : !((Object)this$unknownProperties).equals(other$unknownProperties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Batch_combo_send;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $uid = this.getUid();
            result = result * 59 + (int)($uid >>> 32 ^ $uid);
            result = result * 59 + this.getGift_num();
            result = result * 59 + this.getBatch_combo_num();
            result = result * 59 + this.getGift_id();
            String $batch_combo_id = this.getBatch_combo_id();
            result = result * 59 + ($batch_combo_id == null ? 43 : $batch_combo_id.hashCode());
            String $gift_name = this.getGift_name();
            result = result * 59 + ($gift_name == null ? 43 : $gift_name.hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $uname = this.getUname();
            result = result * 59 + ($uname == null ? 43 : $uname.hashCode());
            String $send_master = this.getSend_master();
            result = result * 59 + ($send_master == null ? 43 : $send_master.hashCode());
            JsonNode $blind_gift = this.getBlind_gift();
            result = result * 59 + ($blind_gift == null ? 43 : $blind_gift.hashCode());
            Map<String, JsonNode> $unknownProperties = this.getUnknownProperties();
            result = result * 59 + ($unknownProperties == null ? 43 : ((Object)$unknownProperties).hashCode());
            return result;
        }

        public String toString() {
            return "SendGiftMsg.Batch_combo_send(uid=" + this.getUid() + ", gift_num=" + this.getGift_num() + ", batch_combo_num=" + this.getBatch_combo_num() + ", gift_id=" + this.getGift_id() + ", batch_combo_id=" + this.getBatch_combo_id() + ", gift_name=" + this.getGift_name() + ", action=" + this.getAction() + ", uname=" + this.getUname() + ", send_master=" + this.getSend_master() + ", blind_gift=" + this.getBlind_gift() + ", unknownProperties=" + this.getUnknownProperties() + ")";
        }
    }

    public static class Combo_send {
        private long uid;
        private int gift_num;
        private int combo_num;
        private int gift_id;
        private String combo_id;
        private String gift_name;
        private String action;
        private String uname;
        private String send_master;
        private final Map<String, JsonNode> unknownProperties = new HashMap<String, JsonNode>();

        @JsonAnyGetter
        public Map<String, JsonNode> getUnknownProperties() {
            return this.unknownProperties;
        }

        @JsonAnySetter
        public void setOther(String key, JsonNode value) {
            this.unknownProperties.put(key, value);
        }

        public long getUid() {
            return this.uid;
        }

        public int getGift_num() {
            return this.gift_num;
        }

        public int getCombo_num() {
            return this.combo_num;
        }

        public int getGift_id() {
            return this.gift_id;
        }

        public String getCombo_id() {
            return this.combo_id;
        }

        public String getGift_name() {
            return this.gift_name;
        }

        public String getAction() {
            return this.action;
        }

        public String getUname() {
            return this.uname;
        }

        public String getSend_master() {
            return this.send_master;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public void setGift_num(int gift_num) {
            this.gift_num = gift_num;
        }

        public void setCombo_num(int combo_num) {
            this.combo_num = combo_num;
        }

        public void setGift_id(int gift_id) {
            this.gift_id = gift_id;
        }

        public void setCombo_id(String combo_id) {
            this.combo_id = combo_id;
        }

        public void setGift_name(String gift_name) {
            this.gift_name = gift_name;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void setUname(String uname) {
            this.uname = uname;
        }

        public void setSend_master(String send_master) {
            this.send_master = send_master;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Combo_send)) {
                return false;
            }
            Combo_send other = (Combo_send)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUid() != other.getUid()) {
                return false;
            }
            if (this.getGift_num() != other.getGift_num()) {
                return false;
            }
            if (this.getCombo_num() != other.getCombo_num()) {
                return false;
            }
            if (this.getGift_id() != other.getGift_id()) {
                return false;
            }
            String this$combo_id = this.getCombo_id();
            String other$combo_id = other.getCombo_id();
            if (this$combo_id == null ? other$combo_id != null : !this$combo_id.equals(other$combo_id)) {
                return false;
            }
            String this$gift_name = this.getGift_name();
            String other$gift_name = other.getGift_name();
            if (this$gift_name == null ? other$gift_name != null : !this$gift_name.equals(other$gift_name)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$uname = this.getUname();
            String other$uname = other.getUname();
            if (this$uname == null ? other$uname != null : !this$uname.equals(other$uname)) {
                return false;
            }
            String this$send_master = this.getSend_master();
            String other$send_master = other.getSend_master();
            if (this$send_master == null ? other$send_master != null : !this$send_master.equals(other$send_master)) {
                return false;
            }
            Map<String, JsonNode> this$unknownProperties = this.getUnknownProperties();
            Map<String, JsonNode> other$unknownProperties = other.getUnknownProperties();
            return !(this$unknownProperties == null ? other$unknownProperties != null : !((Object)this$unknownProperties).equals(other$unknownProperties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Combo_send;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $uid = this.getUid();
            result = result * 59 + (int)($uid >>> 32 ^ $uid);
            result = result * 59 + this.getGift_num();
            result = result * 59 + this.getCombo_num();
            result = result * 59 + this.getGift_id();
            String $combo_id = this.getCombo_id();
            result = result * 59 + ($combo_id == null ? 43 : $combo_id.hashCode());
            String $gift_name = this.getGift_name();
            result = result * 59 + ($gift_name == null ? 43 : $gift_name.hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $uname = this.getUname();
            result = result * 59 + ($uname == null ? 43 : $uname.hashCode());
            String $send_master = this.getSend_master();
            result = result * 59 + ($send_master == null ? 43 : $send_master.hashCode());
            Map<String, JsonNode> $unknownProperties = this.getUnknownProperties();
            result = result * 59 + ($unknownProperties == null ? 43 : ((Object)$unknownProperties).hashCode());
            return result;
        }

        public String toString() {
            return "SendGiftMsg.Combo_send(uid=" + this.getUid() + ", gift_num=" + this.getGift_num() + ", combo_num=" + this.getCombo_num() + ", gift_id=" + this.getGift_id() + ", combo_id=" + this.getCombo_id() + ", gift_name=" + this.getGift_name() + ", action=" + this.getAction() + ", uname=" + this.getUname() + ", send_master=" + this.getSend_master() + ", unknownProperties=" + this.getUnknownProperties() + ")";
        }
    }
}

