/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.api;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.api.request.BilibiliSendMsgRequest;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;

public class BilibiliApis {
    private static final Logger log = LoggerFactory.getLogger(BilibiliApis.class);
    public static final TimedCache<Long, String> giftImgCache = new TimedCache(TimeUnit.DAYS.toMillis(1L));
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String KEY_COOKIE_CSRF = "bili_jct";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode roomInit(long roomId, String cookie) {
        HttpResponse response = BilibiliApis.createGetRequest("https://api.live.bilibili.com/room/v1/Room/room_init?id=" + roomId, cookie).execute();
        try {
            JsonNode jsonNode = BilibiliApis.responseInterceptor(response.body());
            return jsonNode;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode getDanmuInfo(long roomId, int type, String cookie) {
        HttpResponse response = BilibiliApis.createGetRequest("https://api.live.bilibili.com/xlive/web-room/v1/index/getDanmuInfo?id=" + roomId + "&type=" + type, cookie).execute();
        try {
            JsonNode jsonNode = BilibiliApis.responseInterceptor(response.body());
            return jsonNode;
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    public static String getGiftImgById(long giftId) {
        if (giftImgCache.containsKey((Object)giftId)) {
            return (String)giftImgCache.get((Object)giftId);
        }
        String img = null;
        boolean find = false;
        for (String line : FileUtil.readLines((URL)ResourceUtil.getResource((String)"css/gift_background.css"), (Charset)StandardCharsets.UTF_8)) {
            if (find) {
                img = line.substring(26, 101);
                giftImgCache.put((Object)giftId, (Object)img);
                break;
            }
            if (!line.startsWith(".gift-" + giftId + "-")) continue;
            find = true;
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMsg(BilibiliSendMsgRequest request, String cookie) {
        if (StrUtil.isBlank((CharSequence)cookie)) {
            throw new BaseException("\u53d1\u9001\u5f39\u5e55\u63a5\u53e3cookie\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map stringObjectMap = BeanUtil.beanToMap((Object)request, (String[])new String[0]);
        HttpResponse execute = HttpUtil.createPost((String)"https://api.live.bilibili.com/msg/send").cookie(cookie).form(stringObjectMap).execute();
        try {
            BilibiliApis.responseInterceptor(execute.body());
        }
        finally {
            if (Collections.singletonList(execute).get(0) != null) {
                execute.close();
            }
        }
    }

    public static void sendMsg(String msg, long roomId, String cookie) {
        JsonNode data = BilibiliApis.roomInit(roomId, cookie);
        String realRoomId = data.get("room_id").asText();
        String biliJct = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_COOKIE_CSRF, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570bili_jct");
        });
        BilibiliSendMsgRequest request = new BilibiliSendMsgRequest(msg, StrUtil.toString((Object)ZonedDateTime.now(ZoneId.of("Asia/Shanghai")).toEpochSecond()), realRoomId, biliJct, biliJct);
        BilibiliApis.sendMsg(request, cookie);
    }

    public static HttpRequest createGetRequest(String url, String cookies) {
        return HttpUtil.createGet((String)url).cookie(cookies);
    }

    private static JsonNode responseInterceptor(String responseString) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseString);
            int code = jsonNode.get("code").asInt();
            if (code == 0) {
                return jsonNode.get("data");
            }
            throw new BaseException(jsonNode.get("message").asText());
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
    }
}

