/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.client;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.api.BilibiliApis;
import tech.ordinaryroad.live.chat.client.bilibili.config.BilibiliLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.bilibili.constant.BilibiliCmdEnum;
import tech.ordinaryroad.live.chat.client.bilibili.listener.IBilibiliConnectionListener;
import tech.ordinaryroad.live.chat.client.bilibili.listener.IBilibiliMsgListener;
import tech.ordinaryroad.live.chat.client.bilibili.msg.base.IBilibiliMsg;
import tech.ordinaryroad.live.chat.client.bilibili.netty.handler.BilibiliBinaryFrameHandler;
import tech.ordinaryroad.live.chat.client.bilibili.netty.handler.BilibiliConnectionHandler;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.config.BaseNettyClientConfig;

public class BilibiliLiveChatClient
extends BaseNettyClient<BilibiliLiveChatClientConfig, BilibiliCmdEnum, IBilibiliMsg, IBilibiliMsgListener, BilibiliConnectionHandler, BilibiliBinaryFrameHandler> {
    private static final Logger log = LoggerFactory.getLogger(BilibiliLiveChatClient.class);

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config, List<IBilibiliMsgListener> msgListeners, IBilibiliConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListeners(msgListeners);
        this.init();
    }

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config, IBilibiliMsgListener msgListener, IBilibiliConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListener(msgListener);
        this.init();
    }

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config, IBilibiliMsgListener msgListener, IBilibiliConnectionListener connectionListener) {
        this(config, msgListener, connectionListener, (EventLoopGroup)new NioEventLoopGroup());
    }

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config, IBilibiliMsgListener msgListener) {
        this(config, msgListener, null, (EventLoopGroup)new NioEventLoopGroup());
    }

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config) {
        this(config, null);
    }

    public BilibiliConnectionHandler initConnectionHandler(IBaseConnectionListener<BilibiliConnectionHandler> clientConnectionListener) {
        return new BilibiliConnectionHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.getWebsocketUri(), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders(), (int)((BilibiliLiveChatClientConfig)this.getConfig()).getMaxFramePayloadLength()), this, clientConnectionListener);
    }

    public BilibiliBinaryFrameHandler initBinaryFrameHandler() {
        return new BilibiliBinaryFrameHandler((List<IBilibiliMsgListener>)this.msgListeners, this);
    }

    public void sendDanmu(Object danmu, Runnable success, Consumer<Throwable> failed) {
        block12: {
            if (!this.checkCanSendDanmu()) {
                return;
            }
            if (danmu instanceof String) {
                String msg = (String)danmu;
                try {
                    boolean sendSuccess;
                    block11: {
                        if (log.isDebugEnabled()) {
                            log.debug("{} bilibili\u53d1\u9001\u5f39\u5e55 {}", (Object)((BilibiliLiveChatClientConfig)this.getConfig()).getRoomId(), danmu);
                        }
                        sendSuccess = false;
                        try {
                            BilibiliApis.sendMsg(msg, ((BilibiliLiveChatClientConfig)this.getConfig()).getRoomId(), ((BilibiliLiveChatClientConfig)this.getConfig()).getCookie());
                            sendSuccess = true;
                        }
                        catch (Exception e) {
                            log.error("bilibili\u5f39\u5e55\u53d1\u9001\u5931\u8d25", e.getCause());
                            if (failed == null) break block11;
                            failed.accept(e.getCause());
                        }
                    }
                    if (!sendSuccess) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("bilibili\u5f39\u5e55\u53d1\u9001\u6210\u529f {}", danmu);
                    }
                    if (success != null) {
                        success.run();
                    }
                    this.finishSendDanmu();
                }
                catch (Exception e) {
                    log.error("bilibili\u5f39\u5e55\u53d1\u9001\u5931\u8d25", e.getCause());
                    if (failed != null) {
                        failed.accept(e.getCause());
                    }
                    break block12;
                }
            }
            super.sendDanmu(danmu, success, failed);
        }
    }
}

