/*
 * Decompiled with CFR 0.152.
 */
package jsonrpclib.validation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jsonrpclib.JsonRpcNotificationTrait;
import jsonrpclib.JsonRpcRequestTrait;
import jsonrpclib.JsonRpcTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public class UniqueJsonRpcMethodNamesValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.getServiceShapesWithTrait(JsonRpcTrait.class).stream().flatMap(serviceShape -> this.validateService((ServiceShape)serviceShape, model)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateService(ServiceShape serviceShape, Model model) {
        Map map = serviceShape.getAllOperations().stream().map(arg_0 -> ((Model)model).expectShape(arg_0)).map(shape -> (OperationShape)shape.asOperationShape().orElseThrow()).flatMap(operationShape -> this.getJsonRpcMethodName((OperationShape)operationShape).map(string -> Map.entry(string, operationShape)).stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        return map.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).flatMap(entry -> ((List)entry.getValue()).stream().map(operationShape -> this.error((Shape)serviceShape, String.format("Duplicate JSON-RPC method name `%s` in service `%s`. It is used by: %s", entry.getKey(), serviceShape.getId(), ((List)entry.getValue()).stream().map(Shape::getId).map(Object::toString).collect(Collectors.joining(", "))))));
    }

    private Optional<String> getJsonRpcMethodName(OperationShape operationShape) {
        return operationShape.getTrait(JsonRpcRequestTrait.class).map(StringTrait::getValue).or(() -> operationShape.getTrait(JsonRpcNotificationTrait.class).map(StringTrait::getValue));
    }
}

