/*
 * Decompiled with CFR 0.152.
 */
package jsonrpclib.validation;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jsonrpclib.JsonRpcNotificationTrait;
import jsonrpclib.JsonRpcRequestTrait;
import jsonrpclib.JsonRpcTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public class JsonRpcOperationValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.getServiceShapesWithTrait(JsonRpcTrait.class).stream().flatMap(serviceShape -> this.validateService(model, (ServiceShape)serviceShape)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateService(Model model, ServiceShape serviceShape) {
        return serviceShape.getAllOperations().stream().map(arg_0 -> ((Model)model).expectShape(arg_0)).filter(shape -> !this.hasJsonRpcMethod((Shape)shape)).map(shape -> this.error((Shape)shape, String.format("Operation is part of service `%s` marked with @jsonRpc but is missing @jsonRpcRequest or @jsonRpcNotification.", serviceShape.getId())));
    }

    private boolean hasJsonRpcMethod(Shape shape) {
        return shape.hasTrait(JsonRpcRequestTrait.ID) || shape.hasTrait(JsonRpcNotificationTrait.ID);
    }
}

