/*
 * Decompiled with CFR 0.152.
 */
package jsonrpclib.validation;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jsonrpclib.JsonRpcNotificationTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public class JsonNotificationOutputValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.getShapesWithTrait((ToShapeId)JsonRpcNotificationTrait.ID).stream().flatMap(shape -> {
            ShapeId shapeId = ((OperationShape)shape.asOperationShape().orElseThrow()).getOutputShape();
            Shape shape2 = model.expectShape(shapeId);
            if (shape2.asStructureShape().map(structureShape -> !structureShape.members().isEmpty()).orElse(true).booleanValue()) {
                return Stream.of(this.error((Shape)shape, String.format("Operation marked as @jsonRpcNotification must not return anything, but found `%s`.", shapeId)));
            }
            return Stream.empty();
        }).collect(Collectors.toUnmodifiableList());
    }
}

