/**
 */

package jsonrpclib;

import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyGenerated;
import software.amazon.smithy.utils.ToSmithyBuilder;

/**
 * the JSON-RPC protocol,
 * see https://www.jsonrpc.org/specification
 */
@SmithyGenerated
public final class JsonRpcTrait extends AbstractTrait implements ToSmithyBuilder<JsonRpcTrait> {
    public static final ShapeId ID = ShapeId.from("jsonrpclib#jsonRpc");

    private JsonRpcTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
    }

    @Override
    protected Node createNode() {
        return Node.objectNodeBuilder()
            .sourceLocation(getSourceLocation()).build();
    }

    /**
     * Creates a {@link JsonRpcTrait} from a {@link Node}.
     *
     * @param node Node to create the JsonRpcTrait from.
     * @return Returns the created JsonRpcTrait.
     * @throws ExpectationNotMetException if the given Node is invalid.
     */
    public static JsonRpcTrait fromNode(Node node) {
        Builder builder = builder();
        node.expectObjectNode();
        return builder.build();
    }

    /**
     * Creates a builder used to build a {@link JsonRpcTrait}.
     */
    public SmithyBuilder<JsonRpcTrait> toBuilder() {
        return builder().sourceLocation(getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    /**
     * Builder for {@link JsonRpcTrait}.
     */
    public static final class Builder extends AbstractTraitBuilder<JsonRpcTrait, Builder> {
        private Builder() {}

        @Override
        public JsonRpcTrait build() {
            return new JsonRpcTrait(this);
        }
    }

    public static final class Provider extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            JsonRpcTrait result = JsonRpcTrait.fromNode(value);
            result.setNodeCache(value);
            return result;
        }
    }
}
