/**
 */

package jsonrpclib;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.utils.SmithyGenerated;

/**
 * Identifies an operation that abides by request/response semantics
 * https://www.jsonrpc.org/specification#request_object
 */
@SmithyGenerated
public final class JsonRpcRequestTrait extends StringTrait {
    public static final ShapeId ID = ShapeId.from("jsonrpclib#jsonRpcRequest");

    public JsonRpcRequestTrait(String value) {
        super(ID, value, SourceLocation.NONE);
    }

    public JsonRpcRequestTrait(String value, FromSourceLocation sourceLocation) {
        super(ID, value, sourceLocation);
    }

    public static final class Provider extends StringTrait.Provider<JsonRpcRequestTrait> {
        public Provider() {
            super(ID, JsonRpcRequestTrait::new);
        }
    }
}
