/**
 */

package jsonrpclib;

import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyGenerated;
import software.amazon.smithy.utils.ToSmithyBuilder;

/**
 * Binds a single structure member to the payload of a jsonrpc message.
 * Just like @httpPayload, but for jsonRpc.
 */
@SmithyGenerated
public final class JsonRpcPayloadTrait extends AbstractTrait implements ToSmithyBuilder<JsonRpcPayloadTrait> {
    public static final ShapeId ID = ShapeId.from("jsonrpclib#jsonRpcPayload");

    private JsonRpcPayloadTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
    }

    @Override
    protected Node createNode() {
        return Node.objectNodeBuilder()
            .sourceLocation(getSourceLocation()).build();
    }

    /**
     * Creates a {@link JsonRpcPayloadTrait} from a {@link Node}.
     *
     * @param node Node to create the JsonRpcPayloadTrait from.
     * @return Returns the created JsonRpcPayloadTrait.
     * @throws ExpectationNotMetException if the given Node is invalid.
     */
    public static JsonRpcPayloadTrait fromNode(Node node) {
        Builder builder = builder();
        node.expectObjectNode();
        return builder.build();
    }

    /**
     * Creates a builder used to build a {@link JsonRpcPayloadTrait}.
     */
    public SmithyBuilder<JsonRpcPayloadTrait> toBuilder() {
        return builder().sourceLocation(getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    /**
     * Builder for {@link JsonRpcPayloadTrait}.
     */
    public static final class Builder extends AbstractTraitBuilder<JsonRpcPayloadTrait, Builder> {
        private Builder() {}

        @Override
        public JsonRpcPayloadTrait build() {
            return new JsonRpcPayloadTrait(this);
        }
    }

    public static final class Provider extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            JsonRpcPayloadTrait result = JsonRpcPayloadTrait.fromNode(value);
            result.setNodeCache(value);
            return result;
        }
    }
}
