/**
 */

package jsonrpclib;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.utils.SmithyGenerated;

/**
 * Identifies an operation that abides by fire-and-forget semantics
 * see https://www.jsonrpc.org/specification#notification
 */
@SmithyGenerated
public final class JsonRpcNotificationTrait extends StringTrait {
    public static final ShapeId ID = ShapeId.from("jsonrpclib#jsonRpcNotification");

    public JsonRpcNotificationTrait(String value) {
        super(ID, value, SourceLocation.NONE);
    }

    public JsonRpcNotificationTrait(String value, FromSourceLocation sourceLocation) {
        super(ID, value, sourceLocation);
    }

    public static final class Provider extends StringTrait.Provider<JsonRpcNotificationTrait> {
        public Provider() {
            super(ID, JsonRpcNotificationTrait::new);
        }
    }
}
