/*
 * Decompiled with CFR 0.152.
 */
package jsonrpclib.internals;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import jsonrpclib.ProtocolError;
import jsonrpclib.internals.Constants$;
import jsonrpclib.internals.LSPHeaders;
import jsonrpclib.internals.LSPHeaders$integer$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class LSPHeaders$
implements Serializable {
    public static final LSPHeaders$ MODULE$ = new LSPHeaders$();
    private static volatile boolean bitmap$init$0;

    public Either<ProtocolError.ParseError, LSPHeaders> readNext(InputStream input) {
        boolean keepRunning = true;
        boolean newline = false;
        scala.collection.mutable.StringBuilder headerStringBuilder = null;
        LSPHeaders.Builder headerBuilder = new LSPHeaders.Builder(-1, Constants$.MODULE$.JSON_MIME_TYPE(), StandardCharsets.UTF_8.displayName());
        Object result = null;
        while (keepRunning) {
            int c = input.read();
            if (c == -1) {
                keepRunning = false;
                continue;
            }
            if (c == 10) {
                if (newline) {
                    result = headerBuilder.contentLength() < 0 ? package$.MODULE$.Left().apply((Object)new ProtocolError.ParseError(new StringBuilder(15).append("Missing ").append(Constants$.MODULE$.CONTENT_LENGTH_HEADER()).append(" header").toString())) : package$.MODULE$.Right().apply((Object)new LSPHeaders(headerBuilder.contentLength(), headerBuilder.mimeType(), headerBuilder.charset()));
                    keepRunning = false;
                } else if (headerStringBuilder != null) {
                    this.parseHeader(headerStringBuilder.result(), headerBuilder);
                    headerStringBuilder = null;
                }
                newline = true;
                continue;
            }
            if (c == 13) continue;
            if (headerStringBuilder == null) {
                headerStringBuilder = new scala.collection.mutable.StringBuilder();
            }
            headerStringBuilder.append((char)c);
            newline = false;
        }
        if (result == null) {
            return package$.MODULE$.Left().apply((Object)new ProtocolError.ParseError("Could not parse LSP headers"));
        }
        return result;
    }

    public void write(LSPHeaders x, OutputStream out) {
        DataOutputStream dataOutputStream = new DataOutputStream(out);
        dataOutputStream.write(new StringBuilder(18).append("Content-Length: ").append(x.contentLength()).append("\r\n").toString().getBytes());
        dataOutputStream.write("\r\n".getBytes());
    }

    private void parseHeader(String line, LSPHeaders.Builder headerBuilder) {
        Option option;
        Option<Object> option2;
        String string;
        Option option3;
        String string2 = line;
        if (string2 != null && !(option3 = new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Content-Length: ", ""})).s().unapplySeq(string2)).isEmpty() && option3.get() != null && ((SeqOps)option3.get()).lengthCompare(1) == 0 && (string = (String)((SeqOps)option3.get()).apply(0)) != null && !(option2 = LSPHeaders$integer$.MODULE$.unapply(string)).isEmpty()) {
            int length = BoxesRunTime.unboxToInt((Object)option2.get());
            headerBuilder.contentLength_$eq(length);
            return;
        }
        if (string2 != null && !(option = new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Content-type: ", "; charset=", ""})).s().unapplySeq(string2)).isEmpty() && option.get() != null && ((SeqOps)option.get()).lengthCompare(2) == 0) {
            String mimeType = (String)((SeqOps)option.get()).apply(0);
            String charset = (String)((SeqOps)option.get()).apply(1);
            headerBuilder.mimeType_$eq(mimeType);
            headerBuilder.charset_$eq(charset);
            return;
        }
        throw new MatchError((Object)string2);
    }

    public LSPHeaders apply(int contentLength, String mimeType, String charset) {
        return new LSPHeaders(contentLength, mimeType, charset);
    }

    public Option<Tuple3<Object, String, String>> unapply(LSPHeaders x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.contentLength()), (Object)x$0.mimeType(), (Object)x$0.charset()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LSPHeaders$.class);
    }

    private LSPHeaders$() {
    }
}

