/*
 * Decompiled with CFR 0.152.
 */
package cue4s;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import cue4s.ChangeMode;

class ChangeModeLinux
implements ChangeMode {
    private static ChangeModeLinux INSTANCE;
    private static final int STDIN_FILENO = 0;
    private static final int TCSANOW = 0;
    private static final int ICANON = 2;
    private static final int ECHO = 8;
    private termios oldt = new termios();

    private ChangeModeLinux() {
    }

    public static ChangeModeLinux getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ChangeModeLinux();
        }
        return INSTANCE;
    }

    @Override
    public int getchar() {
        return CLibrary.INSTANCE.getchar();
    }

    @Override
    public void changemode(int n) {
        termios termios2 = new termios();
        if (n == 1) {
            CLibrary.INSTANCE.tcgetattr(0, this.oldt);
            termios2.c_iflag = this.oldt.c_iflag;
            termios2.c_oflag = this.oldt.c_oflag;
            termios2.c_cflag = this.oldt.c_cflag;
            termios2.c_lflag = this.oldt.c_lflag;
            termios2.c_line = this.oldt.c_line;
            termios2.c_cc = this.oldt.c_cc;
            termios2.c_ispeed = this.oldt.c_ispeed;
            termios2.c_ospeed = this.oldt.c_ospeed;
            termios2.c_lflag &= 0xFFFFFFF5;
            CLibrary.INSTANCE.tcsetattr(0, 0, termios2);
        } else {
            CLibrary.INSTANCE.tcsetattr(0, 0, this.oldt);
        }
    }

    @Structure.FieldOrder(value={"c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_line", "c_cc", "c_ispeed", "c_ospeed"})
    public static class termios
    extends Structure {
        public int c_iflag;
        public int c_oflag;
        public int c_cflag;
        public int c_lflag;
        public byte c_line;
        public byte[] c_cc = new byte[32];
        public int c_ispeed;
        public int c_ospeed;
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.load((String)"c", CLibrary.class);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int getchar();
    }
}

