/*
 * Decompiled with CFR 0.152.
 */
package cue4s;

import cue4s.Output;
import cue4s.Output$package$given_AsString_String$;
import cue4s.Terminal;
import cue4s.TracingTerminal$package$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class TracingTerminal
implements Terminal {
    private final Output out;
    private final int WIDTH;
    private final int HEIGHT;
    private int currentHeight;
    private int currentWidth;
    private int currentLine;
    private int currentColumn;
    private boolean cursorHidden;
    private Option saved;
    private char[] INTERNAL;

    public TracingTerminal(Output out) {
        this.out = out;
        this.WIDTH = 120;
        this.HEIGHT = 500;
        this.currentHeight = 0;
        this.currentWidth = 0;
        this.currentLine = 0;
        this.currentColumn = 0;
        this.cursorHidden = false;
        this.saved = Option$.MODULE$.empty();
        this.INTERNAL = (char[])Array$.MODULE$.fill(this.WIDTH() * this.HEIGHT(), TracingTerminal::$init$$$anonfun$1, ClassTag$.MODULE$.apply(Character.TYPE));
    }

    public int WIDTH() {
        return this.WIDTH;
    }

    public int HEIGHT() {
        return this.HEIGHT;
    }

    public int currentHeight() {
        return this.currentHeight;
    }

    public void currentHeight_$eq(int x$1) {
        this.currentHeight = x$1;
    }

    public int currentWidth() {
        return this.currentWidth;
    }

    public void currentWidth_$eq(int x$1) {
        this.currentWidth = x$1;
    }

    public int currentLine() {
        return this.currentLine;
    }

    public void currentLine_$eq(int x$1) {
        this.currentLine = x$1;
    }

    public int currentColumn() {
        return this.currentColumn;
    }

    public void currentColumn_$eq(int x$1) {
        this.currentColumn = x$1;
    }

    public boolean cursorHidden() {
        return this.cursorHidden;
    }

    public void cursorHidden_$eq(boolean x$1) {
        this.cursorHidden = x$1;
    }

    public Option<Tuple2<Object, Object>> saved() {
        return this.saved;
    }

    public void saved_$eq(Option<Tuple2<Object, Object>> x$1) {
        this.saved = x$1;
    }

    public void set(char c, int line, int column) {
        this.INTERNAL()[this.WIDTH() * line + column] = c;
    }

    public int currentIndex() {
        return this.WIDTH() * this.currentLine() + this.currentColumn();
    }

    public char[] INTERNAL() {
        return this.INTERNAL;
    }

    public void INTERNAL_$eq(char[] x$1) {
        this.INTERNAL = x$1;
    }

    public void log(String msg) {
        this.out.logLn(new StringBuilder(22).append("[LINE=").append(this.currentLine()).append(", COL=").append(this.currentColumn()).append(", H=").append(this.currentHeight()).append(", W=").append(this.currentWidth()).append("] ").append(msg).toString(), Output$package$given_AsString_String$.MODULE$);
    }

    public void updateBounds() {
        this.currentWidth_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.currentWidth()), this.currentColumn()));
        this.currentHeight_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.currentHeight()), this.currentLine()));
    }

    @Override
    public TracingTerminal screenClear() {
        this.INTERNAL_$eq((char[])Array$.MODULE$.fill(this.WIDTH() * this.HEIGHT(), TracingTerminal::screenClear$$anonfun$1, ClassTag$.MODULE$.apply(Character.TYPE)));
        return this;
    }

    @Override
    public TracingTerminal movePreviousLine(int n) {
        this.log(new StringBuilder(16).append("Moving ").append(n).append(" lines up").toString());
        this.currentLine_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.currentLine() - n), 0));
        return this;
    }

    @Override
    public TracingTerminal eraseToBeginningOfLine() {
        this.log("Erasing to beginning of line");
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.currentColumn()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)column -> this.set(' ', this.currentLine(), column));
        return this;
    }

    @Override
    public TracingTerminal eraseToEndOfLine() {
        this.log("Erasing to end of line");
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.currentColumn()), this.currentWidth()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)column -> this.set(' ', this.currentLine(), column));
        return this;
    }

    @Override
    public TracingTerminal cursorShow() {
        this.cursorHidden_$eq(true);
        return this;
    }

    @Override
    public TracingTerminal moveHorizontalTo(int column) {
        this.log(new StringBuilder(17).append("Moving to column ").append(column).toString());
        this.currentColumn_$eq(column);
        this.updateBounds();
        return this;
    }

    @Override
    public TracingTerminal eraseEntireScreen() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public TracingTerminal moveToPosition(int row, int column) {
        this.log(new StringBuilder(24).append("Moving to line ").append(row - 1).append(", column ").append(column).toString());
        this.currentLine_$eq(row - 1);
        this.currentColumn_$eq(column - 1);
        this.updateBounds();
        return this;
    }

    @Override
    public TracingTerminal eraseToBeginningOfScreen() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public TracingTerminal eraseEntireLine() {
        this.log("Erasing entire line");
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.currentWidth()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)column -> this.set(' ', this.currentLine(), column));
        return this;
    }

    @Override
    public TracingTerminal moveBack(int n) {
        this.log(new StringBuilder(16).append("Back ").append(n).append(" characters").toString());
        this.currentColumn_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.currentColumn() - n), 0));
        this.updateBounds();
        return this;
    }

    @Override
    public TracingTerminal moveUp(int n) {
        this.log(new StringBuilder(16).append("Moving up ").append(n).append(" lines").toString());
        this.currentLine_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.currentLine() - n), 0));
        this.updateBounds();
        return this;
    }

    @Override
    public TracingTerminal save() {
        this.log("Saving position");
        this.saved_$eq((Option<Tuple2<Object, Object>>)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.currentLine()), (Object)BoxesRunTime.boxToInteger((int)this.currentColumn()))));
        return this;
    }

    @Override
    public TracingTerminal cursorHide() {
        this.cursorHidden_$eq(true);
        return this;
    }

    @Override
    public TracingTerminal moveDown(int n) {
        this.log(new StringBuilder(18).append("Moving down ").append(n).append(" lines").toString());
        this.currentLine_$eq(this.currentLine() + n);
        this.updateBounds();
        return this;
    }

    @Override
    public TracingTerminal eraseToEndOfScreen() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public TracingTerminal moveForward(int n) {
        this.log(new StringBuilder(23).append("Moving forward ").append(n).append(" columns").toString());
        this.currentColumn_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.currentColumn() + n), 0));
        this.updateBounds();
        return this;
    }

    @Override
    public TracingTerminal moveNextLine(int n) {
        this.currentLine_$eq(this.currentLine() + 1);
        this.currentColumn_$eq(0);
        this.updateBounds();
        return this;
    }

    @Override
    public TracingTerminal restore() {
        Tuple2 tuple2;
        Option<Tuple2<Object, Object>> option = this.saved();
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            int line = tuple2._1$mcI$sp();
            int column = tuple2._2$mcI$sp();
            this.log(new StringBuilder(42).append("Restoring cursor location to [LINE=").append(line).append(", COL=").append(column).append("]").toString());
            this.currentLine_$eq(line);
            this.currentColumn_$eq(column);
            return this;
        }
        throw new MatchError(option);
    }

    public String getLine(int i) {
        int start = this.WIDTH() * i;
        Object object = Predef$.MODULE$.charArrayOps(this.INTERNAL());
        return new String((char[])ArrayOps$.MODULE$.slice$extension(object, start, start + this.currentWidth()));
    }

    public Function1<String, BoxedUnit> writer() {
        JProcedure1 & Serializable simpleWriter = (JProcedure1 & Serializable)l -> {
            this.log(new StringBuilder(23).append("Writing single line: `").append((String)l).append("`").toString());
            int newCurrentWidth = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.currentWidth()), this.currentColumn() + l.length());
            if (newCurrentWidth > this.WIDTH()) {
                throw TracingTerminal$package$.MODULE$.todo("line length overflow");
            }
            int start = this.currentIndex();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), l.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                this.INTERNAL()[start$1 + idx] = l.charAt(idx);
            });
            this.currentColumn_$eq(this.currentColumn() + l.length());
            this.currentWidth_$eq(newCurrentWidth);
        };
        JProcedure1 & Serializable multilineWriter = arg_0 -> this.$anonfun$2((Function1)simpleWriter, arg_0);
        return arg_0 -> TracingTerminal.writer$$anonfun$1((Function1)multilineWriter, (Function1)simpleWriter, arg_0);
    }

    public String get() {
        scala.collection.mutable.StringBuilder cur = new scala.collection.mutable.StringBuilder();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.currentHeight()).foreach((Function1 & Serializable)line -> this.get$$anonfun$1(cur, BoxesRunTime.unboxToInt((Object)line)));
        return cur.result();
    }

    public String getPretty() {
        scala.collection.mutable.StringBuilder cur = new scala.collection.mutable.StringBuilder();
        String raw = this.get();
        int maxLineLength = BoxesRunTime.unboxToInt((Object)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(raw)).map((Function1 & Serializable)_$2 -> _$2.length()).maxOption((Ordering)Ordering.Int$.MODULE$).getOrElse(TracingTerminal::$anonfun$4));
        cur.append("\u250f");
        cur.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), maxLineLength));
        cur.append("\u2513\n");
        StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(raw)).zipWithIndex().foreach((Function1 & Serializable)x$1 -> {
            scala.collection.mutable.StringBuilder stringBuilder;
            String string = (String)x$1._1();
            int n = BoxesRunTime.unboxToInt((Object)x$1._2());
            cur.append("\u2503");
            if (n == this.currentLine()) {
                Tuple2 tuple2 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(string), this.currentColumn());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String pre = (String)tuple2._1();
                String after = (String)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)pre, (Object)after);
                String pre2 = (String)tuple22._1();
                String after2 = (String)tuple22._2();
                cur.append(pre2);
                if (this.currentColumn() < this.currentWidth() && !this.cursorHidden()) {
                    cur.append("\u2592");
                    stringBuilder = cur.append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(after2), 1));
                } else {
                    stringBuilder = cur.append(after2);
                }
            } else {
                stringBuilder = cur.append(string);
            }
            cur.append("\u2503");
            return cur.append("\n");
        });
        cur.append("\u2517");
        cur.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), maxLineLength));
        cur.append("\u251b");
        return cur.result();
    }

    private static final char $init$$$anonfun$1() {
        return ' ';
    }

    private static final char screenClear$$anonfun$1() {
        return ' ';
    }

    private final /* synthetic */ void $anonfun$2(Function1 simpleWriter$1, String l) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])l.split("\n", -1));
        List lines = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object)).toList();
        this.log(new StringBuilder(24).append("Writing multiple lines: ").append(lines.map((Function1 & Serializable)_$1 -> (String)_$1._1()).mkString("`", "`, `", "`")).toString());
        lines.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            int n = BoxesRunTime.unboxToInt((Object)x$1._2());
            simpleWriter$1.apply((Object)string);
            if (n != lines.length() - 1) {
                this.currentColumn_$eq(0);
                this.currentLine_$eq(this.currentLine() + 1);
            }
            this.currentHeight_$eq(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.currentHeight()), this.currentLine()));
        });
    }

    private static final /* synthetic */ void writer$$anonfun$1(Function1 multilineWriter$1, Function1 simpleWriter$3, String l) {
        if (l.contains("\n")) {
            multilineWriter$1.apply((Object)l);
            return;
        }
        simpleWriter$3.apply((Object)l);
    }

    private final /* synthetic */ scala.collection.mutable.StringBuilder get$$anonfun$1(scala.collection.mutable.StringBuilder cur$1, int line) {
        return cur$1.append(new StringBuilder(1).append(this.getLine(line)).append("\n").toString());
    }

    private static final int $anonfun$4() {
        return 1;
    }
}

