/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.mybatis.encrypt.utils;

import java.util.regex.Pattern;

public class DesensitizeUtil {
    public static final String PHONE_REG = "^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|166|198|199|(147))\\d{8}$";
    public static final String EMAIL_REG = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    public static final String BANK_CARD_NUMBER = "^\\d{16}|\\d{19}$";
    public static final String ID_CARD = "^\\d{15}|(\\d{17}[0-9,x,X])$";

    public static String replaceSecretInfo(String info, String fillValue) {
        String result;
        if (info.isEmpty()) {
            return "";
        }
        int infoLength = info.length();
        if (infoLength == 1) {
            result = "*";
        } else if (infoLength == 2) {
            result = info.substring(0, 1) + "*";
        } else {
            double tempNum = (double)infoLength / 3.0;
            int num1 = (int)Math.floor(tempNum);
            int num2 = (int)Math.ceil(tempNum);
            int num3 = infoLength - num1 - num2;
            String star = "";
            for (int i = 0; i < num2; ++i) {
                star = star.concat(fillValue);
            }
            String regex = "(.{" + num1 + "})(.{" + num2 + "})(.{" + num3 + "})";
            String replacement = "$1" + star + "$3";
            result = info.replaceAll(regex, replacement);
        }
        return result;
    }

    public static String encryptBankAcct(String bankAcct, String replacement) {
        if (bankAcct == null) {
            return "";
        }
        return DesensitizeUtil.replaceBetween(bankAcct, 6, bankAcct.length() - 4, replacement);
    }

    public static String encryptIdCard(String idCard, String replacement) {
        if (idCard == null) {
            return "";
        }
        return DesensitizeUtil.replaceBetween(idCard, 6, idCard.length() - 4, replacement);
    }

    public static String encryptEmail(String email, String replacement) {
        if (email == null || !Pattern.matches(EMAIL_REG, email)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(email);
        int at_position = sb.indexOf("@");
        if (at_position > 2) {
            sb.replace(2, at_position, DesensitizeUtil.repeat(replacement, at_position - 2));
        }
        int period_position = sb.lastIndexOf(".");
        sb.replace(at_position + 1, period_position, DesensitizeUtil.repeat(replacement, period_position - at_position - 1));
        return sb.toString();
    }

    public static String encryptPhoneNo(String phoneNo, String replacement) {
        if (phoneNo == null) {
            return "";
        }
        return DesensitizeUtil.replaceBetween(phoneNo, 3, phoneNo.length() - 4, replacement);
    }

    public static String encryptSensitiveInfo(String sourceStr, String replacement) {
        if (sourceStr == null) {
            return "";
        }
        if (Pattern.matches(PHONE_REG, sourceStr)) {
            return DesensitizeUtil.encryptPhoneNo(sourceStr, replacement);
        }
        if (Pattern.matches(EMAIL_REG, sourceStr)) {
            return DesensitizeUtil.encryptEmail(sourceStr, replacement);
        }
        if (Pattern.matches(BANK_CARD_NUMBER, sourceStr)) {
            return DesensitizeUtil.encryptBankAcct(sourceStr, replacement);
        }
        if (Pattern.matches(ID_CARD, sourceStr)) {
            return DesensitizeUtil.encryptIdCard(sourceStr, replacement);
        }
        return DesensitizeUtil.replaceSecretInfo(sourceStr, replacement);
    }

    private static String replaceBetween(String sourceStr, int begin, int end, String replacement) {
        if (sourceStr == null) {
            return "";
        }
        if (replacement == null) {
            replacement = "*";
        }
        int replaceLength = end - begin;
        if (replacement.length() > 0 && replaceLength > 0) {
            StringBuilder sb = new StringBuilder(sourceStr);
            sb.replace(begin, end, DesensitizeUtil.repeat(replacement, replaceLength));
            return sb.toString();
        }
        return sourceStr;
    }

    private static String repeat(String value, int count) {
        String result = "";
        if (count > 0 && value != null && !"".equals(value)) {
            for (int i = 0; i < count; ++i) {
                result = result.concat(value);
            }
        }
        return result;
    }
}

