/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.mybatis.encrypt.utils;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static final Logger log = LoggerFactory.getLogger(AESUtil.class);
    private static final String ALGORITHM = "AES";

    private static byte[] encrypt(String key, String content) {
        byte[] rawKey = AESUtil.genKey(key.getBytes());
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(rawKey, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, secretKeySpec);
            byte[] encypted = cipher.doFinal(content.getBytes());
            return encypted;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encryptBase64(String key, String content) {
        byte[] encrypt = AESUtil.encrypt(key, content);
        return Base64.getEncoder().encodeToString(encrypt);
    }

    public static String decryptBase64(String key, String content) {
        byte[] decodeContent = Base64.getDecoder().decode(content);
        return AESUtil.decrypt(key, decodeContent);
    }

    private static String decrypt(String key, byte[] encrypted) {
        byte[] rawKey = AESUtil.genKey(key.getBytes());
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(rawKey, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, secretKeySpec);
            byte[] decrypted = cipher.doFinal(encrypted);
            return new String(decrypted);
        }
        catch (Exception e) {
            log.debug("\u89e3\u5bc6\u5931\u8d25\u4ee5\u4e3a\u4f60\u8fd4\u56de\u539f\u503c");
            return "";
        }
    }

    private static byte[] genKey(byte[] seed) {
        byte[] rawKey = null;
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(seed);
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            rawKey = secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return rawKey;
    }
}

