/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.mybatis.encrypt.interceptor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.msop.core.mybatis.encrypt.annotation.FieldDesensitize;
import tech.msop.core.mybatis.encrypt.desensitize.IDesensitize;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DesensitizeInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DesensitizeInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        return this.selectHandle(invocation);
    }

    private Object selectHandle(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        List resultList = executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        for (Object object : resultList) {
            HashMap<Field, Object> fieldObjectHashMap = new HashMap<Field, Object>();
            if (object != null) {
                this.handleObject(object, object.getClass(), fieldObjectHashMap);
            }
            fieldObjectHashMap.keySet().forEach(key -> {
                try {
                    this.handleString((Field)key, fieldObjectHashMap.get(key));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            });
        }
        return resultList;
    }

    private boolean isFilter(Object object) {
        return object == null || object instanceof CharSequence || object instanceof Number || object instanceof Collection || object instanceof Date || object instanceof ChronoLocalDate;
    }

    private List<Field> mergeField(Class<?> oClass, List<Field> fields) {
        Class<?> superclass;
        if (fields == null) {
            fields = new ArrayList<Field>();
        }
        if ((superclass = oClass.getSuperclass()) != null && !superclass.equals(Object.class) && superclass.getDeclaredFields().length > 0) {
            this.mergeField(superclass, fields);
        }
        for (Field declaredField : oClass.getDeclaredFields()) {
            int modifiers = declaredField.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isVolatile(modifiers) || Modifier.isSynchronized(modifiers)) continue;
            fields.add(declaredField);
        }
        return fields;
    }

    private void handleObject(Object obj, Class<?> oClass, HashMap<Field, Object> fieldObjectHashMap) throws IllegalAccessException {
        if (this.isFilter(obj)) {
            return;
        }
        List<Field> fields = this.mergeField(oClass, null);
        for (Field declaredField : fields) {
            if (Modifier.isStatic(declaredField.getModifiers())) continue;
            boolean accessible = declaredField.isAccessible();
            declaredField.setAccessible(true);
            Object value = declaredField.get(obj);
            declaredField.setAccessible(accessible);
            if (value == null || value instanceof Number) continue;
            if (value instanceof String) {
                FieldDesensitize annotation = declaredField.getAnnotation(FieldDesensitize.class);
                if (annotation == null) continue;
                fieldObjectHashMap.put(declaredField, obj);
                continue;
            }
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                for (Object o : coll) {
                    if (this.isFilter(o)) break;
                    this.handleObject(o, o.getClass(), fieldObjectHashMap);
                }
                continue;
            }
            this.handleObject(value, value.getClass(), fieldObjectHashMap);
        }
    }

    private void handleString(Field field, Object object) throws IllegalAccessException, InstantiationException {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object value = field.get(object);
        FieldDesensitize annotation = field.getAnnotation(FieldDesensitize.class);
        if (annotation != null) {
            String fillValue = annotation.fillValue();
            Class<? extends IDesensitize> desensitize = annotation.desensitize();
            IDesensitize iDesensitize = desensitize.newInstance();
            String desensitizeValue = iDesensitize.execute(String.valueOf(value), fillValue);
            log.debug("\u539f\u503c\uff1a" + value);
            log.debug("\u8131\u654f\u540e\uff1a" + desensitizeValue);
            field.set(object, String.valueOf(desensitizeValue));
            field.setAccessible(accessible);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

